/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.token;

import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.token.TokenRefresher;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.TimeUnit;

public class RETokenRefresher
implements TokenRefresher {
    private final RECore core;
    private final String pathKeystore;
    private final byte[] keyFromCore;
    private final long entMgrId;

    public RETokenRefresher(RECore core, String pathKeystore, byte[] keyFromCore, long entMgrId) {
        this.core = core;
        this.pathKeystore = pathKeystore;
        this.keyFromCore = keyFromCore != null ? (byte[])keyFromCore.clone() : null;
        this.entMgrId = entMgrId;
    }

    public String refreshToken(String currentToken) throws SeeTecException {
        EntMgrProxy entMgrProxy = this.core.getEntMgrProxy();
        if (entMgrProxy != null) {
            return entMgrProxy.refreshToken(currentToken, TimeUnit.SECONDS.toMillis(30L));
        }
        throw new SeeTecException(-21001, "EntMgrProxy not ready");
    }

    public String getNewToken() throws SeeTecException {
        try {
            return this.core.getTokenAndEncryptionKeyFromCore(this.pathKeystore, this.keyFromCore, this.entMgrId);
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-21002, ex.getMessage());
        }
    }
}

