/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.timerange;

import de.seetec.v5.re.shared.timerange.TimeRange;
import de.seetec.v5.re.shared.timerange.TimeRangeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class TimeRangeList
extends ArrayList<TimeRangeInfo> {
    private static final long serialVersionUID = -7552482326892649877L;
    private boolean containsFailoverData = false;
    private boolean containsDefaultData = false;
    private Long startTimestamp = 0L;

    public TimeRangeList() {
    }

    public TimeRangeList(TimeRangeList timeRangeInfoList) {
        for (TimeRangeInfo timeRangeInfo : timeRangeInfoList) {
            if (timeRangeInfo.isFailover()) {
                this.containsFailoverData = true;
            }
            this.add(new TimeRangeInfo(timeRangeInfo.getTimestamp(), timeRangeInfo.getLength(), timeRangeInfo.getTrack(), timeRangeInfo.isFailover()));
        }
    }

    @Override
    public boolean add(TimeRangeInfo timeRangeInfo) {
        if (timeRangeInfo.isFailover()) {
            this.containsFailoverData = true;
        } else {
            this.containsDefaultData = true;
        }
        return super.add(timeRangeInfo);
    }

    @Override
    public void add(int index, TimeRangeInfo timeRangeInfo) {
        if (timeRangeInfo.isFailover()) {
            this.containsFailoverData = true;
        } else {
            this.containsDefaultData = true;
        }
        super.add(index, timeRangeInfo);
    }

    @Override
    public boolean addAll(Collection<? extends TimeRangeInfo> list) {
        for (TimeRangeInfo timeRangeInfo : list) {
            if (timeRangeInfo.isFailover()) {
                this.containsFailoverData = true;
                continue;
            }
            this.containsDefaultData = true;
        }
        return super.addAll(list);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TimeRangeInfo> list) {
        for (TimeRangeInfo timeRangeInfo : list) {
            if (timeRangeInfo.isFailover()) {
                this.containsFailoverData = true;
                continue;
            }
            this.containsDefaultData = true;
        }
        return super.addAll(index, list);
    }

    public TimeRangeInfo getTimeRangeInfoAtTimestamp(long timestamp) {
        for (TimeRangeInfo timeRangeInfo : this) {
            if (!timeRangeInfo.containsTimestamp(timestamp)) continue;
            return timeRangeInfo;
        }
        return null;
    }

    public TimeRangeInfo getNextTimeRangeInfo(long timestamp) {
        long time = timestamp - this.startTimestamp;
        TimeRangeInfo timeRangeInfo = this.getTimeRangeInfoAtTimestamp(time);
        if (timeRangeInfo != null) {
            return timeRangeInfo;
        }
        if (this.isEmpty()) {
            return null;
        }
        if (this.size() == 1 && time < ((TimeRangeInfo)this.get(0)).getTimestamp()) {
            return (TimeRangeInfo)this.get(0);
        }
        if (time > ((TimeRangeInfo)this.get(this.size() - 1)).getTimestamp() + (long)((TimeRangeInfo)this.get(this.size() - 1)).getLength()) {
            return null;
        }
        for (TimeRangeInfo tri : this) {
            if (tri.getTimestamp() <= time) continue;
            return tri;
        }
        return null;
    }

    public TimeRangeInfo getPreviousTimeRangeInfo(long timestamp) {
        long time = timestamp - this.startTimestamp;
        if (this.isEmpty() || this.size() == 1 && time < ((TimeRangeInfo)this.get(0)).getTimestamp()) {
            return null;
        }
        TimeRangeInfo resultTimeRangeInfo = this.getTimeRangeInfoAtTimestamp(time);
        if (resultTimeRangeInfo == null) {
            resultTimeRangeInfo = this.getTimeRangeInfoBeforeTimestamp(time);
        }
        return resultTimeRangeInfo;
    }

    private TimeRangeInfo getTimeRangeInfoBeforeTimestamp(long timestamp) {
        TimeRangeInfo resultTimeRangeInfo = null;
        long msToTargetTimestamp = Long.MAX_VALUE;
        for (int i = this.size() - 1; i >= 0; --i) {
            TimeRangeInfo timeRangeInfo = (TimeRangeInfo)this.get(i);
            long endOfTimeRangeInfo = timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength();
            if (endOfTimeRangeInfo >= timestamp || timestamp - endOfTimeRangeInfo >= msToTargetTimestamp) continue;
            msToTargetTimestamp = timestamp - endOfTimeRangeInfo;
            resultTimeRangeInfo = timeRangeInfo;
        }
        return resultTimeRangeInfo;
    }

    private boolean isInMiddleOfPackage(long timestamp) {
        TimeRangeInfo t = this.getTimeRangeInfoAtTimestamp(timestamp);
        return t != null && t.getTimestamp() < timestamp && t.getTimestamp() + (long)t.getLength() > timestamp;
    }

    private TimeRangeList insertTimeRangeInfo(TimeRangeInfo timeRangeInfo) {
        TimeRangeList timeRangeInfoList = new TimeRangeList(this);
        if (timeRangeInfo == null) {
            return timeRangeInfoList;
        }
        long endTimeStamp = timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength();
        if (timeRangeInfoList.isEmpty()) {
            timeRangeInfoList.add(timeRangeInfo);
            if (timeRangeInfo.isFailover()) {
                timeRangeInfoList.setContainsFailoverData(true);
            }
            return timeRangeInfoList;
        }
        for (int i = 0; i < timeRangeInfoList.size(); ++i) {
            TimeRangeInfo timeRangeInfoFromList = (TimeRangeInfo)timeRangeInfoList.get(i);
            if (timeRangeInfoFromList.getTimestamp() >= endTimeStamp) continue;
            timeRangeInfoList.add(i, timeRangeInfo);
            if (timeRangeInfo.isFailover()) {
                timeRangeInfoList.setContainsFailoverData(true);
            }
            return timeRangeInfoList;
        }
        return timeRangeInfoList;
    }

    public void setStartTimestamp(Long startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public Long getStartTimestamp() {
        return this.startTimestamp;
    }

    public Long calculateRelativeTimestamp(Long absoluteTimestamp) {
        return absoluteTimestamp - this.getStartTimestamp();
    }

    public boolean containsFailoverData() {
        return this.containsFailoverData;
    }

    private void setContainsFailoverData(boolean containsFailoverData) {
        this.containsFailoverData = containsFailoverData;
    }

    public boolean containsDefaultData() {
        return this.containsDefaultData;
    }

    public LinkedList<Long[]> getLinkedListWithoutFailover() {
        LinkedList<Long[]> listForClient = new LinkedList<Long[]>();
        this.forEach((? super E timeRangeInfo) -> listForClient.add(new Long[]{timeRangeInfo.getTimestamp(), timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength()}));
        return listForClient;
    }

    public TimeRangeList getTimeRangeInfoForTimerange(Long from, Long till, Integer track) {
        TimeRangeList timeRangeInfoList = new TimeRangeList();
        for (TimeRangeInfo ri : this) {
            TimeRangeInfo timeRangeInfo = new TimeRangeInfo(ri);
            if (timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength() + this.startTimestamp < from || timeRangeInfo.getTimestamp() + this.startTimestamp > till || track.byteValue() != -1 && track.byteValue() != timeRangeInfo.getTrack()) continue;
            if (timeRangeInfo.getTimestamp() + this.startTimestamp < from) {
                long oldTimestamp = timeRangeInfo.getTimestamp();
                timeRangeInfo.setTimestamp(from - this.startTimestamp);
                timeRangeInfo.setLength((int)((long)timeRangeInfo.getLength() - (timeRangeInfo.getTimestamp() - oldTimestamp)));
            }
            if (till < timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength() + this.startTimestamp) {
                timeRangeInfo.setLength((int)(till - timeRangeInfo.getTimestamp() - this.startTimestamp));
            }
            timeRangeInfoList.add(timeRangeInfo);
        }
        return timeRangeInfoList;
    }

    private TimeRangeList splitTimeRangeInfoAt(TimeRangeInfo givenTimeRangeInfo) {
        long startTimeStamp = givenTimeRangeInfo.getTimestamp();
        long endTimeStamp = givenTimeRangeInfo.getTimestamp() + (long)givenTimeRangeInfo.getLength();
        TimeRangeList timeRangeInfoList = new TimeRangeList(this);
        TimeRangeInfo startFoundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(startTimeStamp);
        TimeRangeInfo endFoundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(endTimeStamp);
        if (startFoundTimeRangeInfo != null && endFoundTimeRangeInfo != null && startFoundTimeRangeInfo.equals(endFoundTimeRangeInfo) && timeRangeInfoList.isInMiddleOfPackage(startTimeStamp) && timeRangeInfoList.isInMiddleOfPackage(endTimeStamp)) {
            TimeRangeInfo timeRangeInfo1 = new TimeRangeInfo(startTimeStamp, (int)(endTimeStamp - startTimeStamp), startFoundTimeRangeInfo.getTrack(), startFoundTimeRangeInfo.isFailover());
            timeRangeInfoList = timeRangeInfoList.insertTimeRangeInfo(timeRangeInfo1);
            TimeRangeInfo timeRangeInfo2 = new TimeRangeInfo(startFoundTimeRangeInfo.getTimestamp(), (int)(startTimeStamp - startFoundTimeRangeInfo.getTimestamp()), startFoundTimeRangeInfo.getTrack(), startFoundTimeRangeInfo.isFailover());
            timeRangeInfoList = timeRangeInfoList.insertTimeRangeInfo(timeRangeInfo2);
            TimeRangeInfo timeRangeInfo3 = new TimeRangeInfo(endTimeStamp, (int)(startFoundTimeRangeInfo.getTimestamp() + (long)startFoundTimeRangeInfo.getLength() - endTimeStamp), startFoundTimeRangeInfo.getTrack(), startFoundTimeRangeInfo.isFailover());
            timeRangeInfoList = timeRangeInfoList.insertTimeRangeInfo(timeRangeInfo3);
            timeRangeInfoList.remove(startFoundTimeRangeInfo);
        } else {
            TimeRangeInfo[] timeRangeInfos;
            TimeRangeInfo foundTimeRangeInfo;
            if (timeRangeInfoList.isInMiddleOfPackage(startTimeStamp)) {
                foundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(startTimeStamp);
                timeRangeInfos = this.splitTimeRangeInfoByTimeStamp(foundTimeRangeInfo, startTimeStamp);
                timeRangeInfoList.add(timeRangeInfos[0]);
                timeRangeInfoList.add(timeRangeInfos[1]);
                timeRangeInfoList.remove(foundTimeRangeInfo);
            }
            if (timeRangeInfoList.isInMiddleOfPackage(endTimeStamp)) {
                foundTimeRangeInfo = timeRangeInfoList.getTimeRangeInfoAtTimestamp(endTimeStamp);
                timeRangeInfos = this.splitTimeRangeInfoByTimeStamp(foundTimeRangeInfo, endTimeStamp);
                timeRangeInfoList.add(timeRangeInfos[0]);
                timeRangeInfoList.add(timeRangeInfos[1]);
                timeRangeInfoList.remove(foundTimeRangeInfo);
            }
        }
        return timeRangeInfoList;
    }

    private TimeRangeInfo[] splitTimeRangeInfoByTimeStamp(TimeRangeInfo timeRangeInfo, long timeStampToSplit) {
        TimeRangeInfo leftTimeRangeInfo = new TimeRangeInfo(timeRangeInfo.getTimestamp(), (int)(timeStampToSplit - timeRangeInfo.getTimestamp()), timeRangeInfo.getTrack(), timeRangeInfo.isFailover());
        TimeRangeInfo rightTimeRangeInfo = new TimeRangeInfo(timeStampToSplit, (int)(timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength() - timeStampToSplit), timeRangeInfo.getTrack(), timeRangeInfo.isFailover());
        return new TimeRangeInfo[]{leftTimeRangeInfo, rightTimeRangeInfo};
    }

    public TimeRangeList dissect(TimeRangeList timeRangeInfoList) {
        TimeRangeList timeRangeInfoListLocal = new TimeRangeList(this);
        for (TimeRangeInfo timeRangeInfo : timeRangeInfoList) {
            timeRangeInfoListLocal = timeRangeInfoListLocal.splitTimeRangeInfoAt(timeRangeInfo);
        }
        return timeRangeInfoListLocal;
    }

    public TimeRangeList purge(TimeRangeList timeRangeInfoList) {
        TimeRangeList timeRangeInfoListLocal = new TimeRangeList(this);
        for (TimeRangeInfo externalTimeRangeInfo : timeRangeInfoList) {
            boolean internalTrackIsAlarm;
            long timestampExternalTimeRangeInfo = externalTimeRangeInfo.getTimestamp();
            TimeRangeInfo internalTimeRangeInfo = timeRangeInfoListLocal.getTimeRangeInfoAtTimestamp(timestampExternalTimeRangeInfo);
            if (internalTimeRangeInfo == null || internalTimeRangeInfo.getTimestamp() != externalTimeRangeInfo.getTimestamp() || internalTimeRangeInfo.getLength() != externalTimeRangeInfo.getLength()) continue;
            boolean externalTrackIsAlarm = externalTimeRangeInfo.getTrack() != 1;
            boolean bl = internalTrackIsAlarm = internalTimeRangeInfo.getTrack() != 1;
            if (!(externalTrackIsAlarm && !externalTimeRangeInfo.isFailover() || !internalTrackIsAlarm && internalTimeRangeInfo.isFailover()) && (!externalTrackIsAlarm || internalTrackIsAlarm)) continue;
            timeRangeInfoListLocal.remove(internalTimeRangeInfo);
        }
        return timeRangeInfoListLocal;
    }

    public TimeRangeList cleanAndMerge(long cumulationDistance) {
        long distance = cumulationDistance <= 0L ? 5000L : cumulationDistance;
        TimeRangeList timeRangeInfoList = new TimeRangeList(this);
        int pointer = 0;
        while (pointer < timeRangeInfoList.size() - 1) {
            long newLength;
            TimeRangeInfo currentTimeRangeInfo = (TimeRangeInfo)timeRangeInfoList.get(pointer);
            TimeRangeInfo nextTimeRangeInfo = (TimeRangeInfo)timeRangeInfoList.get(pointer + 1);
            if (currentTimeRangeInfo.getTrack() == nextTimeRangeInfo.getTrack() && currentTimeRangeInfo.getTimestamp() + (long)currentTimeRangeInfo.getLength() + distance >= nextTimeRangeInfo.getTimestamp() && TimeRangeInfo.isValidLength(newLength = nextTimeRangeInfo.getTimestamp() + (long)nextTimeRangeInfo.getLength() - currentTimeRangeInfo.getTimestamp())) {
                currentTimeRangeInfo.setLength((int)newLength);
                timeRangeInfoList.remove(pointer + 1);
                continue;
            }
            ++pointer;
        }
        return timeRangeInfoList;
    }

    public void rebase(long aNewOffset) {
        long diff = this.getStartTimestamp() - aNewOffset;
        if (diff != 0L) {
            for (TimeRangeInfo ref : this) {
                ref.setTimestamp(ref.getTimestamp() + diff);
            }
            this.startTimestamp = aNewOffset;
        }
    }

    public List<TimeRange> getGaps() {
        return this.getGaps(this);
    }

    private List<TimeRange> getGaps(TimeRangeList timeRangeListToSearchForGaps) {
        long cumulationDistance = TimeUnit.SECONDS.toMillis(3L);
        ArrayList<TimeRange> timeRanges = new ArrayList<TimeRange>();
        Collections.sort(timeRangeListToSearchForGaps);
        for (int i = 0; i < timeRangeListToSearchForGaps.size() - 1; ++i) {
            TimeRangeInfo timeRangeInfo = (TimeRangeInfo)timeRangeListToSearchForGaps.get(i);
            TimeRangeInfo nextTimeRangeInfo = (TimeRangeInfo)timeRangeListToSearchForGaps.get(i + 1);
            long endTimestamp = timeRangeListToSearchForGaps.getStartTimestamp() + timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength();
            long nextStartTimestamp = timeRangeListToSearchForGaps.getStartTimestamp() + nextTimeRangeInfo.getTimestamp();
            if (nextStartTimestamp - endTimestamp <= cumulationDistance) continue;
            timeRanges.add(new TimeRange(endTimestamp, nextStartTimestamp));
        }
        return timeRanges;
    }

    public List<TimeRange> getGapsInProductive() {
        TimeRangeList onlyTimeRangesFromProductive = new TimeRangeList();
        this.stream().filter(timeRangeInfo -> !timeRangeInfo.isFailover()).forEachOrdered(timeRangeInfo -> onlyTimeRangesFromProductive.add((TimeRangeInfo)timeRangeInfo));
        if (onlyTimeRangesFromProductive.isEmpty()) {
            ArrayList<TimeRange> allFailoverTimeRanges = new ArrayList<TimeRange>();
            this.stream().forEachOrdered(timeRangeInfo -> allFailoverTimeRanges.add(new TimeRange(timeRangeInfo.getTimestamp(), timeRangeInfo.getTimestamp() + (long)timeRangeInfo.getLength())));
            return allFailoverTimeRanges;
        }
        return this.getGaps(onlyTimeRangesFromProductive);
    }
}

