/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.timerange;

import java.util.Date;
import java.util.List;
import java.util.Objects;

public final class TimeRange
implements Comparable<TimeRange> {
    private final long startTimestamp;
    private long endTimestamp;
    private String nameOfTimerange = "";

    public TimeRange(long startTimestamp, long endTimestamp) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    public TimeRange(long startTimestamp, long endTimestamp, String nameOfTimerange) {
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.nameOfTimerange = nameOfTimerange;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getEndTimestamp() {
        return this.endTimestamp;
    }

    public String getNameOfTimerange() {
        return this.nameOfTimerange;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TimeRange)) {
            return false;
        }
        TimeRange timeRange = (TimeRange)object;
        return timeRange.getStartTimestamp() == this.startTimestamp && timeRange.getEndTimestamp() == this.endTimestamp;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (int)(this.startTimestamp ^ this.startTimestamp >>> 32);
        hash = 31 * hash + (int)(this.endTimestamp ^ this.endTimestamp >>> 32);
        hash = 31 * hash + Objects.hashCode(this.nameOfTimerange);
        return hash;
    }

    public boolean isSimilar(TimeRange timeRange, long maxDeviation) {
        return Math.abs(timeRange.getStartTimestamp() - this.startTimestamp) <= maxDeviation && Math.abs(timeRange.getEndTimestamp() - this.endTimestamp) <= maxDeviation;
    }

    @Override
    public int compareTo(TimeRange timeRange) {
        return Long.signum(this.getStartTimestamp() - timeRange.getStartTimestamp());
    }

    public boolean isPartOf(TimeRange timeRange) {
        boolean result = false;
        if (this.startTimestamp >= timeRange.getStartTimestamp() && this.startTimestamp <= timeRange.getEndTimestamp()) {
            result = true;
        } else if (this.endTimestamp <= timeRange.getEndTimestamp() && this.endTimestamp >= timeRange.getStartTimestamp()) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return "Timerange: " + new Date(this.startTimestamp) + " - " + new Date(this.endTimestamp) + "\r\n(" + this.startTimestamp + " - " + this.endTimestamp + ")  " + this.nameOfTimerange;
    }

    public boolean isContainedIn(List<TimeRange> gapList) {
        for (TimeRange timeRange : gapList) {
            boolean endsAfterStartOfOtherTimeRange;
            boolean startsBeforeEndOfOtherTimeRange = this.startTimestamp < timeRange.getEndTimestamp();
            boolean bl = endsAfterStartOfOtherTimeRange = this.endTimestamp > timeRange.getStartTimestamp();
            if (!startsBeforeEndOfOtherTimeRange || !endsAfterStartOfOtherTimeRange) continue;
            return true;
        }
        return false;
    }

    public long getLength() {
        return this.endTimestamp - this.startTimestamp;
    }

    public void setEndTimestamp(long endTimestamp) {
        this.endTimestamp = endTimestamp;
    }
}

