/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.re.shared.ExportDirectoryEntry;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;

public class RspStartExportDownload {
    private int resultCode;
    private final List<ExportDirectoryEntry> fileList;

    public RspStartExportDownload(int resultCode, List<ExportDirectoryEntry> fileList) throws SeeTecException {
        this.resultCode = resultCode;
        this.fileList = fileList;
        if (this.fileList == null) {
            throw new SeeTecException(-20002, "Parameter null");
        }
    }

    public List<ExportDirectoryEntry> getFileList() {
        return this.fileList;
    }

    public int getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public static RspStartExportDownload parseGObject(GObject goRequest) throws SeeTecException {
        ArrayList<ExportDirectoryEntry> exportDirectoryEntries = new ArrayList<ExportDirectoryEntry>();
        int result = goRequest.getChildAt(0).getAsInt();
        goRequest.getChildAt(1).getChildren().forEach(goList -> exportDirectoryEntries.add(new ExportDirectoryEntry(goList.getChildAt(0).getAsString(), goList.getChildAt(1).getAsString(), goList.getChildAt(2).getAsLong())));
        return new RspStartExportDownload(result, exportDirectoryEntries);
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(Integer.valueOf(this.resultCode));
        GObject goFileList = GObject.createList();
        for (ExportDirectoryEntry exportDirectoryEntry : this.fileList) {
            GObject goFileMetadata = GObject.createList();
            goFileMetadata.addChild(exportDirectoryEntry.getRelativeFilePath());
            goFileMetadata.addChild(exportDirectoryEntry.getFileHash());
            goFileMetadata.addChild(Long.valueOf(exportDirectoryEntry.getFileLength()));
            goFileList.addChild(goFileMetadata);
        }
        goResponse.addChild(goFileList);
        return goResponse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[" + Methods.MD_REQ_STARTEXPORTDOWNLOAD.methodName() + ", ResultCode=[" + this.resultCode + "], FileList=[");
        this.fileList.stream().forEach(exportDirectoryEntry -> sb.append(exportDirectoryEntry));
        sb.append("]]");
        return sb.toString();
    }
}

