/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.srpc;

import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import java.util.concurrent.TimeUnit;

public final class ReqGetImportInfo {
    private final String path;
    private final String pass;
    private Long timeout = TimeUnit.SECONDS.toMillis(30L);

    public ReqGetImportInfo(String path, String pass, Long timeout) {
        this.path = path;
        this.pass = pass;
        if (timeout != null) {
            this.timeout = timeout;
        }
    }

    public static ReqGetImportInfo parseGObject(GObject goRequest) {
        String path = goRequest.getChildAt(0).getAsString();
        String pass = goRequest.getChildAt(1).getAsString();
        Long timeout = null;
        if (goRequest.getChildren().size() > 2) {
            timeout = goRequest.getChildAt(2).tryGetAsLong();
        }
        return new ReqGetImportInfo(path, pass, timeout);
    }

    public GObject createGObject() {
        GObject gobject = GObject.createList();
        gobject.addChild(this.path);
        gobject.addChild(this.pass);
        gobject.addChild(this.timeout);
        return gobject;
    }

    public String getPath() {
        return this.path;
    }

    public String getPass() {
        return this.pass;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String toString() {
        return "[" + Methods.MD_REQ_GETIMPORTINFO.methodName() + ", Path=[" + this.path + "], Timeout=[" + this.timeout + "]]";
    }
}

