/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared.license;

import de.seetec.v5.re.shared.license.LicenseRepository;
import de.seetec.v5.re.shared.license.LicenseTags;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.configuration.key.Features;
import de.seetec.v5.shared.configuration.key.LicenseKey;
import de.seetec.v5.shared.configuration.key.Modules;
import de.seetec.v5.shared.interaction.LicenseDataObject;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlElement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public final class LicenseRepositoryImpl
implements LicenseRepository {
    private final Logger logger = LogManager.getLogger(LicenseRepositoryImpl.class);
    private final long timeout = TimeUnit.SECONDS.toMillis(30L);
    private final EntMgrProxy proxy;
    private LicenseKey licenseKey;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public LicenseRepositoryImpl(EntMgrProxy proxy) throws SeeTecException {
        this.proxy = proxy;
        if (this.proxy == null) {
            throw new IllegalArgumentException("Parameter proxy is null");
        }
        this.updateLicense();
    }

    @Override
    public void updateLicense() throws SeeTecException {
        this.readWriteLock.writeLock().lock();
        try {
            this.licenseKey = this.getLicenseFromCoreService();
            String message = this.licenseKey == null ? "No license - Trial period" : "successful";
            this.logger.info("Getting license from CoreService: " + message);
        }
        catch (SeeTecException exception) {
            this.logger.error("Error getting license from CoreService: " + exception.getMessage());
            throw exception;
        }
        catch (UnsupportedEncodingException | JAXBException | SAXException exception) {
            this.logger.error("Error getting license from CoreService: " + exception.getMessage());
            throw new SeeTecException(-21000, "Cannot deserialize license information", exception);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isFeatureActivated(LicenseTags licenseTag) throws SeeTecException {
        if (licenseTag == null) {
            throw new IllegalArgumentException("Parameter licenseTag is null");
        }
        if (this.isTrialPeriod()) {
            return true;
        }
        Field foundField = this.getFieldForLicenseTag(Features.class, licenseTag);
        try {
            Object value = foundField.get(this.licenseKey.getLicenseInfo().getFeatures());
            if (value == null) {
                throw new SeeTecException(-21060, "Feature " + licenseTag.getLicenseTag() + " not availavle in license.");
            }
            return (Boolean)value;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new SeeTecException(-21000, "Cannot get value of feature " + licenseTag.getLicenseTag() + ": " + exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public long getModuleCount(LicenseTags licenseTag) throws SeeTecException {
        if (licenseTag == null) {
            throw new IllegalArgumentException("Parameter licenseTag is null");
        }
        if (this.isTrialPeriod()) {
            return Long.MAX_VALUE;
        }
        Field foundField = this.getFieldForLicenseTag(Modules.class, licenseTag);
        try {
            Object value = foundField.get(this.licenseKey.getLicenseInfo().getModules());
            if (value == null) {
                throw new SeeTecException(-21060, "Module " + licenseTag.getLicenseTag() + " not availavle in license");
            }
            return (Long)value;
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            throw new SeeTecException(-21000, "Cannot get value of module " + licenseTag.getLicenseTag() + ": " + exception.getMessage(), (Throwable)exception);
        }
    }

    private <T> Field getFieldForLicenseTag(Class<T> clazz, LicenseTags licenseTag) {
        List<Field> fields = Arrays.asList(clazz.getDeclaredFields());
        Optional<Field> foundField = fields.stream().filter(f -> f.getAnnotation(XmlElement.class) != null).filter(f -> f.getAnnotation(XmlElement.class).name().equals(licenseTag.getLicenseTag())).findFirst();
        if (!foundField.isPresent()) {
            throw new RuntimeException("Field for licenseTag " + licenseTag.getLicenseTag() + " not availavle");
        }
        foundField.get().setAccessible(true);
        return foundField.get();
    }

    private LicenseKey getLicenseFromCoreService() throws SeeTecException, SAXException, JAXBException, UnsupportedEncodingException {
        LicenseDataObject license = this.proxy.getLicense(this.timeout);
        if (license.getValue() == null) {
            return null;
        }
        String licenseAsString = new String((byte[])license.getValue(), "UTF-8");
        return (LicenseKey)Basic.unmarshalXML(LicenseKey.class, (Object)licenseAsString, (boolean)false);
    }

    private boolean isTrialPeriod() {
        return this.licenseKey == null;
    }
}

