/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.DayRange;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.configuration.timepattern.ArrayOfLong;
import de.seetec.v5.shared.configuration.timepattern.TimePattern;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import de.seetec.v5.shared.util.WorkCenterCalendarRepository;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TimerangeCnf {
    private DayRange[] dayRanges = null;
    private DayRange holidayRange = null;
    private final WorkCenterCalendarRepository workCenterCalendarRepository;
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private List<Long> selectedCalendars;

    public TimerangeCnf(WorkCenterCalendarRepository workCenterCalendarRepository) throws SeeTecException {
        this.workCenterCalendarRepository = workCenterCalendarRepository;
        if (this.workCenterCalendarRepository == null) {
            throw new SeeTecException(-21001, "workCenterCalendarRepository is null");
        }
        this.dayRanges = new DayRange[7];
        this.selectedCalendars = new ArrayList<Long>();
    }

    public void init(boolean alwaysOrNever) {
        long[][] ranges = new long[1][2];
        if (alwaysOrNever) {
            ranges[0][0] = 0L;
            ranges[0][1] = 86400000L;
        } else {
            ranges[0][0] = 0L;
            ranges[0][1] = 0L;
        }
        for (int i = 0; i < 7; ++i) {
            this.dayRanges[i] = new DayRange(ranges);
        }
        this.holidayRange = new DayRange(ranges);
    }

    public int init(byte[] configuration) {
        try {
            TimePattern timePattern = (TimePattern)Basic.unmarshalXML(TimePattern.class, (Object)configuration, (boolean)false);
            if (timePattern.getCalendarIds() == null) {
                this.selectedCalendars.add(1051L);
            } else {
                this.selectedCalendars = timePattern.getCalendarIds().getLong();
            }
            for (int i = 0; i < 7; ++i) {
                this.dayRanges[i] = new DayRange(this.getTimestampPairs(((ArrayOfLong)timePattern.getRanges().getArrayOfLong().get((i + 6) % 7)).getLong()));
            }
            this.holidayRange = timePattern.getRanges().getArrayOfLong().size() > 7 ? new DayRange(this.getTimestampPairs(((ArrayOfLong)timePattern.getRanges().getArrayOfLong().get(7)).getLong())) : new DayRange(new long[0][2]);
        }
        catch (Throwable ex) {
            this.logger.error("Parsing configuration failed for " + this, ex);
            return -21002;
        }
        return 0;
    }

    private long[][] getTimestampPairs(List<Long> timestamps) throws ConfigurationException {
        long[][] ranges = new long[timestamps.size() / 2][2];
        for (int j = 0; j < timestamps.size(); j += 2) {
            long tsStart = timestamps.get(j);
            long tsEnd = timestamps.get(j + 1);
            ranges[j / 2][0] = tsStart;
            ranges[j / 2][1] = tsEnd;
        }
        return ranges;
    }

    public long getExpirationTime(long timestamp) {
        if (this.isHoliday(timestamp)) {
            return this.holidayRange.getExpirationTime(timestamp);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timestamp);
        int[] dayConstants = new int[]{1, 2, 3, 4, 5, 6, 7};
        for (int i = 0; i < dayConstants.length; ++i) {
            if (calendar.get(7) != dayConstants[i]) continue;
            return this.dayRanges[i].getExpirationTime(timestamp);
        }
        throw new RuntimeException("Cannot handle DayOfWeek [" + calendar.get(7) + "]");
    }

    public long[][] getTimeranges(long timestamp) throws ConfigurationException {
        if (this.isHoliday(timestamp)) {
            return this.holidayRange.getRanges();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(timestamp));
        return this.dayRanges[calendar.get(7) - 1].getRanges();
    }

    public long[][] getTimeranges(long tsStart, long tsEnd) throws ConfigurationException {
        LinkedList<long[]> absoluteTimeranges = new LinkedList<long[]>();
        this.getAbsoluteTimeranges(tsStart, absoluteTimeranges);
        if (TimeHelper.getDaysSince1970((long)tsStart) != TimeHelper.getDaysSince1970((long)tsEnd)) {
            this.getAbsoluteTimeranges(tsEnd, absoluteTimeranges);
        }
        for (int i = absoluteTimeranges.size() - 1; i >= 0; --i) {
            long[] absoluteTimerange = absoluteTimeranges.get(i);
            if (absoluteTimerange[0] > tsEnd) {
                absoluteTimeranges.remove(i);
                continue;
            }
            if (absoluteTimerange[1] < tsStart) {
                absoluteTimeranges.remove(i);
                continue;
            }
            if (absoluteTimerange[0] >= tsStart && absoluteTimerange[1] <= tsEnd) continue;
            if (absoluteTimerange[0] < tsStart) {
                absoluteTimerange[0] = tsStart;
            }
            if (absoluteTimerange[1] <= tsEnd) continue;
            absoluteTimerange[1] = tsEnd;
        }
        long[][] relativeTimeranges = new long[absoluteTimeranges.size()][2];
        for (int i = 0; i < absoluteTimeranges.size(); ++i) {
            long[] absoluteTimerange = absoluteTimeranges.get(i);
            relativeTimeranges[i] = new long[]{absoluteTimerange[0] - TimerangeCnf.getMidnightTimestamp(tsStart), absoluteTimerange[1] - TimerangeCnf.getMidnightTimestamp(tsStart)};
        }
        this.logger.info("---Calculating export timeranges:-----------------------------------------------");
        this.logger.info("   Start: [" + Basic.longToFormattedString((long)tsStart) + "] / [" + new Date(tsStart) + "]");
        this.logger.info("   End:   [" + Basic.longToFormattedString((long)tsEnd) + "] / [" + new Date(tsEnd) + "]");
        for (long[] absoluteTimerange : absoluteTimeranges) {
            this.logger.info("   --->[" + new Date(absoluteTimerange[0]) + "]-[" + new Date(absoluteTimerange[1]) + "]");
        }
        return relativeTimeranges;
    }

    public static long getMidnightTimestamp(long ts) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(ts);
        long MillisecondsOfDay = (long)calendar.get(11) * 3600000L + (long)calendar.get(12) * 60000L + (long)calendar.get(13) * 1000L + (long)calendar.get(14);
        return ts - MillisecondsOfDay;
    }

    private void getAbsoluteTimeranges(long timestamp, LinkedList<long[]> result) throws ConfigurationException {
        long[][] relativeTimeranges;
        long midnight = TimerangeCnf.getMidnightTimestamp(timestamp);
        for (long[] relativeTimerange : relativeTimeranges = this.getTimeranges(timestamp)) {
            long[] absoluteTimerange = new long[]{midnight + relativeTimerange[0], midnight + relativeTimerange[1]};
            result.add(absoluteTimerange);
        }
    }

    private boolean isHoliday(long timestamp) {
        return this.selectedCalendars.stream().anyMatch(selectedCalendar -> this.workCenterCalendarRepository.get(selectedCalendar.longValue()).isHoliday(timestamp));
    }
}

