/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.interaction.EventDataObject;
import de.seetec.v5.shared.util.NamedThreadFactory;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendEventDaemon
implements Runnable {
    private final BlockingQueue<EventDataObject> eventQueue = new LinkedBlockingQueue<EventDataObject>();
    private ExecutorService scheduler = null;
    private RECore core = null;
    private final Logger logger;
    private final AtomicLong receivedEvents = new AtomicLong(0L);

    public SendEventDaemon() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(RECore c) {
        this.core = c;
        if (this.core == null) {
            this.logger.error("Error while initalizing " + this);
            return -20002;
        }
        this.scheduler = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("SendEventDaemon"));
        this.scheduler.execute(this);
        return 0;
    }

    public int shutdown() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        this.eventQueue.clear();
        return 0;
    }

    public void put(EventDataObject event) {
        if (event != null) {
            this.eventQueue.offer(event);
            this.receivedEvents.getAndIncrement();
        }
    }

    @Override
    public void run() {
        block7: {
            try {
                while (!this.scheduler.isShutdown()) {
                    this.sendEvent(this.eventQueue.take());
                }
            }
            catch (InterruptedException ie) {
                if (this.scheduler.isShutdown()) {
                    this.shutdown();
                } else {
                    this.logger.error(ie.getMessage(), (Throwable)ie);
                }
            }
            catch (Throwable ex) {
                this.logger.error("Error while running: " + ex.getMessage(), ex);
                if (this.scheduler.isShutdown()) break block7;
                this.logger.info("Try to restart SendEventDaemon");
                this.scheduler.execute(this);
            }
        }
        if (this.scheduler.isShutdown()) {
            this.shutdown();
        }
    }

    protected int sendEvent(EventDataObject event) {
        if (this.core != null) {
            this.core.sendEvent(event.getEventType(), event.getSID(), event.getCID(), event.getData());
            return 0;
        }
        return -20000;
    }

    public boolean isShutdown() {
        return this.scheduler.isShutdown();
    }

    public long getNumberOfHandledEvents() {
        return this.receivedEvents.get();
    }

    public String toString() {
        return "SendEventDaemon";
    }
}

