/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.ConfigurationManager;
import de.seetec.v5.re.shared.configuration.ltesupport.LTESupportConfiguration;
import de.seetec.v5.shared.util.ConfigurationException;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RECnfMgr {
    public static final String RE_KEY_CNF_ENITYID = "EntityID";
    private static final String RE_KEY_CNF_DAEMONPORT = "DaemonPort";
    private static final String RE_KEY_CNF_ENTMGRHOST = "EntMgrHost";
    private static final String RE_KEY_CNF_ENTMGRPORT = "EntMgrPort";
    private static final String RE_KEY_CNF_ENTMGRID = "EntMgrId";
    private static final String RE_KEY_CNF_CORESERVICEMASTERHOST = "CoreServiceMasterHost";
    private static final String RE_KEY_CNF_CORESERVICEMASTERPORT = "CoreServiceMasterPort";
    private static final String RE_KEY_CNF_SERVERADDRESS = "ServerAddress";
    private static final String RE_KEY_CNF_STARTUPDELAY = "StartupDelay";
    private static final String RE_KEY_CNF_MAXVIDEOQUEUELENGTH = "MaxVideoQueueLength";
    private static final String RE_KEY_CNF_FAILOVER_MDB_ID = "FailoverMdbID";
    private static final String RE_KEY_CNF_EDGE_STORAGE_SPEED = "EdgeStorageSpeed";
    private static final String RE_KEY_CNF_EDGE_STORAGE_PARALLEL_IMPORTS = "EdgeStorageParallelImports";
    private static final String RE_KEY_CNF_EDGE_STORAGE_CHECK_TIMERANGE = "EdgeStorageCheckTimerange";
    private static final String RE_KEY_CNF_SIPMESSAGEPORT = "SIPMessagePort";
    private static final String RE_KEY_CNF_COMMONDB = "CommonDB";
    private static final String RE_KEY_CNF_COMMONDB_PATH = "Path";
    private static final String RE_KEY_CNF_EXTENSION = "Extension";
    private static final String RE_KEY_CNF_LTESUPPORT = "LTESupport";
    private static final String RE_KEY_CNF_LTESUPPORT_HOST = "ResolveIPHost";
    private static final String RE_KEY_CNF_LTESUPPORT_PORT = "ResolveIPPort";
    private static final String RE_KEY_CNF_LTESUPPORT_TIMEOUT = "ResolveIPTimeout";
    private static final String RE_KEY_CNF_LTESUPPORT_RETRYINTERVALL = "ResolveIPRetryInterval";
    private static final String RE_KEY_CNF_LTESUPPORT_RETRYCOUNT = "ResolveIPRetryCount";
    private static final String RE_KEY_CNF_UDP_PACKET_SIZE = "UdpPacketSize";
    private static final String RE_KEY_CNF_OBJECT_METADATA_DEBUG_LOGGING = "ObjectMetadataDebugLogging";
    private static final int RE_DEFAULT_ENITYMGRPORT = 60000;
    private static final int RE_DEFAULT_SIPMESSAGEPORT = 60021;
    protected Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private ConfigurationManager cnfMgr = null;
    private ConfigurationElement eRoot = null;
    private ConfigurationElement eEntityID = null;
    private ConfigurationElement eDaemonPort = null;
    private ConfigurationElement eEntMgrHost = null;
    private ConfigurationElement eEntMgrPort = null;
    private ConfigurationElement entMgrId = null;
    private ConfigurationElement coreServiceMasterHost = null;
    private ConfigurationElement coreServiceMasterPort = null;
    private ConfigurationElement eServerAddress = null;
    private ConfigurationElement eStartupDelay = null;
    private ConfigurationElement maxVideoQueueLength = null;
    private ConfigurationElement failoverMdbID = null;
    private ConfigurationElement edgeStorageSpeed = null;
    private ConfigurationElement eSIPMessagePort = null;
    private ConfigurationElement eCommonDB = null;
    private ConfigurationElement eCommonDBPath = null;
    private ConfigurationElement extension = null;
    private ConfigurationElement eLTESupport = null;
    private ConfigurationElement eLTESupportHost = null;
    private ConfigurationElement eLTESupportPort = null;
    private ConfigurationElement eLTESupportTimeout = null;
    private ConfigurationElement eLTESupportRetryInterval = null;
    private ConfigurationElement eLTESupportRetryCount = null;
    private ConfigurationElement edgeStorageParallelImports;
    private ConfigurationElement objectMetadataDebugLogging;
    private ConfigurationElement edgeStorageCheckTimerange;
    private ConfigurationElement udpPacketSize;

    public int init(String sCnfFile, int nDefaultDaemonPort) {
        int nErrorCode = 0;
        try {
            this.cnfMgr = new ConfigurationManager();
            nErrorCode = this.cnfMgr.init(sCnfFile);
            if (nErrorCode != 0) {
                this.logger.error("[ConfigurationManager::init] failed with ErrorCode [" + nErrorCode + "] :-(");
                return nErrorCode;
            }
            this.eRoot = this.cnfMgr.getRootElement();
            this.eEntityID = this.eRoot.getChild(RE_KEY_CNF_ENITYID);
            if (this.eEntityID == null) {
                this.eEntityID = this.eRoot.createChild(RE_KEY_CNF_ENITYID);
                this.eEntityID.setAsInt8(-1L);
            }
            this.eDaemonPort = this.eRoot.getChild(RE_KEY_CNF_DAEMONPORT);
            if (this.eDaemonPort == null || this.eDaemonPort.getAsInt4() < 0) {
                this.eDaemonPort = this.eRoot.createChild(RE_KEY_CNF_DAEMONPORT);
                this.eDaemonPort.setAsInt4(nDefaultDaemonPort);
            }
            this.eEntMgrHost = this.eRoot.getChild(RE_KEY_CNF_ENTMGRHOST);
            if (this.eEntMgrHost == null) {
                this.eEntMgrHost = this.eRoot.createChild(RE_KEY_CNF_ENTMGRHOST);
                this.eEntMgrHost.setAsString("localhost");
            }
            this.eEntMgrPort = this.eRoot.getChild(RE_KEY_CNF_ENTMGRPORT);
            if (this.eEntMgrPort == null) {
                this.eEntMgrPort = this.eRoot.createChild(RE_KEY_CNF_ENTMGRPORT);
                this.eEntMgrPort.setAsInt4(60000);
            }
            this.entMgrId = this.eRoot.getChild(RE_KEY_CNF_ENTMGRID);
            if (this.entMgrId == null) {
                this.entMgrId = this.eRoot.createChild(RE_KEY_CNF_ENTMGRID);
                this.entMgrId.setAsInt8(2L);
            }
            this.coreServiceMasterHost = this.eRoot.getChild(RE_KEY_CNF_CORESERVICEMASTERHOST);
            if (this.coreServiceMasterHost == null) {
                this.coreServiceMasterHost = this.eRoot.createChild(RE_KEY_CNF_CORESERVICEMASTERHOST);
                this.coreServiceMasterHost.setAsString("-1");
            }
            this.coreServiceMasterPort = this.eRoot.getChild(RE_KEY_CNF_CORESERVICEMASTERPORT);
            if (this.coreServiceMasterPort == null) {
                this.coreServiceMasterPort = this.eRoot.createChild(RE_KEY_CNF_CORESERVICEMASTERPORT);
                this.coreServiceMasterPort.setAsInt8(-1L);
            }
            this.eServerAddress = this.eRoot.getChild(RE_KEY_CNF_SERVERADDRESS);
            if (this.eServerAddress == null) {
                this.eServerAddress = this.eRoot.createChild(RE_KEY_CNF_SERVERADDRESS);
                this.eServerAddress.setAsString("");
            }
            this.eStartupDelay = this.eRoot.getChild(RE_KEY_CNF_STARTUPDELAY);
            if (this.eStartupDelay == null) {
                this.eStartupDelay = this.eRoot.createChild(RE_KEY_CNF_STARTUPDELAY);
                this.eStartupDelay.setAsInt8(0L);
            } else if (this.eStartupDelay.getAsInt4() < 0) {
                this.eStartupDelay.setAsInt4((int)(Math.random() * (double)Math.abs(this.eStartupDelay.getAsInt4())));
            }
            this.maxVideoQueueLength = this.eRoot.getChild(RE_KEY_CNF_MAXVIDEOQUEUELENGTH);
            if (this.maxVideoQueueLength == null) {
                this.maxVideoQueueLength = this.eRoot.createChild(RE_KEY_CNF_MAXVIDEOQUEUELENGTH);
                this.maxVideoQueueLength.setAsInt8(3000L);
            }
            this.failoverMdbID = this.eRoot.getChild(RE_KEY_CNF_FAILOVER_MDB_ID);
            if (this.failoverMdbID == null) {
                this.failoverMdbID = this.eRoot.createChild(RE_KEY_CNF_FAILOVER_MDB_ID);
                this.failoverMdbID.setAsInt8(-1L);
            }
            this.edgeStorageSpeed = this.eRoot.getChild(RE_KEY_CNF_EDGE_STORAGE_SPEED);
            if (this.edgeStorageSpeed == null) {
                this.edgeStorageSpeed = this.eRoot.createChild(RE_KEY_CNF_EDGE_STORAGE_SPEED);
                this.edgeStorageSpeed.setAsFloat8(-1.0);
            }
            this.edgeStorageParallelImports = this.eRoot.getChild(RE_KEY_CNF_EDGE_STORAGE_PARALLEL_IMPORTS);
            if (this.edgeStorageParallelImports == null) {
                this.edgeStorageParallelImports = this.eRoot.createChild(RE_KEY_CNF_EDGE_STORAGE_PARALLEL_IMPORTS);
                this.edgeStorageParallelImports.setAsInt4(0);
            }
            this.objectMetadataDebugLogging = this.eRoot.getChild(RE_KEY_CNF_OBJECT_METADATA_DEBUG_LOGGING);
            this.edgeStorageCheckTimerange = this.eRoot.getChild(RE_KEY_CNF_EDGE_STORAGE_CHECK_TIMERANGE);
            this.eSIPMessagePort = this.eRoot.getChild(RE_KEY_CNF_SIPMESSAGEPORT);
            if (this.eSIPMessagePort == null || this.eSIPMessagePort.getAsInt4() < 0) {
                this.eSIPMessagePort = this.eRoot.createChild(RE_KEY_CNF_SIPMESSAGEPORT);
                this.eSIPMessagePort.setAsInt4(60021);
            }
            this.eCommonDB = this.eRoot.getChild(RE_KEY_CNF_COMMONDB);
            if (this.eCommonDB == null) {
                this.eCommonDB = this.eRoot.createChild(RE_KEY_CNF_COMMONDB);
            }
            this.eCommonDBPath = this.eCommonDB.getChild(RE_KEY_CNF_COMMONDB_PATH);
            if (this.eCommonDBPath == null) {
                this.eCommonDBPath = this.eCommonDB.createChild(RE_KEY_CNF_COMMONDB_PATH);
                this.eCommonDBPath.setAsString("");
            }
            this.extension = this.eRoot.getChild(RE_KEY_CNF_EXTENSION);
            if (this.extension == null) {
                this.extension = this.eRoot.createChild(RE_KEY_CNF_EXTENSION);
                this.extension.setAsString("");
            }
            this.eLTESupport = this.eRoot.getChild(RE_KEY_CNF_LTESUPPORT);
            if (this.eLTESupport != null) {
                this.eLTESupportHost = this.eLTESupport.getChild(RE_KEY_CNF_LTESUPPORT_HOST);
                this.eLTESupportPort = this.eLTESupport.getChild(RE_KEY_CNF_LTESUPPORT_PORT);
                this.eLTESupportTimeout = this.eLTESupport.getChild(RE_KEY_CNF_LTESUPPORT_TIMEOUT);
                this.eLTESupportRetryInterval = this.eLTESupport.getChild(RE_KEY_CNF_LTESUPPORT_RETRYINTERVALL);
                this.eLTESupportRetryCount = this.eLTESupport.getChild(RE_KEY_CNF_LTESUPPORT_RETRYCOUNT);
            }
            this.udpPacketSize = this.eRoot.getChild(RE_KEY_CNF_UDP_PACKET_SIZE);
        }
        catch (Throwable ex) {
            this.logger.error("Misconfiguration detected. Exception == [" + ex + "]");
            this.logger.error("Application will be terminated :-(");
            return -20036;
        }
        return 0;
    }

    public int writeCnfFile() {
        return this.cnfMgr.writeCnfFile();
    }

    public int writeCnfFile(Charset charset) {
        return this.cnfMgr.writeCnfFile(charset);
    }

    public ConfigurationElement getRoot() {
        return this.eRoot;
    }

    public long getEntityID() throws ConfigurationException {
        return this.eEntityID.getAsInt8();
    }

    public void setEntityID(long nEntityID) {
        this.eEntityID.setAsInt8(nEntityID);
    }

    public int getDaemonPort() throws ConfigurationException {
        return this.eDaemonPort.getAsInt4();
    }

    public String getEntMgrHost() throws ConfigurationException {
        return this.eEntMgrHost.getAsString();
    }

    public void setEntMgrHost(String sEntMgrHost) {
        this.eEntMgrHost.setAsString(sEntMgrHost);
    }

    public int getEntMgrPort() throws ConfigurationException {
        return this.eEntMgrPort.getAsInt4();
    }

    public String getExtension() throws ConfigurationException {
        return this.extension.getAsString();
    }

    public void setEntMgrPort(int nEntMgrPort) {
        this.eEntMgrPort.setAsInt4(nEntMgrPort);
    }

    public long getEntMgrId() throws ConfigurationException {
        return this.entMgrId.getAsInt8();
    }

    public void setEntMgrId(long entMgrId) {
        this.entMgrId.setAsInt8(entMgrId);
    }

    public String getCoreServiceMainHost() throws ConfigurationException {
        return this.coreServiceMasterHost.getAsString();
    }

    public void setCoreServiceMainHost(String coreServiceMasterHost) {
        this.coreServiceMasterHost.setAsString(coreServiceMasterHost);
    }

    public int getCoreServiceMainPort() throws ConfigurationException {
        return this.coreServiceMasterPort.getAsInt4();
    }

    public void setCoreServiceMainPort(int coreServiceMasterPort) {
        this.coreServiceMasterPort.setAsInt4(coreServiceMasterPort);
    }

    public String getServerAddress() throws ConfigurationException {
        return this.eServerAddress.getAsString();
    }

    public long getStartupDelay() throws ConfigurationException {
        return this.eStartupDelay.getAsInt8();
    }

    public long getMaxVideoQueueLength() throws ConfigurationException {
        return this.maxVideoQueueLength.getAsInt8();
    }

    public long getFailoverMdbID() throws ConfigurationException {
        return this.failoverMdbID.getAsInt8();
    }

    public void setFailoverMdbID(long failoverMdbID) {
        this.failoverMdbID.setAsInt8(failoverMdbID);
    }

    public double getEdgeStorageSpeed() throws ConfigurationException {
        return this.edgeStorageSpeed.getAsFloat8();
    }

    public void setEdgeStorageSpeed(double edgeStorageSpeed) {
        this.edgeStorageSpeed.setAsFloat8(edgeStorageSpeed);
    }

    public int getEdgeStorageParallelImports() throws ConfigurationException {
        return this.edgeStorageParallelImports.getAsInt4();
    }

    public boolean getObjectMetadataDebugLogging() throws ConfigurationException {
        return this.objectMetadataDebugLogging.getAsBoolean();
    }

    public void setEdgeStorageParallelImports(int edgeStorageParallelImports) {
        this.edgeStorageParallelImports.setAsInt4(edgeStorageParallelImports);
    }

    public int getEdgeStorageCheckTimerange() throws ConfigurationException {
        if (this.edgeStorageCheckTimerange != null) {
            return this.edgeStorageCheckTimerange.getAsInt4();
        }
        return 0;
    }

    public int getSIPMessagePort() throws ConfigurationException {
        return this.eSIPMessagePort.getAsInt4();
    }

    public String getCommonDBPath() {
        return this.eCommonDBPath.getAsString();
    }

    public LTESupportConfiguration getLTEConfiguration() {
        if (this.eLTESupport == null) {
            return null;
        }
        try {
            LTESupportConfiguration config = new LTESupportConfiguration();
            if (this.eLTESupportHost != null) {
                config.setResolveIPHost(this.eLTESupportHost.getAsString());
            }
            if (this.eLTESupportPort != null) {
                config.setResolveIPPort(this.eLTESupportPort.getAsInt4());
            }
            if (this.eLTESupportTimeout != null) {
                config.setResolveIPTimeout(this.eLTESupportTimeout.getAsInt4());
            }
            if (this.eLTESupportRetryInterval != null) {
                config.setResolveIPRetryInterval(this.eLTESupportRetryInterval.getAsInt4());
            }
            if (this.eLTESupportRetryCount != null) {
                config.setResolveIPRetryCount(this.eLTESupportRetryCount.getAsInt4());
            }
            return config;
        }
        catch (ConfigurationException ex) {
            this.logger.warn("Can't parse configuration for LTE support: + " + ex.getMessage() + "! -> Don't use IP Mapping.");
            return null;
        }
    }

    public int getUdpPacketSize() throws ConfigurationException {
        if (this.udpPacketSize == null) {
            throw new ConfigurationException("Value not set.");
        }
        return this.udpPacketSize.getAsInt4();
    }
}

