/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NativeExportFrameHeader {
    public static final byte[] MAGIC = new byte[]{-96, -80, -64, -48};
    public static final int HASH_LENGTH = 32;
    public static final int HEADER_LENGTH = 64;
    private final byte[] fileHash;
    private final byte[] length;
    private final byte[] fillBytes = new byte[20];

    public NativeExportFrameHeader(String fileHash, long length) throws SeeTecException {
        if (fileHash == null) {
            throw new SeeTecException(-20002, "Hash is null");
        }
        if (fileHash.length() != 32) {
            throw new SeeTecException(-20002, "Hash has wrong length");
        }
        this.fileHash = fileHash.getBytes();
        this.length = Basic.int8ToByteArray((long)length);
    }

    public byte[] create() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(64);
        baos.write(MAGIC);
        baos.write(this.fileHash);
        baos.write(this.length);
        baos.write(this.fillBytes);
        return baos.toByteArray();
    }

    public static NativeExportFrameHeader parse(byte[] payload) throws IOException, SeeTecException {
        if (payload == null || payload.length < 64) {
            throw new SeeTecException(-20002, "Payload invalid");
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        byteBuffer.position(4);
        byte[] fileHash = new byte[32];
        byteBuffer.get(fileHash);
        long length = byteBuffer.getLong();
        return new NativeExportFrameHeader(new String(fileHash), length);
    }

    public String getFileHash() {
        return new String(this.fileHash);
    }

    public long getLength() {
        return Basic.byteArrayToInt8((byte[])this.length);
    }

    public String toString() {
        return "FileHash: " + new String(this.fileHash) + ", Length: " + Basic.byteArrayToInt8((byte[])this.length);
    }
}

