/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.NativeExportFrameHeader;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class ExportNetworkClientProxy
extends Basic {
    private static final String CLASS_NAME = "ExportNetworkClientProxy";
    private final Socket tcpSocket;
    private final InetAddress host;
    private final int port;
    private final OutputStream outputStream;
    private final long serviceId;

    public ExportNetworkClientProxy(Socket tcpSocket, long serviceId) throws SeeTecException {
        this.tcpSocket = tcpSocket;
        if (this.tcpSocket == null) {
            throw new SeeTecException(-20002, "Implementation error: Paramter [TcpSocket] is null!");
        }
        this.host = this.tcpSocket.getInetAddress();
        this.port = this.tcpSocket.getPort();
        try {
            this.outputStream = this.tcpSocket.getOutputStream();
        }
        catch (IOException ex) {
            throw new SeeTecException(-20001, ex.getMessage(), (Throwable)ex);
        }
        this.serviceId = serviceId;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.tcpSocket != null) {
            try {
                this.tcpSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0;
    }

    public void writeExportFrameHeader(String sFileID, long nLength) throws IOException, SeeTecException {
        this.outputStream.write(new NativeExportFrameHeader(sFileID, nLength).create());
        this.outputStream.flush();
    }

    public void streamExportFrameDate(byte[] data, int offset, int length) throws IOException {
        this.outputStream.write(data, offset, length);
        this.outputStream.flush();
    }

    public String toString() {
        return "[" + "ExportNetworkClientProxy@" + Integer.toHexString(((Object)((Object)this)).hashCode()) + ", ServiceID=[" + Basic.longToFormattedString((long)this.serviceId) + "], Address=[" + this.host.toString() + ":" + this.port + "]]";
    }
}

