/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.CnfDeviceCaptureMode;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.LteHostResolver;
import de.seetec.v5.re.shared.configuration.ltesupport.LTESupportConfiguration;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.net.NetworkParameterFactory;
import de.seetec.v5.shared.util.ConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

public class DeviceCnf {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Document xmlCnf = null;
    private ConfigurationElement root = null;
    private final LTESupportConfiguration lTESupportConfiguration;

    public DeviceCnf(LTESupportConfiguration lTESupportConfiguration) {
        this.lTESupportConfiguration = lTESupportConfiguration;
    }

    public int init(byte[] configuration) {
        int errorCode;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(configuration);
            errorCode = this.init(new SAXBuilder().build((InputStream)bais));
        }
        catch (Exception ex) {
            this.logger.error("Parsing configuration [" + new String(configuration) + "] failed", (Throwable)ex);
            errorCode = -21002;
        }
        return errorCode;
    }

    public int init(Document xmlCnf) {
        this.xmlCnf = xmlCnf;
        if (this.xmlCnf == null) {
            return -21002;
        }
        this.root = new ConfigurationElement(xmlCnf.getRootElement());
        return 0;
    }

    public String getHardwareHost() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("HardwareHost");
        String hardwareHost = null;
        if (cnfParameter != null) {
            hardwareHost = cnfParameter.getAsString();
        }
        return hardwareHost;
    }

    public int getHardwarePort() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("HardwarePort");
        int port = cnfParameter.getAsInt4();
        if (port <= 0 || port >= 65535) {
            throw new ConfigurationException("[HardwarePort]=[" + port + "] invalid");
        }
        return port;
    }

    public int getHTTPport() throws ConfigurationException {
        return this.getHardwarePort();
    }

    private boolean useHTTPS() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("UseHttps");
        return cnfParameter != null ? cnfParameter.getAsBoolean() : false;
    }

    public int getSSLport() throws ConfigurationException {
        if (this.useHTTPS()) {
            int port = this.root.getChild("HardwareHttpsPort").getAsInt4();
            if (port <= 0 || port >= 65535) {
                throw new ConfigurationException("[HardwareHttpsPort]=[" + port + "] invalid");
            }
            return port;
        }
        return -1;
    }

    public int getRTSPport() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("HardwareRtspPort");
        if (cnfParameter != null) {
            int port = this.root.getChild("HardwareRtspPort").getAsInt4();
            if (port < 1) {
                return 554;
            }
            if (port >= 65535) {
                throw new ConfigurationException("[HardwareRtspPort]=[" + port + "] invalid");
            }
            return port;
        }
        return 554;
    }

    public boolean isAudioEnabled() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("AudioEnabled");
        return cnfParameter != null ? cnfParameter.getAsBoolean() : false;
    }

    public long getAudioSourceID() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("AudioSourceID");
        return cnfParameter != null ? cnfParameter.getAsInt8() : -1L;
    }

    public Codec getAudioCodec() throws ConfigurationException {
        ConfigurationElement audioCodecConfigurationParameter = this.root.getChild("AudioCodec");
        if (this.root.getChild("AudioMediaCodec") != null && this.root.getChild("AudioMediaCodec").getChild("Value") != null) {
            return Codec.valueOf(this.root.getChild("AudioMediaCodec").getChild("Value").getAsInt4());
        }
        Codec audioCodec = Codec.UNKNOWN;
        if (audioCodecConfigurationParameter.getAsString().equalsIgnoreCase("G711")) {
            audioCodec = Codec.G711U;
        } else if (audioCodecConfigurationParameter.getAsString().equalsIgnoreCase("G711A")) {
            audioCodec = Codec.G711A;
        } else if (audioCodecConfigurationParameter.getAsString().equalsIgnoreCase("AAC")) {
            audioCodec = Codec.AAC;
        } else if (audioCodecConfigurationParameter.getAsString().equalsIgnoreCase("PCM")) {
            audioCodec = Codec.PCM;
        }
        return audioCodec;
    }

    public int getAudioDefaultBitrate() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("AudioDefaultBitrate");
        return cnfParameter != null ? cnfParameter.getAsInt4() : -1;
    }

    public NetworkParameter getNetworkParameter() throws ConfigurationException {
        int configurableVideoStreamNetworkTimeout = this.getConfigurableVideoStreamNetworkTimeout(this.root);
        int defaultNetworkTimeout = (int)TimeUnit.SECONDS.toMillis(60L);
        boolean timeoutReadFromconfiguration = configurableVideoStreamNetworkTimeout > 0;
        int networkTimeout = timeoutReadFromconfiguration ? configurableVideoStreamNetworkTimeout : defaultNetworkTimeout;
        String resolveHost = new LteHostResolver(this.lTESupportConfiguration).resolve(this.getHardwareHost());
        NetworkParameter networkParameter = NetworkParameterFactory.createNetworkParameter((String)resolveHost, (int)this.getHTTPport(), (boolean)this.useHTTPS(), (int)this.getSSLport(), (int)networkTimeout, (boolean)timeoutReadFromconfiguration, (String[])this.getUserPWD());
        return networkParameter;
    }

    private int getConfigurableVideoStreamNetworkTimeout(ConfigurationElement configurationElement) {
        int configurableVideoStreamNetworkTimeout = -1;
        ConfigurationElement cnfParameter = configurationElement.getChild("CustomVideoStreamNetworkTimeout");
        if (cnfParameter != null) {
            try {
                configurableVideoStreamNetworkTimeout = cnfParameter.getAsInt4();
            }
            catch (Exception exception) {
                this.logger.debug("Could not read <CustomVideoStreamNetworkTimeout>.");
            }
        }
        return configurableVideoStreamNetworkTimeout;
    }

    public String getAPI() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("API");
        return cnfParameter.getAsString();
    }

    public String getREID() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("REID");
        return cnfParameter.getAsString();
    }

    public boolean getUseAuthorization() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("UseAuthorization");
        return cnfParameter != null ? cnfParameter.getAsBoolean() : false;
    }

    private String[] getUserPWD() throws ConfigurationException {
        String[] stringArray;
        if (this.getUseAuthorization()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.getUser();
            stringArray = stringArray2;
            stringArray2[1] = this.getPassword();
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public String getUser() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("User");
        return cnfParameter != null ? cnfParameter.getAsString() : "anonymous";
    }

    public String getPassword() throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild("Password");
        return cnfParameter != null ? cnfParameter.getAsString() : "anonymous";
    }

    public ConfigurationElement getArchive() {
        return this.root.getChild("Archive");
    }

    public boolean isArchive() throws ConfigurationException {
        ConfigurationElement cnfIsArchive;
        ConfigurationElement cnfArchive = this.getArchive();
        if (cnfArchive != null && (cnfIsArchive = cnfArchive.getChild("IsArchive")) != null) {
            return cnfIsArchive.getAsBoolean();
        }
        return false;
    }

    public String getArchivePath() throws ConfigurationException {
        ConfigurationElement cnfPath;
        ConfigurationElement cnfArchive = this.getArchive();
        if (cnfArchive != null && (cnfPath = cnfArchive.getChild("Path")) != null) {
            return cnfPath.getAsString();
        }
        return null;
    }

    public String[] getArchiveDesPasswords() throws ConfigurationException {
        return this.getArchivePasswords(this.root.getChildren("Archive", "Password"));
    }

    public String[] getArchiveAesPasswords() throws ConfigurationException {
        return this.getArchivePasswords(this.root.getChildren("Archive", "AesPassword"));
    }

    private String[] getArchivePasswords(List<ConfigurationElement> passwords) throws ConfigurationException {
        if (passwords != null) {
            String[] sPasswords = new String[passwords.size()];
            for (int i = 0; i < passwords.size(); ++i) {
                ConfigurationElement cnfPassword = passwords.get(i);
                sPasswords[i] = cnfPassword.getAsString();
            }
            return sPasswords;
        }
        return new String[0];
    }

    public Long getArchiveMDBID() throws ConfigurationException {
        ConfigurationElement cnfPath;
        ConfigurationElement cnfArchive = this.getArchive();
        if (cnfArchive != null && (cnfPath = cnfArchive.getChild("MultiMediaDBID")) != null) {
            return cnfPath.getAsInt8();
        }
        return null;
    }

    public boolean isVirtualCameraUsed() throws ConfigurationException {
        ConfigurationElement cnfUseVirtualCameras = this.root.getChild("UseVirtualCameras");
        return cnfUseVirtualCameras != null && cnfUseVirtualCameras.getAsBoolean();
    }

    public CnfDeviceCaptureMode getCaptureMode() throws ConfigurationException {
        ConfigurationElement cnfCaptureModeResolution = this.root.getChild("CaptureModeResolution");
        if (cnfCaptureModeResolution != null) {
            ConfigurationElement cnfWidth = cnfCaptureModeResolution.getChild("Width");
            ConfigurationElement cnfHeight = cnfCaptureModeResolution.getChild("Height");
            ConfigurationElement cnfResolution = cnfCaptureModeResolution.getChild("Resolution");
            ConfigurationElement cnfDisplayResolution = cnfCaptureModeResolution.getChild("DisplayResolution");
            ConfigurationElement cnfMaxFramerate = cnfCaptureModeResolution.getChild("MaxMilliFPS");
            if (cnfWidth.getAsInt4() == 640 && cnfHeight.getAsInt4() == 480 && cnfDisplayResolution.getAsString().equals("640x480")) {
                return new CnfDeviceCaptureMode(false);
            }
            return new CnfDeviceCaptureMode(cnfWidth.getAsInt4(), cnfHeight.getAsInt4(), cnfResolution.getAsString(), cnfDisplayResolution.getAsString(), cnfMaxFramerate.getAsInt4());
        }
        return new CnfDeviceCaptureMode(false);
    }

    public String getGenericParameter(String id) throws ConfigurationException {
        ConfigurationElement cnfParameter = this.root.getChild(id);
        return cnfParameter != null ? cnfParameter.getAsString() : null;
    }

    public Document getDocument() {
        return this.xmlCnf;
    }
}

