/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;

public class DeadlockDetector {
    private static StackTraceElement[] getThreadStackTrace(ThreadInfo threadInfo) {
        StackTraceElement[] stackTraceElements = threadInfo.getStackTrace();
        if (stackTraceElements == null || stackTraceElements.length <= 0) {
            Thread[] threads;
            for (Thread thread : threads = DeadlockDetector.getThreadList()) {
                if (thread.getId() != threadInfo.getThreadId()) continue;
                return thread.getStackTrace();
            }
        }
        return new StackTraceElement[0];
    }

    private static Thread[] getThreadList() {
        ThreadGroup currentGroup = Thread.currentThread().getThreadGroup();
        Thread[] threadList = new Thread[currentGroup.activeCount()];
        currentGroup.enumerate(threadList);
        return threadList;
    }

    public static String getDescriptionOfDeadlockedThreads() {
        StringBuilder sb = new StringBuilder();
        ArrayList<ThreadInfo> deadlockedThreads = DeadlockDetector.findDeadlockedThreads();
        for (ThreadInfo threadInfo : deadlockedThreads) {
            StackTraceElement[] stackTraceElements;
            sb.append("\n   ").append(threadInfo.toString().trim());
            sb.append("\n      LockName : ").append(threadInfo.getLockName());
            sb.append("\n      LockOwnerName : ").append(threadInfo.getLockOwnerName());
            sb.append("\n      BlockedTime : ").append(threadInfo.getBlockedTime());
            sb.append("\n      LockInfo : ").append(threadInfo.getLockInfo());
            sb.append("\n      ThreadState : ").append((Object)threadInfo.getThreadState());
            for (StackTraceElement stackTraceElement : stackTraceElements = DeadlockDetector.getThreadStackTrace(threadInfo)) {
                sb.append("\n      ").append(stackTraceElement);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected static ArrayList<ThreadInfo> findDeadlockedThreads() {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        long[] threadIds = bean.findDeadlockedThreads();
        ArrayList<ThreadInfo> result = new ArrayList<ThreadInfo>();
        if (threadIds != null && threadIds.length > 0) {
            ThreadInfo[] infos;
            for (ThreadInfo info : infos = bean.getThreadInfo(threadIds)) {
                if (info == null) continue;
                result.add(info);
            }
        }
        return result;
    }
}

