/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.SqlDatabaseHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataObjectBackupInfo {
    private static final String CLASS_NAME = "de.seetec.v5.re.md.server.sql.DataObjectBackupInfo";
    private static final String TN_BACKUP_INFO = "BackupInfos";
    private static final String BACKUP_INFOS_VERSION = "6.17.1";
    private Long contentId = null;
    private String contentAlias = null;
    private Boolean exportStandardTrack = null;
    private Boolean exportAlarmTrack = null;
    private long[][] backupTimeranges = null;
    private Long midnightBackupDay = null;
    private Long timestampStartOfBackup = null;
    private Long videoStartTime = null;
    private Long backupVolume = null;
    private Integer backupErrorCode = null;
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public DataObjectBackupInfo(Long contentId, String contentAlias, Boolean bExportStandardTrack, Boolean bExportAlarmTrack, long[][] backupTimeranges, Long midnightBackupDay, Long tsStartOfBackup, Long videoStartTime, Long backupVolume, Integer backupErrorCode) throws SeeTecException {
        this(contentId, contentAlias, bExportStandardTrack, bExportAlarmTrack, backupTimeranges, System.currentTimeMillis(), midnightBackupDay);
        this.timestampStartOfBackup = tsStartOfBackup;
        if (this.timestampStartOfBackup == null || tsStartOfBackup < 0L) {
            throw new SeeTecException(-20002, "Parameter <tsStartOfBackup>=[" + tsStartOfBackup + "] invalid!");
        }
        this.videoStartTime = videoStartTime;
        if (this.videoStartTime == null) {
            throw new SeeTecException(-20002, "Parameter <videoStartTime> is null");
        }
        this.backupVolume = backupVolume;
        this.backupErrorCode = backupErrorCode;
    }

    public DataObjectBackupInfo(Long contentId, String contentAlias, Boolean bExportStandardTrack, Boolean bExportAlarmTrack, long[][] backupTimeranges, long startOfBackup, Long midnightBackupDay) throws SeeTecException {
        this.contentId = contentId;
        if (this.contentId == null || contentId < 0L) {
            throw new SeeTecException(-20002, "Parameter <contentID>=[" + contentId + "] invalid!");
        }
        this.contentAlias = contentAlias;
        if (this.contentAlias == null || contentAlias.trim().length() <= 0) {
            throw new SeeTecException(-20002, "Parameter <contentAlias>=[" + contentAlias + "] invalid!");
        }
        this.exportStandardTrack = bExportStandardTrack;
        if (this.exportStandardTrack == null) {
            throw new SeeTecException(-20002, "Parameter <bExportStandardTrack>=null!");
        }
        this.exportAlarmTrack = bExportAlarmTrack;
        if (this.exportAlarmTrack == null) {
            throw new SeeTecException(-20002, "Parameter <bExportAlarmTrack>=null!");
        }
        this.backupTimeranges = backupTimeranges;
        if (backupTimeranges == null || backupTimeranges.length == 0 || backupTimeranges[0].length == 0) {
            throw new SeeTecException(-20002, "Parameter <backupTimeranges> invalid!");
        }
        this.midnightBackupDay = midnightBackupDay;
        if (this.midnightBackupDay == null || midnightBackupDay < 0L) {
            throw new SeeTecException(-20002, "Parameter <midnightBackupDay>=[" + midnightBackupDay + "] invalid!");
        }
        this.videoStartTime = this.midnightBackupDay + backupTimeranges[0][0];
        this.timestampStartOfBackup = startOfBackup;
        this.backupVolume = 0L;
    }

    public Long getContentId() {
        return this.contentId;
    }

    public String getContentAlias() {
        return this.contentAlias;
    }

    public Boolean isExportStandardTrack() {
        return this.exportStandardTrack;
    }

    public Boolean isExportAlarmTrack() {
        return this.exportAlarmTrack;
    }

    public Long getMidnightBackupDay() {
        return this.midnightBackupDay;
    }

    public Long getTimestampStartOfBackup() {
        return this.timestampStartOfBackup;
    }

    public Long getVideoStartTime() {
        return this.videoStartTime;
    }

    public Long getBackupVolume() {
        return this.backupVolume;
    }

    public Integer getBackupErrorCode() {
        return this.backupErrorCode;
    }

    public void finalizeData(Long tsStartOfBackup, Long backupVolume, Integer backupErrorCode) throws SeeTecException {
        this.timestampStartOfBackup = tsStartOfBackup;
        if (this.timestampStartOfBackup == null || tsStartOfBackup < 0L) {
            throw new SeeTecException(-20002, "Parameter <tsStartOfBackup>=[" + tsStartOfBackup + "] invalid!");
        }
        this.backupVolume = backupVolume;
        this.backupErrorCode = backupErrorCode;
    }

    public static void updateDatabaseSchema(SqlDatabaseHandler sqlDatabaseHandler, Logger logger) {
        String tableVersion = sqlDatabaseHandler.getTableVersion(TN_BACKUP_INFO);
        if (tableVersion == null || !BACKUP_INFOS_VERSION.equals(tableVersion)) {
            sqlDatabaseHandler.dropTable(TN_BACKUP_INFO);
            sqlDatabaseHandler.updateTableVersion(TN_BACKUP_INFO, BACKUP_INFOS_VERSION);
            sqlDatabaseHandler.executeSqlUpdate(DataObjectBackupInfo.createCreateQuery());
            String idxBackupErrorCode = "idxBackupErrorCodeBackupInfos";
            String query = "CREATE INDEX " + idxBackupErrorCode + " ON " + TN_BACKUP_INFO + " ( BackupErrorCode )";
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            }
            String idxContentID = "idxContentIDBackupInfos";
            query = "CREATE INDEX " + idxContentID + " ON " + TN_BACKUP_INFO + " ( ContentID, MidnightBackupDay )";
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            }
            String idxStartOfBackup = "idxStartOfBackupBackupInfos";
            query = "CREATE INDEX " + idxStartOfBackup + " ON " + TN_BACKUP_INFO + " ( StartOfBackup )";
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            }
        }
    }

    public String createInsertQuery() {
        StringBuilder sBackupTimeranges = new StringBuilder();
        for (long[] backupTimerange : this.backupTimeranges) {
            sBackupTimeranges.append(backupTimerange[0]).append(":").append(backupTimerange[1]).append(";");
        }
        return "INSERT INTO BackupInfos ( ContentID, ContentAlias, ExportStandardTrack, ExportAlarmTrack, MidnightBackupDay, BackupTimeranges, StartOfBackup, VideoStartTime, BackupVolume, BackupErrorCode ) VALUES( " + this.contentId + ", '" + this.contentAlias + "', " + this.exportStandardTrack + ", " + this.exportAlarmTrack + ", " + this.midnightBackupDay + ", '" + sBackupTimeranges + "', " + this.timestampStartOfBackup + ", " + this.videoStartTime + ", " + this.backupVolume + ", " + this.backupErrorCode + " )";
    }

    private static String createCreateQuery() {
        return "CREATE TABLE BackupInfos ( ContentID BIGINT NOT NULL, ContentAlias VARCHAR( 256 ) NOT NULL, ExportStandardTrack Boolean NOT NULL, ExportAlarmTrack Boolean NOT NULL, BackupTimeranges VARCHAR( 256 ) NOT NULL, MidnightBackupDay BIGINT NOT NULL, StartOfBackup BIGINT NOT NULL, VideoStartTime BIGINT NOT NULL, BackupVolume BIGINT NOT NULL, BackupErrorCode INT )";
    }

    public long[][] getBackupTimeranges() {
        return this.backupTimeranges;
    }

    public int updateEntry(SqlDatabaseHandler sqlDatabaseHandler) {
        Connection connection = sqlDatabaseHandler.getConnection();
        String query = null;
        try {
            query = "DELETE FROM BackupInfos WHERE ContentID=" + this.contentId + " AND MidnightBackupDay=" + this.midnightBackupDay;
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(query);
                query = this.createInsertQuery();
                statement.executeUpdate(query);
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.warn("Query failed: [" + query + "]", ex);
            return -20001;
        }
    }

    public static List<DataObjectBackupInfo> getFailedBackups(SqlDatabaseHandler sqlDatabaseHandler, Logger logger) {
        LinkedList<DataObjectBackupInfo> result = new LinkedList<DataObjectBackupInfo>();
        Connection connection = sqlDatabaseHandler.getConnection();
        String query = "SELECT * FROM BackupInfos WHERE BackupErrorCode < 0 ORDER BY StartOfBackup";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                int index = 0;
                Long contentID = Long.parseLong(resultSet.getString(++index));
                String contentAlias = resultSet.getString(++index);
                Boolean exportStandardTrack = Boolean.parseBoolean(resultSet.getString(++index));
                Boolean exportAlarmTrack = Boolean.parseBoolean(resultSet.getString(++index));
                String sBackupTimeranges = resultSet.getString(++index);
                Long midnightBackupDay = Long.parseLong(resultSet.getString(++index));
                Long tsStartOfBackup = Long.parseLong(resultSet.getString(++index));
                Long videoStartTime = Long.parseLong(resultSet.getString(++index));
                Long backupVolume = Long.parseLong(resultSet.getString(++index));
                Integer backupErrorCode = Integer.parseInt(resultSet.getString(++index));
                LinkedList<long[]> timeranges = new LinkedList<long[]>();
                StringTokenizer st = new StringTokenizer(sBackupTimeranges, ";");
                while (st.hasMoreElements()) {
                    StringTokenizer st2 = new StringTokenizer(st.nextToken(), ":");
                    long start = Long.parseLong(st2.nextToken());
                    long end = Long.parseLong(st2.nextToken());
                    timeranges.add(new long[]{start, end});
                }
                long[][] backupTimeranges = new long[timeranges.size()][2];
                for (int i = 0; i < timeranges.size(); ++i) {
                    backupTimeranges[i] = (long[])timeranges.get(i);
                }
                result.add(new DataObjectBackupInfo(contentID, contentAlias, exportStandardTrack, exportAlarmTrack, backupTimeranges, midnightBackupDay, tsStartOfBackup, videoStartTime, backupVolume, backupErrorCode));
            }
        }
        catch (Throwable ex) {
            logger.warn("Trouble executing sql statement [" + query + "] :-(", ex);
        }
        return result;
    }

    public static List<DataObjectBackupInfo> getQueuedBackups(SqlDatabaseHandler sqlDatabaseHandler, Logger logger) {
        LinkedList<DataObjectBackupInfo> result = new LinkedList<DataObjectBackupInfo>();
        Connection connection = sqlDatabaseHandler.getConnection();
        String query = "SELECT * FROM BackupInfos WHERE BackupErrorCode IS NULL";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                result.add(DataObjectBackupInfo.createDataObjectBackupInfo(resultSet));
            }
        }
        catch (Throwable ex) {
            logger.warn("Trouble executing sql statement [" + query + "] :-(", ex);
        }
        if (!result.isEmpty()) {
            logger.info("There are [" + result.size() + "] queued backup jobs.");
        }
        return result;
    }

    public static DataObjectBackupInfo getQueuedBackup(SqlDatabaseHandler sqlDatabaseHandler, Logger logger, long contentId) throws SQLException, SeeTecException {
        Connection connection = sqlDatabaseHandler.getConnection();
        String query = "SELECT * FROM BackupInfos WHERE ContentID=" + contentId + " AND BackupErrorCode IS NULL";
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            if (resultSet.next()) {
                DataObjectBackupInfo dataObjectBackupInfo = DataObjectBackupInfo.createDataObjectBackupInfo(resultSet);
                return dataObjectBackupInfo;
            }
        }
        return null;
    }

    public static int retryBackup(SqlDatabaseHandler sqlDatabaseHandler, Long contentID, Long midnightBackupDay, Logger logger) {
        String query = null;
        try {
            int count;
            query = "UPDATE BackupInfos SET BackupErrorCode=null Where ContentID=" + contentID + " AND MidnightBackupDay=" + midnightBackupDay;
            try (Statement statement = sqlDatabaseHandler.getConnection().createStatement();){
                count = statement.executeUpdate(query);
            }
            logger.info("Query=[" + query + "]");
            logger.info("   [" + count + "] entries updated!");
            return 0;
        }
        catch (Throwable ex) {
            logger.warn("Query failed: [" + query + "]", ex);
            return -20001;
        }
    }

    public static int discardFailedBackup(SqlDatabaseHandler sqlDatabaseHandler, Long contentID, Long midnightBackupDay, Logger logger) {
        String query = null;
        try {
            int count;
            query = "DELETE FROM BackupInfos WHERE ContentID=" + contentID + " AND MidnightBackupDay=" + midnightBackupDay;
            try (Statement statement = sqlDatabaseHandler.getConnection().createStatement();){
                count = statement.executeUpdate(query);
            }
            logger.info("Query=[" + query + "]");
            logger.info("   [" + count + "] entries deleted!");
            return 0;
        }
        catch (Throwable ex) {
            logger.warn("Query failed: [" + query + "]", ex);
            return -20001;
        }
    }

    private static DataObjectBackupInfo createDataObjectBackupInfo(ResultSet resultSet) throws SQLException, SeeTecException {
        String sbackupErrorCode;
        int index = 0;
        Long contentID = Long.parseLong(resultSet.getString(++index));
        String contentAlias = resultSet.getString(++index);
        Boolean exportStandardTrack = Boolean.parseBoolean(resultSet.getString(++index));
        Boolean exportAlarmTrack = Boolean.parseBoolean(resultSet.getString(++index));
        String sBackupTimeranges = resultSet.getString(++index);
        Long midnightBackupDay = Long.parseLong(resultSet.getString(++index));
        Long tsStartOfBackup = Long.parseLong(resultSet.getString(++index));
        Long videoStartTime = Long.parseLong(resultSet.getString(++index));
        Long backupVolume = Long.parseLong(resultSet.getString(++index));
        Integer backupErrorCode = (sbackupErrorCode = resultSet.getString(++index)) != null ? Integer.valueOf(Integer.parseInt(sbackupErrorCode)) : null;
        LinkedList<long[]> timeranges = new LinkedList<long[]>();
        StringTokenizer st = new StringTokenizer(sBackupTimeranges, ";");
        while (st.hasMoreElements()) {
            StringTokenizer st2 = new StringTokenizer(st.nextToken(), ":");
            long start = Long.parseLong(st2.nextToken());
            long end = Long.parseLong(st2.nextToken());
            timeranges.add(new long[]{start, end});
        }
        long[][] backupTimeranges = new long[timeranges.size()][2];
        for (int i = 0; i < timeranges.size(); ++i) {
            backupTimeranges[i] = (long[])timeranges.get(i);
        }
        return new DataObjectBackupInfo(contentID, contentAlias, exportStandardTrack, exportAlarmTrack, backupTimeranges, midnightBackupDay, tsStartOfBackup, videoStartTime, backupVolume, backupErrorCode);
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.md.server.sql.DataObjectBackupInfo@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", ContentID=[" + this.contentId + "], ContentAlias=[" + this.contentAlias + "], ExportStandardTrack=[" + this.exportStandardTrack + "], ExportAlarmTrack=[" + this.exportAlarmTrack + "], BackupTimeranges=[" + Arrays.toString((Object[])this.backupTimeranges) + "], MidnightBackupDay=[" + this.midnightBackupDay + "], StartOfBackup=[" + this.timestampStartOfBackup + "], BackupVolume=[" + this.backupVolume + "], BackupErrorCode=[" + this.backupErrorCode + "]]";
    }
}

