/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.SqlDatabaseHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.ByteArrayOutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataObjectAlarmInstance {
    private static final String tnAlarmInstances = "AlarmInstances";
    private static final String ColumnID = "ID";
    private static final String ColumnContentID = "ContentID";
    private static final String ColumnAlarmScriptID = "AlarmScriptID";
    private static final String ColumnAlarmInstanceID = "AlarmInstanceID";
    private static final String ColumnAlarmStart = "AlarmStart";
    private static final String ColumnAlarmEnd = "AlarmEnd";
    private static final String CLASS_NAME = "de.seetec.v5.re.md.server.sql.DataObjectAlarmInstance";
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Long contentID = -1L;
    private Long alarmScriptID = -1L;
    private Long alarmInstanceID = 1L;
    private Long timestampAlarmStart = 1L;
    private Long timestampAlarmEnd = 1L;

    public DataObjectAlarmInstance(Long contentID, Long alarmScriptID, Long alarmInstanceID, Long tsAlarmStart, Long tsAlarmEnd) throws SeeTecException {
        this.contentID = contentID;
        if (this.contentID == null || contentID < 0L) {
            throw new SeeTecException(-20002, "Parameter <contentID>=[" + contentID + "] invalid!");
        }
        this.alarmScriptID = alarmScriptID;
        this.alarmInstanceID = alarmInstanceID;
        if (this.alarmInstanceID == null || alarmInstanceID < 0L) {
            throw new SeeTecException(-20002, "Parameter <alarmInstanceID>=[" + alarmInstanceID + "] invalid!");
        }
        this.timestampAlarmStart = tsAlarmStart;
        if (this.timestampAlarmStart == null || tsAlarmStart < 0L) {
            throw new SeeTecException(-20002, "Parameter <tsAlarmStart>=[" + tsAlarmStart + "] invalid!");
        }
        this.timestampAlarmEnd = tsAlarmEnd;
        if (this.timestampAlarmEnd == null || tsAlarmEnd < 0L) {
            throw new SeeTecException(-20002, "Parameter <tsAlarmEnd>=[" + tsAlarmEnd + "] invalid!");
        }
    }

    public static void updateDatabaseSchema(SqlDatabaseHandler sqlDatabaseHandler, Logger logger) {
        long duration;
        String tableVersion = sqlDatabaseHandler.getTableVersion(tnAlarmInstances);
        if (tableVersion == null) {
            if (sqlDatabaseHandler.doesTableExist(tnAlarmInstances)) {
                sqlDatabaseHandler.dropTable(tnAlarmInstances);
            }
            sqlDatabaseHandler.updateTableVersion(tnAlarmInstances, "5.4.2");
            sqlDatabaseHandler.executeSqlUpdate(DataObjectAlarmInstance.createCreateQuery());
            long nanoStart = System.nanoTime();
            String idx = "idxAlarmInstances_ID";
            String query = "CREATE INDEX " + idx + " ON " + tnAlarmInstances + " ( " + ColumnID + " )";
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            }
            duration = (System.nanoTime() - nanoStart) / 1000000L;
            logger.info("Creating index  [" + query + "] lasts for [" + Basic.longToFormattedString((long)duration) + " ms]");
            nanoStart = System.nanoTime();
            idx = "idxAlarmInstances_ContentID_AlarmStart";
            query = "CREATE INDEX " + idx + " ON " + tnAlarmInstances + " ( " + ColumnContentID + ", " + ColumnAlarmStart + " )";
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            }
            duration = (System.nanoTime() - nanoStart) / 1000000L;
            logger.info("Creating index  [" + query + "] lasts for [" + Basic.longToFormattedString((long)duration) + " ms]");
            nanoStart = System.nanoTime();
            idx = "idxAlarmInstances_AlarmInstanceID";
            query = "CREATE INDEX " + idx + " ON " + tnAlarmInstances + " ( " + ColumnAlarmInstanceID + " )";
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            }
            duration = (System.nanoTime() - nanoStart) / 1000000L;
            logger.info("Creating index  [" + query + "] lasts for [" + Basic.longToFormattedString((long)duration) + " ms]");
        }
        String query = null;
        try {
            String idx = "idxAlarmInstances_AlarmEnd";
            query = "CREATE INDEX " + idx + " ON " + tnAlarmInstances + " ( " + ColumnAlarmEnd + " )";
            long ts = System.nanoTime();
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            } else {
                duration = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - ts);
                logger.info("Creating index with statement [" + query + "] lasts for [" + Basic.longToFormattedString((long)duration) + " s]");
            }
        }
        catch (Throwable ex) {
            logger.warn("Trouble creating index with [" + query + "] :-(", ex);
        }
        try {
            String idx = "idxAlarmInstances_ContentID_AlarmStart_AlarmEnd";
            query = "CREATE INDEX " + idx + " ON " + tnAlarmInstances + " ( " + ColumnContentID + ", " + ColumnAlarmStart + ", " + ColumnAlarmEnd + " )";
            long ts = System.nanoTime();
            if (sqlDatabaseHandler.executeSqlUpdate(query) != 0) {
                logger.warn("Creating index failed with statement [" + query + "]");
            } else {
                duration = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - ts);
                logger.info("Creating index with statement [" + query + "] lasts for [" + Basic.longToFormattedString((long)duration) + " s]");
            }
        }
        catch (Throwable ex) {
            logger.warn("Trouble creating index with [" + query + "] :-(", ex);
        }
    }

    private String createInsertQuery() {
        return "INSERT INTO AlarmInstances ( ID, ContentID, AlarmScriptID, AlarmInstanceID, AlarmStart, AlarmEnd ) VALUES  ( " + Basic.createInt8UID((SystemTimeProvider)new DefaultSystemTimeProvider()) + ", " + this.contentID + ", " + this.alarmScriptID + ", " + this.alarmInstanceID + ", " + this.timestampAlarmStart + ", " + this.timestampAlarmEnd + " )";
    }

    private static String createCreateQuery() {
        return "CREATE TABLE AlarmInstances ( ID BIGINT NOT NULL, ContentID BIGINT NOT NULL, AlarmScriptID BIGINT NOT NULL, AlarmInstanceID BIGINT NOT NULL, AlarmStart BIGINT NOT NULL, AlarmEnd BIGINT NOT NULL   )";
    }

    public int updateEntry(SqlDatabaseHandler sqlDatabaseHandler) {
        Connection connection = sqlDatabaseHandler.getConnection();
        String query = null;
        try {
            query = this.createInsertQuery();
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate(query);
            }
            return 0;
        }
        catch (Throwable ex) {
            this.logger.warn("Query failed: [" + query + "]", ex);
            return -20001;
        }
    }

    public static Long[] getAlarmInstance(Connection connection, Logger logger, Long contentID, Long alarmInstanceID) {
        Long[] alarmInstance = null;
        String query = "SELECT AlarmStart, AlarmEnd FROM AlarmInstances WHERE ContentID = " + contentID + " AND " + ColumnAlarmInstanceID + " = " + alarmInstanceID;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            if (resultSet.next()) {
                int index = 0;
                Long tsAlarmStart = resultSet.getLong(++index);
                Long tsAlarmEnd = resultSet.getLong(++index);
                alarmInstance = new Long[]{tsAlarmStart, tsAlarmEnd};
                logger.info("Found tsAlarmStart=[" + Basic.longToFormattedString((Long)tsAlarmStart) + "], tsAlarmEnd=[" + Basic.longToFormattedString((Long)tsAlarmEnd) + "] for query [" + query + "]");
            }
        }
        catch (Throwable ex) {
            logger.warn("Query failed: [" + query + "]", ex);
        }
        return alarmInstance;
    }

    public static LinkedList<byte[]> getAlarmScenarioOccurrencies(Connection connection, Logger logger, Long contentID, Long startTimestamp, Long endTimestamp) {
        LinkedList<byte[]> alarmScenarioOccurrencies = new LinkedList<byte[]>();
        String query = "SELECT AlarmScriptID, AlarmStart, AlarmEnd FROM AlarmInstances WHERE ContentID = " + contentID + " AND " + ColumnAlarmStart + " <= " + endTimestamp + " AND " + ColumnAlarmEnd + " >= " + startTimestamp + " ORDER BY " + ColumnAlarmScriptID + ", " + ColumnAlarmStart;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long currentAlarmScriptID = -1L;
            long tsAbsolute = -1L;
            while (resultSet.next()) {
                int index = 0;
                Long alarmScriptID = resultSet.getLong(++index);
                Long tsAlarmStart = resultSet.getLong(++index);
                Long tsAlarmEnd = resultSet.getLong(++index);
                if (alarmScriptID < 0L) continue;
                if (currentAlarmScriptID != alarmScriptID) {
                    currentAlarmScriptID = alarmScriptID;
                    byte[] result = baos.toByteArray();
                    if (result.length > 0) {
                        alarmScenarioOccurrencies.add(result);
                    }
                    tsAbsolute = tsAlarmStart;
                    baos.reset();
                    baos.write(Basic.int8ToByteArray((long)alarmScriptID));
                    baos.write(Basic.int8ToByteArray((long)tsAbsolute));
                }
                Long alarmStartRelative = tsAlarmStart - tsAbsolute;
                Long alarmDuration = tsAlarmEnd - tsAlarmStart;
                baos.write(Basic.int8ToByteArray((long)alarmStartRelative, (int)5));
                baos.write(Basic.int8ToByteArray((long)alarmDuration, (int)4));
            }
            byte[] result = baos.toByteArray();
            if (result.length > 0) {
                alarmScenarioOccurrencies.add(result);
            }
        }
        catch (Throwable ex) {
            logger.warn("Query failed: [" + query + "]", ex);
        }
        return alarmScenarioOccurrencies;
    }

    public static LinkedList<Long[]> getAlarmInstances(Connection connection, Logger logger, Long nContentID, Long nStartTimestamp, Long nEndTimestamp) {
        LinkedList<Long[]> alarmInstances = new LinkedList<Long[]>();
        String optionalContentID = "";
        if (nContentID != null && nContentID > 0L) {
            optionalContentID = "ContentID = " + nContentID + " AND ";
        }
        String query = "SELECT * FROM AlarmInstances WHERE " + optionalContentID + ColumnAlarmStart + " >= " + nStartTimestamp + " AND " + ColumnAlarmStart + " <= " + nEndTimestamp + " ORDER BY " + ColumnAlarmStart;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                int index = 0;
                resultSet.getLong(++index);
                resultSet.getLong(++index);
                resultSet.getLong(++index);
                Long alarmInstanceID = resultSet.getLong(++index);
                Long tsAlarmStart = resultSet.getLong(++index);
                Long tsAlarmEnd = resultSet.getLong(++index);
                alarmInstances.add(new Long[]{alarmInstanceID, tsAlarmStart, tsAlarmEnd});
            }
            logger.info("[" + Basic.longToFormattedString((long)alarmInstances.size()) + "] entries for query [" + query + "]");
        }
        catch (Throwable ex) {
            logger.warn("Query failed: [" + query + "]", ex);
        }
        return alarmInstances;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.md.server.sql.DataObjectAlarmInstance@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", contentID=[" + this.contentID + "], alarmScriptID=[" + this.alarmScriptID + "], alarmInstanceID=[" + this.alarmInstanceID + "], tsAlarmStart=[" + this.timestampAlarmStart + "], tsAlarmEnd=[" + this.timestampAlarmEnd + "]]";
    }
}

