/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.CoreServiceWrapperWatchdog;
import de.seetec.v5.re.shared.RECnfMgr;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.SetStatusAgent;
import de.seetec.v5.re.shared.SetStatusAgentListener;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.configuration.events.loggingevent.LoggingEvent;
import de.seetec.v5.shared.configuration.events.status.StatusEvent;
import de.seetec.v5.shared.proxy.ent.EntMgrProxy;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Ticket;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public class CoreServiceWrapper
extends Basic
implements SetStatusAgentListener {
    private static final String ClassName = "de.seetec.v5.shared.net.CoreServiceWrapper";
    private final Logger logger;
    private Watchdog watchdog = null;
    private SetStatusAgent setStatusAgent = null;
    private Map<Long, Integer> htEntityStatus = null;
    private Map<Long, Entity> htEntityCache = null;
    private long nCnfTicketStart = -1L;
    private long nCnfTicketRange = 0L;
    private long nLastCnfTicket = -1L;
    private long nEntTicketStart = -1L;
    private long nEntTicketRange = 0L;
    private volatile long nLastEntTicket = -1L;
    private RECnfMgr reCnfMgr = null;
    private RECore reCore = null;
    private String currentCoreServiceHost = null;
    private int currentCoreServicePort = -1;
    private long currentCoreServiceId = -1L;
    private final ReentrantLock generalSynchronizeSubstitution = new ReentrantLock();
    private final ReentrantLock entityCacheSynchronizeSubstitution = new ReentrantLock();

    public CoreServiceWrapper(RECnfMgr reCnfMgr, RECore reCore) throws SeeTecException {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.reCore = reCore;
        if (this.reCore == null) {
            throw new SeeTecException(-20002, "Invalid reCore argument");
        }
        this.reCnfMgr = reCnfMgr;
        if (this.reCnfMgr == null) {
            throw new SeeTecException(-20002, "Invalid reCnfMgr argument");
        }
        this.htEntityStatus = new ConcurrentHashMap<Long, Integer>();
        this.htEntityCache = new ConcurrentHashMap<Long, Entity>();
        this.watchdog = new Watchdog();
        int nErrorCode = this.watchdog.init(this);
        if (nErrorCode != 0) {
            throw new SeeTecException(-20001, "Initializing of " + this.watchdog + " failed with error [" + nErrorCode + "]");
        }
        this.setStatusAgent = new SetStatusAgent(this.watchdog, this);
        this.setStatusAgent.init();
    }

    public final boolean isShutdown() {
        return this.isShutdown(ClassName);
    }

    public int shutdown() {
        if (this.startShutdown(ClassName)) {
            return 0;
        }
        this.setStatusAgent.shutdown();
        this.watchdog.shutdown();
        return 0;
    }

    public int notify(Long eventType, Long sourceID, byte[] additionalData) {
        try {
            if (eventType != null) {
                if (eventType.longValue() == EventType.ENT_EVENTTYPE_STATUS_CHANGED.getType()) {
                    Entity entity = this.htEntityCache.get(sourceID);
                    if (entity != null && additionalData != null) {
                        String sAdditionalData = new String(additionalData);
                        if (sAdditionalData.contains("<Status>0</Status>")) {
                            entity.setStatus(Integer.valueOf(0));
                        } else if (sAdditionalData.contains("<Status>1</Status>")) {
                            entity.setStatus(Integer.valueOf(1));
                        }
                    }
                    if (additionalData != null) {
                        StatusEvent statusEvent = (StatusEvent)Basic.unmarshalXML(StatusEvent.class, (Object)Basic.addRootTag((byte[])additionalData));
                        Integer cachedEntityStatus = this.htEntityStatus.get(sourceID);
                        if (cachedEntityStatus != null && cachedEntityStatus.intValue() != statusEvent.getStatus()) {
                            this.logger.info("Status changed for " + sourceID + " cachedEntityStatus :" + cachedEntityStatus + " eventEntityStatus: " + String.valueOf(statusEvent.getStatus()));
                        }
                    }
                } else if (eventType.longValue() == EventType.ENT_EVENTTYPE_ENTITY_CHANGED.getType()) {
                    this.htEntityCache.remove(sourceID);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entity getEntityByID(Long entityId) {
        try {
            if (this.entityCacheSynchronizeSubstitution.tryLock(1L, TimeUnit.MINUTES)) {
                Entity entity = this._getEntityByID(entityId);
                return entity;
            }
            try {
                throw new SeeTecException(-20000, "Could not acquire lock.");
            }
            catch (Throwable ex) {
                this.logger.warn("Got '" + ex.getMessage() + "' while requesting entity!");
                Entity entity = null;
                return entity;
            }
        }
        finally {
            if (this.entityCacheSynchronizeSubstitution.isHeldByCurrentThread()) {
                this.entityCacheSynchronizeSubstitution.unlock();
            }
        }
    }

    private Entity _getEntityByID(Long nEntityID) {
        if (nEntityID < 0L) {
            throw new RuntimeException("Negative EntityID not valid!");
        }
        Entity entity = this.htEntityCache.get(nEntityID);
        if (entity == null) {
            try {
                entity = this.watchdog.getEntMgrProxy().getEntityByID(nEntityID, Boolean.TRUE, TimeUnit.MINUTES.toMillis(1L));
                this.htEntityCache.put(nEntityID, entity);
            }
            catch (Throwable ex) {
                this.logger.warn("Cannot read entity [" + nEntityID + "] :-(", ex);
            }
        }
        return entity;
    }

    public Integer getEntityStatus(Long entityID) {
        return this.htEntityStatus.get(entityID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setEntityStatus(Long nEntityID, Integer nStatus) {
        try {
            if (this.generalSynchronizeSubstitution.tryLock(1L, TimeUnit.MINUTES)) {
                this.setStatusAgent.setEntityStatusToSubmit(nEntityID, nStatus, this.htEntityStatus.get(nEntityID));
                int n = 0;
                return n;
            }
            try {
                throw new SeeTecException(-20000, "Could not acquire lock.");
            }
            catch (Throwable ex) {
                this.logger.warn("Got '" + ex.getMessage() + "' while setting status!");
                int n = -20001;
                return n;
            }
        }
        finally {
            if (this.generalSynchronizeSubstitution.isHeldByCurrentThread()) {
                this.generalSynchronizeSubstitution.unlock();
            }
        }
    }

    @Override
    public void setStatusSuccessfull(long entityId, int status) {
        this.htEntityStatus.put(entityId, status);
        Entity cachedEntity = this.htEntityCache.get(entityId);
        if (cachedEntity != null) {
            cachedEntity.setStatus(Integer.valueOf(status));
            this.htEntityCache.put(entityId, cachedEntity);
        }
    }

    @Override
    public void setStatusIdUnknown(long entityId) {
        this.htEntityStatus.remove(entityId);
        this.htEntityCache.remove(entityId);
    }

    public void clearEntityStatus(Long nEntityID) {
        this.htEntityStatus.remove(nEntityID);
    }

    public int sendEvent(EventType eventType, long sourceID, long causeID, long eventTime, byte[] data) {
        block3: {
            EntMgrProxy entMgrProxy = null;
            try {
                entMgrProxy = this.watchdog.getEntMgrProxy();
                if (entMgrProxy == null) {
                    this.logger.error("Cannot send event with EventType=[" + eventType.getDescription() + "], SourceID=[" + sourceID + "], CauseID=[" + causeID + "], because no valid [EntMgr] is available.");
                    return -20062;
                }
                long eventID = this.getTicket();
                long eventTimestamp = eventTime;
                this.logger.info(Basic.generateIndentedMultiLineLog((String[])new String[]{"EventID=[" + eventID + "], EventType=[" + eventType.getDescription() + "], SourceID=[" + sourceID + "], CauseID=[" + causeID + "]"}));
                entMgrProxy.announce(Long.valueOf(eventID), Long.valueOf(eventType.getType()), Long.valueOf(sourceID), Long.valueOf(causeID), Long.valueOf(eventTimestamp), data, 20000L);
            }
            catch (Throwable ex) {
                this.logger.warn("Cannot send event with EventType=[" + eventType.getDescription() + "], SourceID=[" + sourceID + "], CauseID=[" + causeID + "] because of [" + ex.getMessage() + "]");
                if (entMgrProxy == null) break block3;
                entMgrProxy.shutdown();
            }
        }
        return 0;
    }

    public void sendLoggingEvent(EventType eventType, long sourceId, int errorCode, String subject, String body) {
        LoggingEvent loggingEvent = new LoggingEvent();
        loggingEvent.setErrorCode(errorCode);
        loggingEvent.setSubject(subject);
        loggingEvent.setBody(body);
        try {
            this.sendEvent(EventType.GENERAL_EVENTTYPE_LOGGING, sourceId, eventType.getType(), System.currentTimeMillis(), Basic.cutOffRoot((String)Basic.marshalXML((Object)loggingEvent)).getBytes());
        }
        catch (FileNotFoundException | JAXBException | SAXException ex) {
            this.logger.warn("Cannot send LOGGING event SourceID=[" + sourceId + "] because of [" + ex.getMessage() + "]");
        }
    }

    public long getCnfTicket() {
        block8: {
            if (!this.generalSynchronizeSubstitution.tryLock(1L, TimeUnit.MINUTES)) break block8;
            long l = this._getCnfTicket();
            if (this.generalSynchronizeSubstitution.isHeldByCurrentThread()) {
                this.generalSynchronizeSubstitution.unlock();
            }
            return l;
        }
        try {
            try {
                throw new SeeTecException(-20000, "Could not acquire lock.");
            }
            catch (Throwable ex) {
                this.logger.warn("Got '" + ex.getMessage() + "' while requesting Ticket!");
                if (this.generalSynchronizeSubstitution.isHeldByCurrentThread()) {
                    this.generalSynchronizeSubstitution.unlock();
                }
            }
        }
        catch (Throwable throwable) {
            if (this.generalSynchronizeSubstitution.isHeldByCurrentThread()) {
                this.generalSynchronizeSubstitution.unlock();
            }
            throw throwable;
        }
        return this.createRandomTicket();
    }

    private long _getCnfTicket() {
        ++this.nLastCnfTicket;
        if (this.nLastCnfTicket >= this.nCnfTicketStart + this.nCnfTicketRange) {
            try {
                Ticket ticket = this.getEntMgrProxy().getTicket(TimeUnit.SECONDS.toMillis(30L));
                this.nCnfTicketStart = ticket.getStart();
                this.nCnfTicketRange = ticket.getRange();
                this.nLastCnfTicket = this.nCnfTicketStart;
                this.logger.info("Got new ticket block [" + Basic.longToFormattedString((long)this.nCnfTicketStart) + ":" + Basic.longToFormattedString((long)(this.nCnfTicketStart + this.nCnfTicketRange)) + ") :-)");
            }
            catch (SeeTecException ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                this.nLastCnfTicket = this.createRandomTicket();
            }
        }
        this.logger.info("Deliver CnfTicket [" + Basic.longToFormattedString((long)this.nLastCnfTicket) + "] ...");
        return this.nLastCnfTicket;
    }

    public long getTicket() {
        block8: {
            if (!this.generalSynchronizeSubstitution.tryLock(1L, TimeUnit.MINUTES)) break block8;
            long l = this._getTicket();
            if (this.generalSynchronizeSubstitution.isHeldByCurrentThread()) {
                this.generalSynchronizeSubstitution.unlock();
            }
            return l;
        }
        try {
            try {
                throw new SeeTecException(-20000, "Could not acquire lock.");
            }
            catch (Throwable ex) {
                this.logger.warn("Got '" + ex.getMessage() + "' while requesting Ticket!");
                if (this.generalSynchronizeSubstitution.isHeldByCurrentThread()) {
                    this.generalSynchronizeSubstitution.unlock();
                }
            }
        }
        catch (Throwable throwable) {
            if (this.generalSynchronizeSubstitution.isHeldByCurrentThread()) {
                this.generalSynchronizeSubstitution.unlock();
            }
            throw throwable;
        }
        return this.createRandomTicket();
    }

    private long createRandomTicket() {
        long ticket = (long)(Math.random() * 8.0E12) + System.currentTimeMillis();
        return ticket;
    }

    private long _getTicket() {
        ++this.nLastEntTicket;
        if (this.nLastEntTicket >= this.nEntTicketStart + this.nEntTicketRange) {
            try {
                Ticket ticket = this.getEntMgrProxy().getTicket(TimeUnit.SECONDS.toMillis(30L));
                this.nEntTicketStart = ticket.getStart();
                this.nEntTicketRange = ticket.getRange();
                this.nLastEntTicket = this.nEntTicketStart;
                this.logger.info("Got new ticket block [" + this.nEntTicketStart + ":" + (this.nEntTicketStart + this.nEntTicketRange) + ") :-)");
            }
            catch (SeeTecException ex) {
                this.logger.error("Error while trying to get new ticket block [" + this.nEntTicketStart + ":" + (this.nEntTicketStart + this.nEntTicketRange) + "]", (Throwable)ex);
                this.nLastEntTicket = this.createRandomTicket();
            }
        }
        return this.nLastEntTicket;
    }

    public EntMgrProxy getEntMgrProxy() {
        return this.watchdog.getEntMgrProxy();
    }

    public String toString() {
        String sThis = "de.seetec.v5.shared.net.CoreServiceWrapper@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", ReCnfMgr: " + this.reCnfMgr + "]]";
    }

    public final String getCurrentCoreServiceHost() {
        return this.currentCoreServiceHost;
    }

    public final int getCurrentCoreServicePort() {
        return this.currentCoreServicePort;
    }

    public final long getCurrentCoreServiceId() {
        return this.currentCoreServiceId;
    }

    public class Watchdog
    extends Basic
    implements CoreServiceWrapperWatchdog {
        private static final String ClassName = "de.seetec.v5.shared.net.Watchdog";
        private Thread myThread = null;
        private CoreServiceWrapper coreServiceWrapper = null;
        private EntMgrProxy entMgrProxy = null;
        private String sEntMgrHost = null;
        private int nEntMgrPort = -1;
        private long entMgrID = Long.MIN_VALUE;

        @Override
        public int init(CoreServiceWrapper coreServiceWrapper) {
            this.coreServiceWrapper = coreServiceWrapper;
            if (this.coreServiceWrapper == null) {
                CoreServiceWrapper.this.logger.error("Invalid coreServiceWrapper argument");
                return -20002;
            }
            long tsTimeout = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
            while (tsTimeout > System.currentTimeMillis()) {
                try {
                    this.ensureEntMgrProxy();
                    if (this.entMgrProxy != null) {
                        break;
                    }
                }
                catch (Throwable ex) {
                    CoreServiceWrapper.this.logger.warn("Error while ensuring proxies: " + ex.getMessage() + ". Trying again.");
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.myThread = new Thread((Runnable)this, this.toString());
            this.myThread.start();
            return 0;
        }

        @Override
        public int shutdown() {
            if (this.startShutdown(ClassName)) {
                return 0;
            }
            if (this.entMgrProxy != null) {
                this.entMgrProxy.shutdown();
                this.entMgrProxy = null;
            }
            return 0;
        }

        @Override
        public void run() {
            try {
                while (!this.isShutdown(ClassName) && !this.coreServiceWrapper.isShutdown()) {
                    try {
                        this.ensureEntMgrProxy();
                    }
                    catch (Throwable ex) {
                        CoreServiceWrapper.this.logger.error("Cannot ensure [EntityManager] :-(", ex);
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {}
                }
            }
            catch (Throwable ex) {
                CoreServiceWrapper.this.logger.error((Object)ex, ex);
            }
        }

        private int ensureEntMgrProxy() {
            if (this.entMgrProxy != null && !this.entMgrProxy.isShutdown() && this.entMgrProxy.isReady()) {
                return 0;
            }
            if (this.entMgrProxy != null && this.entMgrProxy.isShutdown()) {
                CoreServiceWrapper.this.logger.warn(this.entMgrProxy + " is already shutting down, so creating a new instance ...");
            }
            if (this.entMgrProxy != null && !this.entMgrProxy.isReady()) {
                CoreServiceWrapper.this.logger.warn(this.entMgrProxy + " is not valid, so creating a new instance ...");
            }
            if (this.entMgrProxy != null) {
                this.entMgrProxy.shutdown();
            }
            this.entMgrProxy = null;
            try {
                this.sEntMgrHost = CoreServiceWrapper.this.reCnfMgr.getEntMgrHost();
                this.nEntMgrPort = CoreServiceWrapper.this.reCnfMgr.getEntMgrPort();
                this.entMgrID = CoreServiceWrapper.this.reCnfMgr.getEntMgrId();
            }
            catch (Throwable throwable) {
                CoreServiceWrapper.this.logger.warn("Error while reading ReCnf.");
            }
            EntMgrProxy tempEntMgrProxy = new EntMgrProxy();
            int nErrorCode = tempEntMgrProxy.init(this.sEntMgrHost, this.nEntMgrPort, 2L, 30000L);
            if (nErrorCode != 0) {
                CoreServiceWrapper.this.logger.warn("Creating [EntMgrProxy] to [" + this.sEntMgrHost + ":" + this.nEntMgrPort + " (ID: " + this.entMgrID + ")] failed with error [" + nErrorCode + "]");
                try {
                    if (!CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainHost().equalsIgnoreCase("-1") && CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainPort() != -1) {
                        nErrorCode = tempEntMgrProxy.init(CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainHost(), CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainPort(), 2L, 30000L);
                        if (nErrorCode != 0) {
                            tempEntMgrProxy.shutdown();
                            CoreServiceWrapper.this.logger.error("Creating [CoreServiceMainProxy] to [" + CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainHost() + ":" + CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainPort() + " (ID: " + 2L + ")]  failed with error [" + nErrorCode + "]");
                            return -20062;
                        }
                        this.entMgrProxy = tempEntMgrProxy;
                        CoreServiceWrapper.this.currentCoreServiceHost = CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainHost();
                        CoreServiceWrapper.this.currentCoreServicePort = CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainPort();
                        CoreServiceWrapper.this.currentCoreServiceId = 2L;
                        CoreServiceWrapper.this.logger.info("Connected to CoreServiceMain " + CoreServiceWrapper.this.currentCoreServiceHost + ":" + CoreServiceWrapper.this.currentCoreServicePort + " (ID: " + CoreServiceWrapper.this.currentCoreServiceId + ")");
                        this.registerToEntMgr();
                        return 0;
                    }
                    CoreServiceWrapper.this.currentCoreServiceHost = this.sEntMgrHost;
                    CoreServiceWrapper.this.currentCoreServicePort = this.nEntMgrPort;
                    CoreServiceWrapper.this.currentCoreServiceId = this.entMgrID;
                }
                catch (Throwable throwable) {
                    CoreServiceWrapper.this.logger.warn("Error while establishing EntMgrProxy: " + throwable.getMessage(), throwable);
                }
                tempEntMgrProxy.shutdown();
                try {
                    CoreServiceWrapper.this.logger.error("Creating [CoreServiceMainProxy] to [" + CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainHost() + ":" + CoreServiceWrapper.this.reCnfMgr.getCoreServiceMainPort() + " (ID: " + 2L + ")] failed with error [" + nErrorCode + "]");
                }
                catch (ConfigurationException configurationException) {
                    CoreServiceWrapper.this.logger.error("Creating [CoreServiceMainProxy] failed with error [" + nErrorCode + "]");
                }
                return -20062;
            }
            CoreServiceWrapper.this.currentCoreServiceHost = this.sEntMgrHost;
            CoreServiceWrapper.this.currentCoreServicePort = this.nEntMgrPort;
            try {
                CoreServiceWrapper.this.currentCoreServiceId = CoreServiceWrapper.this.reCnfMgr.getEntMgrId();
            }
            catch (ConfigurationException ex) {
                CoreServiceWrapper.this.currentCoreServiceId = -1L;
            }
            CoreServiceWrapper.this.logger.info("Connected to " + CoreServiceWrapper.this.currentCoreServiceHost + ":" + CoreServiceWrapper.this.currentCoreServicePort + " (ID: " + CoreServiceWrapper.this.currentCoreServiceId + ")");
            this.entMgrProxy = tempEntMgrProxy;
            this.registerToEntMgr();
            return 0;
        }

        private void registerToEntMgr() {
            int errorCode;
            if (this.coreServiceWrapper != null && this.coreServiceWrapper.reCore != null && (errorCode = this.coreServiceWrapper.reCore.registerEntity()) != 0) {
                CoreServiceWrapper.this.logger.warn("Registering after ensureEntMgrProxy failed for " + this + "because error: " + errorCode);
            }
        }

        @Override
        public EntMgrProxy getEntMgrProxy() {
            if (this.entMgrProxy != null && this.entMgrProxy.isReady()) {
                return this.entMgrProxy;
            }
            return null;
        }

        public String toString() {
            String sThis = "de.seetec.v5.shared.net.Watchdog@" + Integer.toHexString(this.hashCode());
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.coreServiceWrapper + "], " + this.entMgrProxy + "]]";
        }
    }
}

