/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

import de.seetec.v5.re.shared.ConfigurationElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class ConfigurationManager {
    private static final String RE_CNF_KEY_VERSION = "version";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private String sCnfFile = null;
    private Document xmlCnf = null;
    private ConfigurationElement root = null;

    public int init(String sName, String sVersion) {
        if (sName == null) {
            this.logger.error("Parameter [sName] is [null] :-(");
            return -20002;
        }
        if (sVersion == null) {
            this.logger.error("Parameter [sVersion] is [null] :-(");
            return -20002;
        }
        Element eElement = new Element("SeeTec");
        eElement.setAttribute("name", sName);
        eElement.setAttribute(RE_CNF_KEY_VERSION, sVersion);
        this.xmlCnf = new Document(eElement);
        this.root = new ConfigurationElement(eElement);
        return 0;
    }

    public int init(byte[] configuration) {
        try {
            if (configuration != null && configuration.length > 0) {
                ByteArrayInputStream bais = new ByteArrayInputStream(configuration);
                this.xmlCnf = new SAXBuilder().build((InputStream)bais);
            } else {
                this.xmlCnf = new Document();
            }
            this.root = new ConfigurationElement(this.xmlCnf.getRootElement());
        }
        catch (Exception ex) {
            this.logger.error("Creating configuration failed :-(", (Throwable)ex);
            return -20039;
        }
        return 0;
    }

    public int init(String sCnfFile) {
        this.sCnfFile = sCnfFile;
        if (this.sCnfFile == null) {
            this.logger.error("Argumtent [sCnfFile] is [null] :-(");
            return -20002;
        }
        File fXMLFile = new File(sCnfFile);
        String sFilePath = this.getCanonicalFilePath(fXMLFile);
        try {
            if (!fXMLFile.exists()) {
                this.logger.error("File [" + sFilePath + "] doesn't exists :-(");
                return -20020;
            }
            if (fXMLFile.length() > 0x100000L) {
                this.logger.error("File [" + sFilePath + "] is too large :-(");
                return -20021;
            }
            this.xmlCnf = new SAXBuilder().build((InputStream)new FileInputStream(fXMLFile));
            this.root = new ConfigurationElement(this.xmlCnf.getRootElement());
        }
        catch (Exception ex) {
            this.logger.error("Reading file [" + sFilePath + "] failed :-(", (Throwable)ex);
            return -20030;
        }
        return 0;
    }

    public int writeCnfFile() {
        return this.writeCnfFile(this.sCnfFile);
    }

    public int writeCnfFile(String sNewCnfFile) {
        return this.writeCnfFile(sNewCnfFile, null);
    }

    public int writeCnfFile(Charset charset) {
        return this.writeCnfFile(this.sCnfFile, charset);
    }

    public int writeCnfFile(String sNewCnfFile, Charset charset) {
        int nErrorCode = 0;
        OutputStreamWriter fileWriter = null;
        try {
            if (charset == null) {
                fileWriter = new FileWriter(sNewCnfFile);
            } else {
                FileOutputStream fileStream = new FileOutputStream(sNewCnfFile);
                fileWriter = new OutputStreamWriter((OutputStream)fileStream, charset.name());
            }
            XMLOutputter outputter = new XMLOutputter("   ", true);
            outputter.output(this.xmlCnf, (Writer)fileWriter);
        }
        catch (Throwable ex) {
            this.logger.error("Writung configuration file [" + sNewCnfFile + "] failed :-(");
            nErrorCode = -20031;
        }
        try {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Discarding " + fileWriter + " failed :-(");
        }
        return nErrorCode;
    }

    public ConfigurationElement getRootElement() {
        return this.root;
    }

    public Document getDocument() {
        return this.xmlCnf;
    }

    private String getCanonicalFilePath(File file) {
        String sPath = file.getAbsolutePath();
        try {
            sPath = file.getCanonicalPath();
        }
        catch (Exception ex) {
            this.logger.debug("Exception while determing canonical path.");
        }
        return sPath.replace('\\', '/');
    }
}

