/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.shared;

public enum Codec {
    UNKNOWN(0),
    G711U(1),
    G726(2),
    AAC(3),
    PCM(4),
    MPEG4(5),
    H264(6),
    H263(7),
    H263_VCS(8),
    G711A(9),
    MJPEG(10),
    MXPEG(11),
    RTSP(12),
    H265(20);

    private final int type;

    private Codec(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static boolean isExisting(int givenType) {
        for (Codec t : Codec.values()) {
            if (givenType != t.type) continue;
            return true;
        }
        return false;
    }

    public static Codec valueOf(int givenType) {
        Codec type = null;
        for (Codec t : Codec.values()) {
            if (givenType != t.type) continue;
            type = t;
            break;
        }
        return type;
    }

    public String toString() {
        return "Codec: " + this.getType() + ", Name: " + this.name();
    }
}

