/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.md.server;

import de.seetec.v5.re.md.server.$A;
import de.seetec.v5.re.md.server.Z;
import de.seetec.v5.re.shared.ConfigurationElement;
import de.seetec.v5.re.shared.RECnfMgr;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class MDSCnfMgr
extends RECnfMgr {
    private ConfigurationElement B = null;
    private ConfigurationElement A = null;
    private final _A C = new _A();

    public int init(String string, int n2) {
        try {
            int n3 = super.init(string, n2);
            if (n3 != 0) {
                throw new SeeTecException(-21018, "Initiailizing of [RECnfMgr] failed with error [" + n3 + "]");
            }
            try {
                ConfigurationElement configurationElement = this.getRoot().getChild("DirectoryStatistic");
                if (configurationElement != null) {
                    ConfigurationElement configurationElement2;
                    ConfigurationElement configurationElement3;
                    ConfigurationElement configurationElement4 = configurationElement.getChild("Active");
                    if (configurationElement4 != null) {
                        this.C.B = configurationElement4.getAsBoolean();
                    }
                    if ((configurationElement3 = configurationElement.getChild("StartWithDay")) != null) {
                        this.C.A = configurationElement3.getAsInt8();
                    }
                    if ((configurationElement2 = configurationElement.getChild("EndWithDay")) != null) {
                        this.C.C = configurationElement2.getAsInt8();
                    }
                }
            }
            catch (ConfigurationException configurationException) {
                this.logger.warn((Object)configurationException, (Throwable)configurationException);
            }
            this.B = this.getRoot().getChild("DeviceID");
            if (this.B == null) {
                this.B = this.getRoot().createChild("DeviceID");
                this.B.setAsInt8(-1L);
            }
            this.A = this.getRoot().getChild("Zones");
            if (this.A == null) {
                this.A = this.getRoot().createChild("Zones");
            }
        }
        catch (Exception exception) {
            this.logger.error("Initiailizing of [RECnfMgr] failed :-(", (Throwable)exception);
            return -21018;
        }
        return 0;
    }

    public List<$A> getZones() {
        List<$A> list = Collections.emptyList();
        try {
            List list2 = this.A.getChildren((String)null, "Zone");
            if (list2 != null) {
                list = new ArrayList<$A>(list2.size());
                for (int i2 = 0; i2 < list2.size(); ++i2) {
                    ConfigurationElement configurationElement = (ConfigurationElement)list2.get(i2);
                    ConfigurationElement configurationElement2 = configurationElement.getChild("Path");
                    ConfigurationElement configurationElement3 = configurationElement.getChild("MaxSize");
                    ConfigurationElement configurationElement4 = configurationElement.getChild("Type");
                    $A $A = new $A(configurationElement2.getAsString(), configurationElement3.getAsInt8(), configurationElement4.getAsString());
                    this.A(configurationElement, $A, configurationElement2);
                    list.add($A);
                }
            }
        }
        catch (ConfigurationException configurationException) {
            this.logger.error((Object)configurationException, (Throwable)configurationException);
            throw new RuntimeException("Cannot determine zone infos :-(");
        }
        return list;
    }

    private void A(ConfigurationElement configurationElement, $A $A, ConfigurationElement configurationElement2) {
        ConfigurationElement configurationElement3 = configurationElement.getChild("Prefetch");
        if (configurationElement3 == null) {
            return;
        }
        ConfigurationElement configurationElement4 = configurationElement3.getChild("enabled");
        try {
            $A.A(configurationElement4.getAsBoolean());
            ConfigurationElement configurationElement5 = configurationElement3.getChild("time");
            try {
                long l2 = configurationElement5.getAsInt4();
                if (l2 < 0L || l2 > TimeUnit.HOURS.toSeconds(5L)) {
                    this.logger.warn("Insane prefetch time has been set for zone " + configurationElement2.getAsString() + ". Default time " + Z.\u010e + " will be set.");
                    l2 = Z.\u010e;
                }
                $A.A(l2);
            }
            catch (Exception exception) {
                this.logger.warn("Couldn't read prefetch time for zone " + configurationElement2.getAsString() + ". Default time " + Z.\u010e + " will be set.");
                $A.A(Z.\u010e);
            }
        }
        catch (Exception exception) {
            this.logger.warn("Couldn't read prefetch settings for zone " + configurationElement2.getAsString() + ". Prefetch will be disabled.");
            $A.A(false);
        }
    }

    public boolean useEmergencyMode() {
        boolean bl = true;
        return this.A("UseEmergencyMode", bl);
    }

    public boolean useCloudMode() {
        boolean bl = false;
        return this.A("UseCloudMode", bl);
    }

    private boolean A(String string, boolean bl) {
        try {
            ConfigurationElement configurationElement = this.getRoot().getChild(string);
            if (configurationElement == null) {
                configurationElement = this.getRoot().createChild(string);
                configurationElement.setAsBoolean(bl);
            }
            return configurationElement.getAsBoolean();
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn((Object)configurationException, (Throwable)configurationException);
            return bl;
        }
    }

    public Long getCloudModeLocalZoneWarningThreshold() {
        long l2 = 90L;
        try {
            long l3;
            ConfigurationElement configurationElement = this.getRoot().getChild("CloudModeLocalZoneWarningThreshold");
            if (configurationElement == null) {
                configurationElement = this.getRoot().createChild("CloudModeLocalZoneWarningThreshold");
                configurationElement.setAsInt8(l2);
            }
            if (0L < (l3 = configurationElement.getAsInt8()) && l3 < 100L) {
                return configurationElement.getAsInt8();
            }
        }
        catch (ConfigurationException configurationException) {
            this.logger.warn((Object)configurationException, (Throwable)configurationException);
        }
        return l2;
    }

    public String getPathOfPreAlarmBuffer() {
        ConfigurationElement configurationElement = this.getRoot().getChild("PathOfPreAlarmBuffer");
        if (configurationElement != null) {
            return configurationElement.getAsString();
        }
        return null;
    }

    public int getWriteCache() {
        try {
            ConfigurationElement configurationElement = this.getRoot().getChild("WriteCache");
            if (configurationElement == null) {
                configurationElement = this.getRoot().createChild("WriteCache");
                configurationElement.setAsInt4(524288);
            }
            return configurationElement.getAsInt4();
        }
        catch (ConfigurationException configurationException) {
            this.logger.error((Object)configurationException, (Throwable)configurationException);
            throw new RuntimeException("Trouble reading configuration :-(");
        }
    }

    public long getMaxTileTimerange() {
        try {
            ConfigurationElement configurationElement = this.getRoot().getChild("MaxTileTimerange");
            if (configurationElement != null) {
                return configurationElement.getAsInt8();
            }
        }
        catch (ConfigurationException configurationException) {
            this.logger.error("Error reading configuration for MaxTileTimerange [" + (Object)((Object)configurationException) + "]");
        }
        return 1200000L;
    }

    public long getDeviceID() {
        try {
            return this.getEntityID() + 1L;
        }
        catch (ConfigurationException configurationException) {
            this.logger.error((Object)configurationException, (Throwable)configurationException);
            throw new RuntimeException("Trouble reading configuration :-(");
        }
    }

    public boolean isDirectoryStatisticActive() {
        return this.C.B;
    }

    public long[] getDirectoryStatisticTimerange() {
        return new long[]{this.C.A, this.C.C};
    }

    private static class _A {
        boolean B = false;
        long A = 7L;
        long C = 10L;

        private _A() {
        }
    }
}

