/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.md.server.C;

import de.seetec.v5.re.md.server.C.A;
import de.seetec.v5.re.md.server.C.C;
import de.seetec.v5.re.md.server.Core;
import de.seetec.v5.re.shared.DataObjectAlarmInstance;
import de.seetec.v5.re.shared.DataObjectBackupInfo;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.re.shared.SqlDatabaseHandler;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class B
implements SqlDatabaseHandler {
    static final String E = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String D = "Version";
    private final Logger C = LogManager.getLogger((String)this.getClass().getName());
    private Core A = null;
    private String F = "jdbc:derby:../../../../derby/mds/commondb;create=true";
    private Connection B = null;

    public B(Core core) throws SeeTecException {
        this.A = core;
        if (this.A == null) {
            throw new SeeTecException(-23101, "Core null");
        }
        try {
            String string = this.A.getCnfMgr().getCommonDBPath();
            if (string != null && string.trim().length() > 0) {
                File file = new File(string);
                if (!file.exists()) {
                    throw new SeeTecException(-23200, "Database path [" + string + "] doesn't exist.");
                }
                if (!file.isDirectory()) {
                    throw new SeeTecException(-23200, "Database path [" + string + "] isn't a directory ");
                }
                if (!file.canWrite()) {
                    throw new SeeTecException(-23200, "Database path [" + string + "] isn't writable");
                }
                this.F = string.trim().endsWith("commondb") ? "jdbc:derby:" + string.trim() + ";create=true" : "jdbc:derby:" + string.trim() + RECore.FileSeparator + "commondb;create=true";
            }
        }
        catch (SeeTecException seeTecException) {
            throw seeTecException;
        }
        catch (Throwable throwable) {
            this.C.warn("Problems parsing path of database :-(", throwable);
        }
        this.C.info("Using dbURL [" + this.F + "] ...");
        this.connect();
        int n2 = this.ensureTableTableVersion();
        if (n2 != 0) {
            this.C.fatal("Cannot create table [Version], so exiting :-(");
            System.exit(n2);
        }
        try {
            DataObjectBackupInfo.updateDatabaseSchema((SqlDatabaseHandler)this, (Logger)this.C);
            DataObjectAlarmInstance.updateDatabaseSchema((SqlDatabaseHandler)this, (Logger)this.C);
            de.seetec.v5.re.md.server.C.C.A(this, this.C);
            de.seetec.v5.re.md.server.C.A.A(this);
        }
        catch (Throwable throwable) {
            this.C.error((Object)throwable, throwable);
            System.exit(n2);
        }
    }

    public void shutdown() {
        this.C.info("Starting shutdown of " + this + " ...");
        try {
            this.disconnect();
        }
        catch (Throwable throwable) {
            this.C.warn((Object)throwable, throwable);
        }
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (Throwable throwable) {
            this.C.warn(throwable.getMessage());
        }
    }

    public void connect() throws SeeTecException {
        try {
            Class.forName(E).newInstance();
        }
        catch (Throwable throwable) {
            this.C.error((Object)throwable, throwable);
            throw new SeeTecException(-1, "Problems loading jdbc driver :-(");
        }
        try {
            this.B = DriverManager.getConnection(this.F);
        }
        catch (Throwable throwable) {
            this.C.error((Object)throwable, throwable);
            throw new SeeTecException(-1, "Problems establishing sql connection :-(");
        }
        try {
            DatabaseMetaData databaseMetaData = this.B.getMetaData();
            String string = databaseMetaData.getDatabaseProductName();
            String string2 = databaseMetaData.getDatabaseProductVersion();
            this.C.info("Derby: Using " + string + " " + string2);
        }
        catch (Throwable throwable) {
            this.C.warn("Derby: Problems determing product name and version!", throwable);
        }
    }

    public void disconnect() {
        try {
            if (this.B != null && !this.B.isClosed()) {
                this.B.close();
                this.B = null;
            }
        }
        catch (SQLException sQLException) {
            this.C.warn((Object)sQLException, (Throwable)sQLException);
        }
    }

    public boolean doesTableExist(String string) {
        String string2 = "SELECT tablename FROM sys.systables";
        boolean bl = false;
        try (Statement statement = this.B.createStatement();
             ResultSet resultSet = statement.executeQuery(string2);){
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                if (!string3.trim().equalsIgnoreCase(string)) continue;
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            this.C.warn("Problems exeuting sql statement: " + string2, (Throwable)sQLException);
        }
        catch (Throwable throwable) {
            this.C.warn((Object)throwable, throwable);
        }
        return bl;
    }

    public int ensureTableTableVersion() {
        if (this.doesTableExist(D)) {
            return 0;
        }
        String string = "CREATE TABLE Version ( Timestamp BIGINT NOT NULL, TableName VARCHAR( 256 ) NOT NULL, Version VARCHAR( 256 ) NOT NULL )";
        int n2 = this.executeSqlUpdate(string);
        if (n2 != 0) {
            this.C.error("Cannot create table <Version> :-(");
            return n2;
        }
        return 0;
    }

    public int dropTable(String string) {
        this.C.info("Droping table [" + string + "] ...");
        return this.executeSqlUpdate("DROP TABLE " + string);
    }

    public int updateTableVersion(String string, String string2) {
        this.C.info("Updating table [" + string + "] with version [" + string2 + " ...");
        this.executeSqlUpdate("DELETE FROM Version WHERE tablename='" + string + "'");
        this.executeSqlUpdate("INSERT INTO Version ( Timestamp, TableName, Version ) VALUES ( " + System.currentTimeMillis() + ", '" + string + "', '" + string2 + "' )");
        return 0;
    }

    public int executeSqlUpdate(String string) {
        try {
            this.C.info("Executing query [" + string + "] ...");
            try (Statement statement = this.B.createStatement();){
                statement.executeUpdate(string);
            }
            return 0;
        }
        catch (SQLException sQLException) {
            this.C.warn("Problems exeuting sql statement: " + string, (Throwable)sQLException);
            return -23100;
        }
        catch (Throwable throwable) {
            this.C.warn((Object)throwable, throwable);
            return -23100;
        }
    }

    public int addBackupInfo(DataObjectBackupInfo dataObjectBackupInfo) {
        return dataObjectBackupInfo.updateEntry((SqlDatabaseHandler)this);
    }

    public int addAlarmInstance(DataObjectAlarmInstance dataObjectAlarmInstance) {
        return dataObjectAlarmInstance.updateEntry((SqlDatabaseHandler)this);
    }

    public int writeAlarmInstances(LinkedList<Long[]> linkedList) {
        for (Long[] longArray : linkedList) {
            try {
                this.addAlarmInstance(new DataObjectAlarmInstance(longArray[0], longArray[1], longArray[2], longArray[3], longArray[4]));
            }
            catch (SeeTecException seeTecException) {
                this.C.warn((Object)seeTecException, (Throwable)seeTecException);
                return seeTecException.getErrorCode();
            }
        }
        return 0;
    }

    public Long[] getAlarmInstance(Long l2, Long l3) {
        return DataObjectAlarmInstance.getAlarmInstance((Connection)this.getConnection(), (Logger)this.C, (Long)l2, (Long)l3);
    }

    public LinkedList<byte[]> getAlarmScenarioOccurrencies(Long l2, Long l3, Long l4) {
        return DataObjectAlarmInstance.getAlarmScenarioOccurrencies((Connection)this.getConnection(), (Logger)this.C, (Long)l2, (Long)l3, (Long)l4);
    }

    public LinkedList<Long[]> getAlarmInstances(Long l2, Long l3, Long l4) {
        return DataObjectAlarmInstance.getAlarmInstances((Connection)this.getConnection(), (Logger)this.C, (Long)l2, (Long)l3, (Long)l4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTableVersion(String string) {
        String string2 = "SELECT TableName, Version FROM Version WHERE TABLENAME='" + string + "'";
        try (Statement statement = this.B.createStatement();
             ResultSet resultSet = statement.executeQuery(string2);){
            if (!resultSet.next()) return null;
            String string3 = resultSet.getString(2);
            return string3;
        }
        catch (SQLException sQLException) {
            this.C.warn("Problems exeuting sql statement: " + string2, (Throwable)sQLException);
            return null;
        }
        catch (Throwable throwable) {
            this.C.warn((Object)throwable, throwable);
            return null;
        }
    }

    public int retryBackup(Long l2, Long l3) {
        return DataObjectBackupInfo.retryBackup((SqlDatabaseHandler)this, (Long)l2, (Long)l3, (Logger)this.C);
    }

    public int discardFailedBackup(Long l2, Long l3) {
        return DataObjectBackupInfo.discardFailedBackup((SqlDatabaseHandler)this, (Long)l2, (Long)l3, (Logger)this.C);
    }

    public List<DataObjectBackupInfo> getFailedBackups() {
        return DataObjectBackupInfo.getFailedBackups((SqlDatabaseHandler)this, (Logger)this.C);
    }

    public List<DataObjectBackupInfo> getQueuedBackups() {
        return DataObjectBackupInfo.getQueuedBackups((SqlDatabaseHandler)this, (Logger)this.C);
    }

    public DataObjectBackupInfo getQueuedBackup(long l2) throws SQLException, SeeTecException {
        return DataObjectBackupInfo.getQueuedBackup((SqlDatabaseHandler)this, (Logger)this.C, (long)l2);
    }

    public Connection getConnection() {
        return this.B;
    }
}

