/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.srpc;

import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.GObject;
import java.util.List;

public class ReqTriggerAction {
    private static final String METHODNAME = "TriggerAction";
    private final Long clientID;
    private final Long lockTimeout;
    private final Long actionID;
    private final Long alarmScriptID;
    private final Long alarmInstanceID;
    private final Long alarmTimerange;
    private final byte[] genericData;

    public ReqTriggerAction(Long clientID, Long lockTimeout, Long actionID, Long alarmScriptID, Long alarmInstanceID, Long alarmTimerange, byte[] genericData) {
        this.clientID = clientID;
        this.lockTimeout = lockTimeout;
        this.actionID = actionID;
        this.alarmScriptID = alarmScriptID;
        this.alarmInstanceID = alarmInstanceID;
        this.alarmTimerange = alarmTimerange;
        this.genericData = genericData;
    }

    public static ReqTriggerAction parseGObject(GObject goRequest) {
        int position = -1;
        List paramter = goRequest.getChildren();
        Long clientID = null;
        Long lockTimeout = null;
        if (paramter.size() > 5) {
            clientID = goRequest.getChildAt(++position).getAsLong();
            lockTimeout = goRequest.getChildAt(++position).getAsLong();
        }
        Long actionID = goRequest.getChildAt(++position).getAsLong();
        Long alarmScriptID = goRequest.getChildAt(++position).getAsLong();
        Long alarmInstanceID = goRequest.getChildAt(++position).getAsLong();
        Long alarmTimerange = goRequest.getChildAt(++position).tryGetAsLong();
        byte[] genericData = null;
        if (goRequest.getChildren().size() > 6) {
            genericData = goRequest.getChildAt(++position).getAsArrayOfByte();
        }
        return new ReqTriggerAction(clientID, lockTimeout, actionID, alarmScriptID, alarmInstanceID, alarmTimerange, genericData);
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.clientID);
        goResponse.addChild(this.lockTimeout);
        goResponse.addChild(this.actionID);
        goResponse.addChild(this.alarmScriptID);
        goResponse.addChild(this.alarmInstanceID);
        goResponse.addChild(this.alarmTimerange);
        goResponse.addChild(this.genericData);
        return goResponse;
    }

    public Long getClientID() {
        return this.clientID;
    }

    public Long getLockTimeout() {
        return this.lockTimeout;
    }

    public Long getActionID() {
        return this.actionID;
    }

    public Long getAlarmScriptID() {
        return this.alarmScriptID;
    }

    public Long getAlarmInstanceID() {
        return this.alarmInstanceID;
    }

    public Long getAlarmTimerange() {
        return this.alarmTimerange;
    }

    public byte[] getGenericData() {
        return this.genericData;
    }

    public final String toString() {
        return "[TriggerAction, ClientID=[" + Basic.longToFormattedString((Long)this.clientID) + "], LockTimeout=[" + Basic.longToFormattedString((Long)this.lockTimeout) + "], ActionID=[" + Basic.longToFormattedString((Long)this.actionID) + "], AlarmScriptID=[" + Basic.longToFormattedString((Long)this.alarmScriptID) + "], AlarmInstanceID=[" + Basic.longToFormattedString((Long)this.alarmInstanceID) + "], AlarmTimerange=[" + Basic.longToFormattedString((Long)this.alarmTimerange) + " ms]]";
    }
}

