/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.sql;

import de.seetec.v5.re.cm.shared.sql.DataObjectEdgeStorageMarker;
import de.seetec.v5.re.shared.RECore;
import de.seetec.v5.shared.EventType;
import de.seetec.v5.shared.OpenProblemPersistenceEngine;
import de.seetec.v5.shared.OpenProblemWrapper;
import de.seetec.v5.shared.VMParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SQLDatabaseHandler
implements OpenProblemPersistenceEngine {
    private static final Logger LOGGER = LogManager.getLogger(SQLDatabaseHandler.class);
    private final String tnTableVersion = "Version";
    private final String tnTableProblem = "Problem";
    private String url = "jdbc:derby:../../../derby/cm/commondb;create=true";
    private Connection connection = null;
    private boolean bDatabaseReady = false;
    private final Lock saveLock = new ReentrantLock();

    public int init(String optionalDBPatch, String extension) {
        try {
            if (optionalDBPatch != null && optionalDBPatch.trim().length() > 0) {
                File file = new File(optionalDBPatch);
                if (!file.exists()) {
                    LOGGER.error("Database path [" + optionalDBPatch + "] doesn't exists.");
                    return -21691;
                }
                if (!file.isDirectory()) {
                    LOGGER.error("Database path [" + optionalDBPatch + "] isn't a directory.");
                    return -21691;
                }
                if (!file.canWrite()) {
                    LOGGER.error("Database path [" + optionalDBPatch + "] isn't writable.");
                    return -21691;
                }
                this.url = optionalDBPatch.trim().endsWith("commondb") ? "jdbc:derby:" + optionalDBPatch.trim() + ";create=true" : "jdbc:derby:" + optionalDBPatch.trim() + RECore.FileSeparator + "commondb;create=true";
            }
        }
        catch (Throwable ex) {
            LOGGER.warn("Problems parsing path of database because of [" + ex.getMessage() + "]");
        }
        try {
            if (extension.contains("USEDERBYCACHE")) {
                this.setCacheSize(this.calculateCacheSizeToSet(VMParameter.getMaxMemory((String)VMParameter.getVMParameters()) / 0x100000L));
            }
        }
        catch (SeeTecException ex) {
            LOGGER.warn("Cannot set cache size for derby. Reason: " + ex.getMessage());
        }
        try {
            this.connect();
        }
        catch (SeeTecException ex) {
            this.bDatabaseReady = false;
            LOGGER.error("Cannot connect to logging database [" + this.url + "] because of [" + ex.getMessage() + "]");
            return -21691;
        }
        int errorCode = this.ensureTableVersion();
        if (errorCode != 0) {
            return errorCode;
        }
        errorCode = this.ensureProblemTable();
        if (errorCode != 0) {
            return errorCode;
        }
        try {
            DataObjectEdgeStorageMarker.updateDatabaseSchema(this, LOGGER);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("[" + DataObjectEdgeStorageMarker.getNumberOfMarker(SQLDatabaseHandler.this, LOGGER) + "] entries in [" + "DataObjectEdgeStorageMarker" + "]");
                }
            }, this.toString()).start();
        }
        catch (Throwable ex) {
            LOGGER.error("Error setting up database stuff for edge storage because of [" + ex.getMessage() + "]");
            System.exit(errorCode);
        }
        this.bDatabaseReady = true;
        return 0;
    }

    protected long calculateCacheSizeToSet(long assignedMemoryToDMinMB) {
        return assignedMemoryToDMinMB / 10L > 500L ? 500L : assignedMemoryToDMinMB / 10L;
    }

    protected void setCacheSize(long cacheSizeToSetInMB) throws SeeTecException {
        if (cacheSizeToSetInMB <= 0L) {
            throw new SeeTecException(-20002, "Negative value for derby cache size.");
        }
        Properties properties = System.getProperties();
        int pageSize = properties.getProperty("derby.storage.pageSize") == null ? 4096 : Integer.parseInt(properties.getProperty("derby.storage.pageSize"));
        long cacheSizeInPages = cacheSizeToSetInMB * 1024L * 1024L / (long)pageSize;
        cacheSizeInPages = cacheSizeInPages < 1000L ? 1000L : cacheSizeInPages;
        properties.put("derby.storage.pageCacheSize", Long.toString(cacheSizeInPages));
    }

    protected int getCacheSize() throws NumberFormatException {
        Properties sprops = System.getProperties();
        int pageSize = sprops.getProperty("derby.storage.pageSize") == null ? 4096 : Integer.parseInt(sprops.getProperty("derby.storage.pageSize"));
        int pageCacheSize = sprops.getProperty("derby.storage.pageCacheSize") == null ? 1000 : Integer.parseInt(sprops.getProperty("derby.storage.pageCacheSize"));
        return pageSize * pageCacheSize / 0x100000;
    }

    public void shutdown() {
        try {
            this.disconnect();
        }
        catch (Throwable ex) {
            LOGGER.warn("Problems while disconnectiong Derby DB");
        }
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException ex) {
            LOGGER.warn("Problems while shutting down Derby DB");
        }
    }

    private void connect() throws SeeTecException {
        String driver = "org.apache.derby.jdbc.EmbeddedDriver";
        try {
            Class.forName(driver).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            throw new SeeTecException(-1, "Problems loading jdbc driver because of [" + ex.getMessage() + "]");
        }
        try {
            this.connection = DriverManager.getConnection(this.url);
            LOGGER.info("Got connection " + this.connection + ". Used cacheSize [MB]: " + this.getCacheSize());
        }
        catch (SQLException ex) {
            throw new SeeTecException(-1, "Problems establishing sql connection to " + this.url + " because of [" + ex.getMessage() + "]");
        }
        try {
            DatabaseMetaData dbMetaData = this.connection.getMetaData();
            String productName = dbMetaData.getDatabaseProductName();
            String productVersion = dbMetaData.getDatabaseProductVersion();
            LOGGER.info("Derby: Using " + productName + " " + productVersion);
        }
        catch (SQLException ex) {
            LOGGER.warn("Derby: Problems determing product name and version! because of [" + ex.getMessage() + "]");
        }
    }

    private void disconnect() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
            this.connection = null;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * Loose catch block
     */
    public boolean doesTableExist(String tableNameToSearch) {
        boolean bl;
        Throwable throwable;
        ResultSet resultSet;
        Throwable throwable2;
        Statement statement;
        block29: {
            block30: {
                block27: {
                    block28: {
                        statement = this.connection.createStatement();
                        throwable2 = null;
                        resultSet = statement.executeQuery("SELECT tablename FROM sys.systables where tablename = '" + tableNameToSearch.toUpperCase() + "'");
                        throwable = null;
                        bl = resultSet.next();
                        if (resultSet == null) break block27;
                        if (throwable == null) break block28;
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block27;
                    }
                    resultSet.close();
                }
                if (statement == null) break block29;
                if (throwable2 == null) break block30;
                try {
                    statement.close();
                }
                catch (Throwable throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                break block29;
            }
            statement.close();
        }
        return bl;
        {
            catch (Throwable throwable5) {
                try {
                    try {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (resultSet != null) {
                                    if (throwable != null) {
                                        try {
                                            resultSet.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        resultSet.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable2 = throwable8;
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (statement != null) {
                            if (throwable2 != null) {
                                try {
                                    statement.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable2.addSuppressed(throwable10);
                                }
                            } else {
                                statement.close();
                            }
                        }
                        throw throwable9;
                    }
                }
                catch (SQLException ex) {
                    LOGGER.warn("Problems checking existence of table: " + tableNameToSearch + " because of [" + ex.getMessage() + "]");
                }
                catch (Throwable ex) {
                    LOGGER.warn((Object)ex, ex);
                }
            }
        }
        throw new RuntimeException("Cannot check for table existence.");
    }

    /*
     * Exception decompiling
     */
    public boolean doesIndexExist(String indexNameToSearch) throws SeeTecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int ensureTableVersion() {
        String query;
        int errorCode;
        if (!this.doesTableExist(this.tnTableVersion) && (errorCode = this.executeSqlUpdate(query = "CREATE TABLE " + this.tnTableVersion + " (Timestamp BIGINT NOT NULL, TableName VARCHAR(256) NOT NULL, Version VARCHAR(256) NOT NULL)")) != 0) {
            LOGGER.error("Cannot create table <" + this.tnTableVersion + "> because of [" + errorCode + "]");
            return errorCode;
        }
        return 0;
    }

    private int ensureProblemTable() {
        String query;
        int errorCode;
        if (!this.doesTableExist(this.tnTableProblem) && (errorCode = this.executeSqlUpdate(query = "CREATE TABLE " + this.tnTableProblem + " (SourceId BIGINT NOT NULL, EventType BIGINT NOT NULL, Timestamp BIGINT NOT NULL, ErrorCode INTEGER NOT NULL, PRIMARY KEY (SourceId, EventType))")) != 0) {
            LOGGER.error("Cannot create table <" + this.tnTableProblem + "> because of [" + errorCode + "]");
            return errorCode;
        }
        return 0;
    }

    public int executeSqlUpdate(String query) {
        try (Statement statement = this.connection.createStatement();){
            statement.executeUpdate(query);
        }
        catch (SQLException ex) {
            LOGGER.warn("Problems executing sql statement: " + query + " because of [" + ex.getMessage() + "]");
            return -21600;
        }
        catch (Throwable ex) {
            LOGGER.warn("Problems while creating statement or executing update : " + ex.getMessage());
            return -21600;
        }
        return 0;
    }

    public final int setMarker(DataObjectEdgeStorageMarker dataObjectEdgeStorageMarker) {
        if (!this.bDatabaseReady) {
            LOGGER.error("SQLDatabase not ready");
            return -21630;
        }
        return dataObjectEdgeStorageMarker.updateEntry(this);
    }

    public DataObjectEdgeStorageMarker getMarker(long entityId) {
        if (!this.bDatabaseReady) {
            LOGGER.error("SQLDatabase not ready");
            return null;
        }
        return DataObjectEdgeStorageMarker.getMarker(this, LOGGER, entityId);
    }

    public int dropTable(String tableName) {
        LOGGER.info("Droping table [" + tableName + "] ...");
        return this.executeSqlUpdate("DROP TABLE " + tableName);
    }

    public void updateTableVersion(String tableName, String tableVersion) {
        LOGGER.info("Updating table [" + tableName + "] with version [" + tableVersion + " ...");
        this.executeSqlUpdate("DELETE FROM " + this.tnTableVersion + " WHERE tablename='" + tableName + "'");
        this.executeSqlUpdate("INSERT INTO " + this.tnTableVersion + " ( Timestamp, TableName, Version ) VALUES ( " + System.currentTimeMillis() + ", '" + tableName + "', '" + tableVersion + "' )");
    }

    public void saveOpenProblem(OpenProblemWrapper input) throws SeeTecException {
        this.saveLock.lock();
        try {
            if (this.getOpenProblem(input.getSourceId(), input.getEventType()) == null && this.executeSqlUpdate("INSERT INTO " + this.tnTableProblem + " ( SourceId, EventType, Timestamp, ErrorCode) VALUES ( " + input.getSourceId() + ", " + input.getEventType().getType() + ", " + input.getTimestamp() + ", " + input.getErrorCode() + " )") == -21600) {
                throw new SeeTecException(-21600, "Error persisting open problem: " + input);
            }
        }
        finally {
            this.saveLock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    public List<OpenProblemWrapper> getOpenProblem(long sourceId) throws SeeTecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public OpenProblemWrapper getOpenProblem(long sourceId, EventType eventType) throws SeeTecException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void deleteOpenProblem(long sourceId) throws SeeTecException {
        if (this.executeSqlUpdate("DELETE FROM " + this.tnTableProblem + " WHERE SourceId=" + sourceId) == -21600) {
            throw new SeeTecException(-21600, "Error removing open problem: " + sourceId);
        }
    }

    public void deleteOpenProblem(long sourceId, EventType eventType) throws SeeTecException {
        if (this.executeSqlUpdate("DELETE FROM " + this.tnTableProblem + " WHERE SourceId=" + sourceId + " AND EventType=" + eventType.getType()) == -21600) {
            throw new SeeTecException(-21600, "Error removing open problem: " + sourceId);
        }
    }

    public void clean() throws SeeTecException {
        if (this.executeSqlUpdate("DELETE FROM " + this.tnTableProblem) == -21600) {
            throw new SeeTecException(-21600, "Error removing open problems");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getSize() throws SeeTecException {
        try (Statement statement = this.connection.createStatement();){
            Throwable throwable;
            ResultSet resultSet;
            block25: {
                int n;
                block26: {
                    resultSet = statement.executeQuery("SELECT count(*) FROM " + this.tnTableProblem);
                    throwable = null;
                    if (!resultSet.next()) break block25;
                    n = resultSet.getInt(1);
                    if (resultSet == null) return n;
                    if (throwable == null) break block26;
                    try {
                        resultSet.close();
                        return n;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return n;
                    }
                }
                resultSet.close();
                return n;
            }
            try {
                try {
                    throw new SeeTecException(-20001, "Problems counting entries");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable throwable4) {
                if (resultSet == null) throw throwable4;
                if (throwable == null) {
                    resultSet.close();
                    throw throwable4;
                }
                try {
                    resultSet.close();
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throwable.addSuppressed(throwable5);
                    throw throwable4;
                }
            }
        }
        catch (SQLException ex) {
            throw new SeeTecException(ex.getErrorCode(), "Problems counting entries");
        }
    }

    /*
     * Exception decompiling
     */
    public String getTableVersion(String tablename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "[SQLDatabaseHandler:  DatabaseReady=[" + this.bDatabaseReady + "], DB URL=[" + this.url + "]]";
    }
}

