/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.recording;

import de.seetec.v5.re.cm.shared.recording.RecordingInfo;
import de.seetec.v5.re.shared.timerange.TimeRangeInfo;
import de.seetec.v5.re.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.shared.timerange.TimeRangeList;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecordingInfoList
extends ArrayList<RecordingInfo>
implements Serializable {
    public static final long serialVersionUID = 4120249368594340785L;
    private final transient Logger logger;
    private int countFailoverData;
    private int countDefaultData;
    private Long absoluteStartTimestamp = 0L;

    public RecordingInfoList() {
        this.countDefaultData = 0;
        this.countFailoverData = 0;
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public RecordingInfoList(LinkedList<RecordingInfo> recordingInfoList) {
        super(recordingInfoList);
        this.countDefaultData = 0;
        this.countFailoverData = 0;
        for (RecordingInfo recordingInfo : recordingInfoList) {
            if (recordingInfo.isFailover()) {
                ++this.countFailoverData;
                continue;
            }
            ++this.countDefaultData;
        }
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public RecordingInfoList(RecordingInfoList recordingInfoList) {
        for (RecordingInfo recordingInfo : recordingInfoList) {
            this.add(recordingInfo);
        }
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    @Override
    public boolean add(RecordingInfo t) {
        if (t.isFailover()) {
            ++this.countFailoverData;
        } else {
            ++this.countDefaultData;
        }
        return super.add(t);
    }

    @Override
    public void add(int index, RecordingInfo t) {
        if (t.isFailover()) {
            ++this.countFailoverData;
        } else {
            ++this.countDefaultData;
        }
        super.add(index, t);
    }

    @Override
    public boolean addAll(Collection<? extends RecordingInfo> list) {
        for (RecordingInfo recordingInfo : list) {
            if (recordingInfo.isFailover()) {
                ++this.countFailoverData;
                continue;
            }
            ++this.countDefaultData;
        }
        return super.addAll(list);
    }

    @Override
    public boolean addAll(int index, Collection<? extends RecordingInfo> list) {
        for (RecordingInfo recordingInfo : list) {
            if (recordingInfo.isFailover()) {
                ++this.countFailoverData;
                continue;
            }
            ++this.countDefaultData;
        }
        return super.addAll(index, list);
    }

    @Override
    public RecordingInfo remove(int index) {
        if (((RecordingInfo)this.get(index)).isFailover()) {
            --this.countFailoverData;
        } else {
            --this.countDefaultData;
        }
        return (RecordingInfo)super.remove(index);
    }

    public void setAbsoluteStartTimestamp(Long absoluteStartTimestamp) {
        this.absoluteStartTimestamp = absoluteStartTimestamp;
    }

    public Long getAbsoluteStartTimestamp() {
        return this.absoluteStartTimestamp;
    }

    public boolean containsFailoverData() {
        return this.countFailoverData > 0;
    }

    public boolean containsDefaultData() {
        return this.countDefaultData > 0;
    }

    public int getNumberOfDefaultElements() {
        return this.countDefaultData;
    }

    public int getNumberOfFailoverElements() {
        return this.countFailoverData;
    }

    public void mergeRecordingInfo(RecordingInfoList failoverList) throws SeeTecException {
        if (failoverList == null || failoverList.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.addAll(failoverList);
            return;
        }
        if (this.containsFailoverData() && this.containsDefaultData()) {
            this.logger.info("The list contains both default and failover data");
        }
        List<RecordingInfo> mergedList = this.getMergedDefaultAndFailoverRecordingInfo(this, failoverList);
        this.clear();
        this.addAll((Collection<? extends RecordingInfo>)mergedList);
        Collections.sort(this);
    }

    public void cleanAndMerge(long cumulationDistance) throws SeeTecException {
        long cumulationDistanceAdjusted = cumulationDistance <= 0L ? 5000L : cumulationDistance;
        Collections.sort(this);
        int pointer = 0;
        while (pointer < this.size() - 1) {
            long newLength;
            RecordingInfo currentRecordingInfo = (RecordingInfo)this.get(pointer);
            RecordingInfo nextRecordingInfo = (RecordingInfo)this.get(pointer + 1);
            if (currentRecordingInfo.getTrack() == nextRecordingInfo.getTrack() && currentRecordingInfo.getStartTimestamp() + (long)currentRecordingInfo.getLength() + cumulationDistanceAdjusted >= nextRecordingInfo.getStartTimestamp() && RecordingInfo.isValidLength(newLength = nextRecordingInfo.getStartTimestamp() + (long)nextRecordingInfo.getLength() - currentRecordingInfo.getStartTimestamp())) {
                currentRecordingInfo.setLength((int)newLength);
                this.remove(pointer + 1);
                continue;
            }
            ++pointer;
        }
    }

    public TimeRangeInfoContainer convertToTimeRangeInfoContainer() {
        TimeRangeList tempTimeRangeList = new TimeRangeList();
        for (RecordingInfo recordingInfo : this) {
            tempTimeRangeList.add(new TimeRangeInfo(recordingInfo.getStartTimestamp(), recordingInfo.getLength(), recordingInfo.getTrack(), recordingInfo.isFailover()));
        }
        tempTimeRangeList.setStartTimestamp(this.absoluteStartTimestamp);
        return new TimeRangeInfoContainer(tempTimeRangeList);
    }

    @Override
    public void clear() {
        this.countDefaultData = 0;
        this.countFailoverData = 0;
        this.absoluteStartTimestamp = 0L;
        super.clear();
    }

    public static void adjustAbsoluteStartTimeStamp(RecordingInfoList recordingInfoList, RecordingInfoList recordingInfoListFailover) throws SeeTecException {
        long startTimestampFailover;
        long startTimestamp = recordingInfoList.getAbsoluteStartTimestamp();
        long timeDifference = startTimestamp - (startTimestampFailover = recordingInfoListFailover.getAbsoluteStartTimestamp().longValue());
        if (timeDifference < 0L) {
            for (RecordingInfo recordingInfo : recordingInfoListFailover) {
                recordingInfo.setStartTimestamp(recordingInfo.getStartTimestamp() - timeDifference);
                recordingInfo.setEndTimestamp(recordingInfo.getEndTimestamp() - timeDifference);
            }
            recordingInfoListFailover.setAbsoluteStartTimestamp(startTimestamp);
        } else if (timeDifference > 0L) {
            for (RecordingInfo recordingInfo : recordingInfoList) {
                recordingInfo.setStartTimestamp(recordingInfo.getStartTimestamp() + timeDifference);
                recordingInfo.setEndTimestamp(recordingInfo.getEndTimestamp() + timeDifference);
            }
            recordingInfoList.setAbsoluteStartTimestamp(startTimestampFailover);
        }
    }

    private List<RecordingInfo> getMergedDefaultAndFailoverRecordingInfo(RecordingInfoList defaultList, RecordingInfoList failoverList) {
        ArrayList<RecordingInfo> result = new ArrayList<RecordingInfo>();
        List<Object> merged = new ArrayList<RecordingInfo>();
        merged.addAll(defaultList);
        merged.addAll(failoverList);
        merged = merged.parallelStream().distinct().sorted().collect(Collectors.toList());
        if (merged.size() == 1) {
            result.addAll(merged);
            return result;
        }
        boolean keepCurrent = false;
        RecordingInfo current = (RecordingInfo)merged.get(0);
        for (int mergeIndex = 0; mergeIndex < merged.size() - 1; ++mergeIndex) {
            boolean nextIsLast;
            int currentIndex = mergeIndex;
            int nextIndex = mergeIndex + 1;
            boolean bl = nextIsLast = nextIndex + 1 == merged.size();
            if (!keepCurrent) {
                current = (RecordingInfo)merged.get(currentIndex);
            }
            RecordingInfo next = (RecordingInfo)merged.get(nextIndex);
            keepCurrent = false;
            if (current.isSameTimeRange(next)) {
                keepCurrent = this.handleSameTimeRange(current, next, nextIsLast, result);
                continue;
            }
            if (current.isInside(next)) {
                keepCurrent = this.handleInside(current, next, nextIsLast, result);
                continue;
            }
            if (current.isEndOverlapping(next)) {
                this.handleOverlapping(next, current, nextIsLast, result);
                continue;
            }
            result.add(current);
            if (!nextIsLast) continue;
            result.add(next);
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    private void handleOverlapping(RecordingInfo next, RecordingInfo current, boolean nextIsLast, List<RecordingInfo> result) {
        if (next.getTrack() == 0) {
            current.setEndTimestamp(next.getStartTimestamp());
        } else if (current.getTrack() == 0) {
            next.setStartTimestamp(current.getEndTimestamp());
        } else if (current.isFailover()) {
            current.setEndTimestamp(next.getStartTimestamp());
        } else if (next.isFailover()) {
            next.setStartTimestamp(current.getEndTimestamp());
        } else {
            current.setEndTimestamp(next.getStartTimestamp());
        }
        if (current.getLength() > 0) {
            result.add(current);
        }
        if (nextIsLast) {
            result.add(next);
        }
    }

    private boolean handleInside(RecordingInfo current, RecordingInfo next, boolean nextIsLast, List<RecordingInfo> result) {
        boolean currentAdded = false;
        if (current.getTrack() == next.getTrack()) {
            if (current.isFailover()) {
                if (next.isFailover()) {
                    result.add(current);
                    currentAdded = true;
                } else {
                    RecordingInfo temp = new RecordingInfo(next.getEndTimestamp(), current.getEndTimestamp(), current.getTrack(), current.isFailover());
                    current.setEndTimestamp(next.getStartTimestamp());
                    result.add(temp);
                    if (current != temp) {
                        result.add(current);
                    }
                    if (nextIsLast) {
                        result.add(next);
                    }
                }
            } else {
                result.add(current);
                currentAdded = true;
            }
        } else if (current.getTrack() == 0) {
            result.add(current);
            currentAdded = true;
        } else {
            RecordingInfo temp = new RecordingInfo(next.getEndTimestamp(), current.getEndTimestamp(), current.getTrack(), current.isFailover());
            current.setEndTimestamp(next.getStartTimestamp());
            result.add(temp);
            if (current != temp) {
                result.add(current);
            }
            if (nextIsLast) {
                result.add(next);
            }
        }
        return currentAdded;
    }

    private boolean handleSameTimeRange(RecordingInfo current, RecordingInfo next, boolean nextIsLast, List<RecordingInfo> result) {
        boolean currentAdded = false;
        if (current.getTrack() == next.getTrack()) {
            if (current.isFailover()) {
                if (nextIsLast) {
                    result.add(next);
                }
            } else {
                result.add(current);
                currentAdded = true;
            }
        } else if (current.getTrack() == 0) {
            result.add(current);
            currentAdded = true;
        } else if (nextIsLast) {
            result.add(next);
        }
        return currentAdded;
    }
}

