/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods;

import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class RspTranscodeFrames {
    public static final String METHOD_NAME = Methods.RE_SRPC_TRANSCODING_TRANSCODE_FRAMES.methodName();
    private Integer errorCode = Integer.MIN_VALUE;
    private ContentFrame[] contentFrames = null;

    private RspTranscodeFrames(Integer errorCode, ContentFrame[] contentFrames) {
        this.errorCode = errorCode;
        this.contentFrames = contentFrames;
    }

    public GObject createGObject() {
        GObject goResponse = GObject.createList();
        goResponse.addChild(this.errorCode);
        GObject frames = GObject.createList();
        for (ContentFrame contentFrame : this.contentFrames) {
            GObject frame = GObject.createList();
            frame.addChild(Integer.valueOf(contentFrame.getMediatype()));
            frame.addChild(Integer.valueOf(contentFrame.getAttributes()));
            frame.addChild(Long.valueOf(contentFrame.getStartTimestamp()));
            frame.addChild(Long.valueOf(contentFrame.getEndTimestamp()));
            frame.addChild(contentFrame.getData());
            frames.addChild(frame);
        }
        goResponse.addChild(frames);
        return goResponse;
    }

    public static RspTranscodeFrames parseGObject(GObject goResponse) {
        ArrayList<ContentFrame> contentFrames = new ArrayList<ContentFrame>();
        Integer errorCode = goResponse.getChildAt(0).getAsInt();
        List frames = goResponse.getChildAt(1).getChildren();
        for (GObject frame : frames) {
            List frameElements = frame.getChildren();
            Integer mediatype = ((GObject)frameElements.get(0)).getAsInt();
            Integer attributes = ((GObject)frameElements.get(1)).getAsInt();
            Long start = ((GObject)frameElements.get(2)).getAsLong();
            Long end = ((GObject)frameElements.get(3)).getAsLong();
            byte[] data = ((GObject)frameElements.get(4)).getAsArrayOfByte();
            ContentFrame contentFrame = new ContentFrame(mediatype.intValue(), attributes.intValue(), start.longValue(), end.longValue(), data);
            contentFrames.add(contentFrame);
        }
        return new RspTranscodeFrames(errorCode, contentFrames.toArray(new ContentFrame[contentFrames.size()]));
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public ContentFrame[] getContentFrames() {
        return this.contentFrames;
    }

    public String toString() {
        return "[" + METHOD_NAME + ", ErrorCode=[" + this.errorCode + "], ContentFrames=[" + Arrays.toString(this.contentFrames) + "]]";
    }
}

