/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication.transcoding.srpc;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.configuration.transcoding.CMsToUse;
import de.seetec.v5.re.cm.configuration.transcoding.RuntimeTranscondingGateway;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.TranscodingProxy;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.TranscodingStreamParameter;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.proxy.ent.Location;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.SAXException;

public final class TranscodingProxyManager {
    private Logger logger = null;
    private Core core = null;
    private long myDmId = Long.MIN_VALUE;
    private List<Location> transcodingEngineLocations = new ArrayList<Location>();
    private TranscodingProxy transcodingProxy = null;
    private TranscodingStreamParameter transcodingStreamParameter = null;
    private Long lastSentRequestToTE = 0L;
    private boolean setStreamParameter = true;
    private static final long TIMEOUT_TRANSCODINGENGINE = 25000L;

    public TranscodingProxyManager() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init(Core core) {
        if (core == null) {
            return -20002;
        }
        this.core = core;
        try {
            this.myDmId = this.core.getRECnfMgr().getEntityID();
        }
        catch (ConfigurationException ex) {
            return -21002;
        }
        return 0;
    }

    public int shutdown() {
        if (this.transcodingProxy != null) {
            this.transcodingProxy.shutdown();
            this.transcodingProxy = null;
        }
        if (this.transcodingEngineLocations != null) {
            this.transcodingEngineLocations.clear();
            this.transcodingEngineLocations = null;
        }
        return 0;
    }

    private TranscodingProxy getTranscodingProxy() throws SeeTecException {
        if (this.transcodingProxy != null && this.transcodingProxy.getTranscodingChannelID() != -1L) {
            if (this.checkTranscodingEngineTimeout()) {
                return this.provideTranscodingProxy(true, true);
            }
            return this.transcodingProxy;
        }
        this.lastSentRequestToTE = System.currentTimeMillis();
        return this.provideTranscodingProxy(true, true);
    }

    private TranscodingProxy provideTranscodingProxy(boolean searchForEngines, boolean searchForChannel) throws SeeTecException {
        if (!searchForEngines && !searchForChannel && this.transcodingProxy != null && this.transcodingProxy.isReady()) {
            this.logger.info("Using initialized transcoding proxy [" + (Object)((Object)this.transcodingProxy) + "]");
            return this.transcodingProxy;
        }
        if (searchForEngines || this.transcodingEngineLocations == null || this.transcodingEngineLocations.isEmpty()) {
            this.getTranscodingEngines();
        }
        if (searchForChannel) {
            this.getTranscodingChannel();
        }
        if (this.transcodingProxy != null && this.transcodingProxy.getTranscodingChannelID() != -1L) {
            this.logger.info("Using initialized transcoding proxy [" + (Object)((Object)this.transcodingProxy) + "]");
            return this.transcodingProxy;
        }
        this.shutdownTranscodingProxy();
        throw new SeeTecException(-39101, "Could not aquire a new transcoding engine or channel");
    }

    private void getTranscodingEngines() throws SeeTecException {
        this.transcodingEngineLocations.clear();
        ArrayList<Long> transcodingEngineID = new ArrayList<Long>();
        transcodingEngineID.add(109L);
        Entity[] transcodingEngineEntities = this.core.getEntMgrProxy().getEntitiesAsList(transcodingEngineID, Boolean.valueOf(true), 30000L);
        if (transcodingEngineEntities != null && transcodingEngineEntities.length > 0) {
            String localHostAddress = Basic.getLocalHostAddress();
            String localHostName = Basic.getLocalHostName();
            for (Entity entity : transcodingEngineEntities) {
                try {
                    RuntimeTranscondingGateway transcodingGateway = (RuntimeTranscondingGateway)Basic.unmarshalXML(RuntimeTranscondingGateway.class, (Object)new String(entity.getConfiguration()).trim(), (boolean)false);
                    CMsToUse cMsToUse = transcodingGateway.getCMsToUse();
                    List<Long> transcodingGatewayID = cMsToUse.getLong();
                    if (!transcodingGatewayID.contains(this.myDmId)) continue;
                    Location location = this.core.getEntityLocationCache().get(entity.getEntityID());
                    if (localHostAddress != null && localHostAddress.equals(location.getHost()) || localHostName != null && localHostName.equals(location.getHost())) {
                        this.logger.info("Localhost match [DM:" + localHostAddress + "/" + localHostName + " TS:" + location.getHost() + "] ... adding engine to the top of the list");
                        this.transcodingEngineLocations.add(0, location);
                        continue;
                    }
                    this.logger.info("No match TS:" + location.getHost() + "]");
                    this.transcodingEngineLocations.add(location);
                }
                catch (SAXException ex) {
                    this.logger.error(ex.getMessage() + " for " + this);
                }
                catch (SeeTecException | JAXBException ex) {
                    this.logger.error(ex.getMessage() + " for " + this);
                }
            }
        }
    }

    private boolean getTranscodingChannel() throws SeeTecException {
        for (Location transcodingEngineLocation : this.transcodingEngineLocations) {
            String host = transcodingEngineLocation.getHost();
            int port = transcodingEngineLocation.getPort();
            long transcodingEngineID = transcodingEngineLocation.getID();
            this.logger.info("Found Transcoding Engine ID :[" + transcodingEngineID + "] Host :[" + host + "] Port :[" + port + "]");
            TranscodingProxy newTranscodingProxy = new TranscodingProxy();
            int errorCode = newTranscodingProxy.init(host, port, transcodingEngineID, 30000L);
            if (errorCode != 0) continue;
            try {
                this.transcodingProxy = newTranscodingProxy;
                this.transcodingProxy.allocateTranscodingChannel(this.myDmId);
                return true;
            }
            catch (SeeTecException seeTecException) {
            }
        }
        this.shutdownTranscodingProxy();
        throw new SeeTecException(-39101, "No transcoding channel available");
    }

    private void requestSetTranscodingStreamParameter(TranscodingStreamParameter transcodingStreamParameter) throws SeeTecException {
        try {
            this.transcodingProxy = this.getTranscodingProxy();
            if (this.setStreamParameter) {
                this.transcodingProxy.setTranscodingStreamParameter(transcodingStreamParameter);
                this.setStreamParameter = false;
            }
        }
        catch (SeeTecException ex) {
            this.shutdownTranscodingProxy();
            throw new SeeTecException(ex.getErrorCode(), ex.getMessage());
        }
    }

    public void setTranscodingStreamParameter(TranscodingStreamParameter transcodingStreamParameter) {
        if (this.transcodingStreamParameter == null || !this.transcodingStreamParameter.equals(transcodingStreamParameter)) {
            this.transcodingStreamParameter = transcodingStreamParameter;
            this.setStreamParameter = true;
        }
    }

    public ContentFrame transcodeFrame(ContentFrame contentFrame) throws SeeTecException {
        this.requestSetTranscodingStreamParameter(this.transcodingStreamParameter);
        try {
            return this.getTranscodingProxy().transcodeFrame(contentFrame);
        }
        catch (SeeTecException ex) {
            this.logger.error("Transcoding error [" + ex.getMessage() + "] for " + (Object)((Object)this.transcodingProxy));
            this.shutdownTranscodingProxy();
            throw new SeeTecException(ex.getErrorCode(), ex.getMessage());
        }
    }

    public ContentFrame[] transcodeFrames(ContentFrame[] contentFrames) throws SeeTecException {
        this.requestSetTranscodingStreamParameter(this.transcodingStreamParameter);
        try {
            return this.getTranscodingProxy().transcodeFrames(contentFrames);
        }
        catch (SeeTecException ex) {
            this.logger.error("Transcoding error [" + ex.getMessage() + "] for " + (Object)((Object)this.transcodingProxy));
            this.shutdownTranscodingProxy();
            throw new SeeTecException(ex.getErrorCode(), ex.getMessage());
        }
    }

    private int shutdownTranscodingProxy() {
        int errorCode = 0;
        if (this.transcodingProxy != null) {
            this.logger.info("Shutting down " + (Object)((Object)this.transcodingProxy));
            errorCode = this.transcodingProxy.shutdown();
            this.transcodingProxy = null;
        }
        return errorCode;
    }

    private synchronized boolean checkTranscodingEngineTimeout() {
        boolean timeoutResult = false;
        if (System.currentTimeMillis() - this.lastSentRequestToTE >= 25000L) {
            this.logger.info("Resetting transcoding engine " + this);
            timeoutResult = true;
            this.setStreamParameter = true;
        }
        this.lastSentRequestToTE = System.currentTimeMillis();
        return timeoutResult;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString());
        if (this.transcodingProxy != null) {
            result.append(" [TranscodingProxy: ").append((Object)this.transcodingProxy).append("]");
        } else {
            result.append(" [TranscodingProxy is null]");
        }
        return result.toString();
    }
}

