/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication.transcoding.srpc;

import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.TranscodingSrpcProxy;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspAllocateTranscodingChannel;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspCloseTranscodingChannel;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspSetTranscodingStreamParameter;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.RspTranscodeFrames;
import de.seetec.v5.re.cm.shared.communication.transcoding.srpc.methods.TranscodingStreamParameter;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.ProxyDefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.util.SeeTecException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TranscodingProxy
extends Basic {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.transcoding.srpc.TranscodingProxy";
    private TranscodingSrpcProxy srpcProxy = null;
    private long transcodingChannelId = -1L;
    private final Logger logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());

    public int init(String host, int port, long id, long timeout) {
        if (host == null || host.trim().length() <= 0 || port < 0 || port > 65535) {
            this.logger.error("Network parameter [" + host + ":" + port + "] not valid!");
            return -20002;
        }
        this.srpcProxy = new TranscodingSrpcProxy();
        int errorCode = this.srpcProxy.init((SrpcRequestHandlerFactoryIntf)new ProxyDefaultRequestHandlerFactoryImpl(), host, port, id);
        if (errorCode != 0) {
            this.logger.error("Creating [SRPCProxy] at [" + host + ":" + port + "] failed with error [" + errorCode + "]");
        }
        return errorCode;
    }

    private boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.transcodingChannelId != -1L) {
            try {
                this.closeTranscodingChannel();
            }
            catch (SeeTecException seeTecException) {
                this.logger.info("Error closing Transcoding Channel before shutdown [" + seeTecException.getMessage() + "] for " + (Object)((Object)this));
            }
        }
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.srpcProxy != null) {
            int errorCode = this.srpcProxy.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + this.srpcProxy + "] failed with error [" + errorCode + "]");
            }
            this.srpcProxy = null;
        }
        return 0;
    }

    public boolean isReady() {
        if (this.isShutdown()) {
            return false;
        }
        return this.srpcProxy.isReady();
    }

    public String toString() {
        String returnValue = ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + returnValue.substring(returnValue.lastIndexOf(46) + 1) + ", srpcProxy=" + this.srpcProxy + "], channel=" + this.transcodingChannelId;
    }

    public void allocateTranscodingChannel(long dmId) throws SeeTecException {
        RspAllocateTranscodingChannel rspAllocateTranscodingChannel = this.srpcProxy.AllocateTranscodingChannel(dmId);
        if (rspAllocateTranscodingChannel.getErrorCode() != 0) {
            throw new SeeTecException(rspAllocateTranscodingChannel.getErrorCode().intValue(), "Error while allocating transcoding channel for " + (Object)((Object)this));
        }
        this.transcodingChannelId = rspAllocateTranscodingChannel.getChannelId();
    }

    public void setTranscodingStreamParameter(TranscodingStreamParameter transcodingStreamParameter) throws SeeTecException {
        RspSetTranscodingStreamParameter rspSetTranscodingStreamParameter = this.srpcProxy.SetTranscodingStreamParameter(this.transcodingChannelId, transcodingStreamParameter.videoSourceId, transcodingStreamParameter.framerate, transcodingStreamParameter.videoWidth, transcodingStreamParameter.quality, transcodingStreamParameter.mediaCodec, transcodingStreamParameter.maxBandwidth);
        if (rspSetTranscodingStreamParameter.getErrorCode() != 0) {
            throw new SeeTecException(rspSetTranscodingStreamParameter.getErrorCode().intValue(), "Error while setting transcoding parameters for " + (Object)((Object)this));
        }
    }

    public ContentFrame transcodeFrame(ContentFrame contentFrame) throws SeeTecException {
        ContentFrame[] contentFrames = new ContentFrame[]{contentFrame};
        RspTranscodeFrames rspTranscodeFrames = this.srpcProxy.TranscodeFrames(this.transcodingChannelId, contentFrames);
        if (rspTranscodeFrames.getErrorCode() != 0) {
            throw new SeeTecException(rspTranscodeFrames.getErrorCode().intValue(), "Error while transcoding frame for " + (Object)((Object)this));
        }
        if (rspTranscodeFrames.getContentFrames().length > 0) {
            return rspTranscodeFrames.getContentFrames()[0];
        }
        return null;
    }

    public ContentFrame[] transcodeFrames(ContentFrame[] contentFrames) throws SeeTecException {
        RspTranscodeFrames rspTranscodeFrames = this.srpcProxy.TranscodeFrames(this.transcodingChannelId, contentFrames);
        if (rspTranscodeFrames.getErrorCode() != 0) {
            throw new SeeTecException(rspTranscodeFrames.getErrorCode().intValue(), "Error while transcoding frames for " + (Object)((Object)this));
        }
        return rspTranscodeFrames.getContentFrames();
    }

    public void closeTranscodingChannel() throws SeeTecException {
        try {
            RspCloseTranscodingChannel rspCloseTranscodingChannel = this.srpcProxy.CloseTranscodingChannel(this.transcodingChannelId);
            if (rspCloseTranscodingChannel.getErrorCode() != 0) {
                throw new SeeTecException(rspCloseTranscodingChannel.getErrorCode().intValue(), "Error while closing transcoding channel for " + (Object)((Object)this));
            }
        }
        catch (SeeTecException seeTecException) {
            throw new SeeTecException(seeTecException.getErrorCode(), seeTecException.getMessage());
        }
        catch (Exception exception) {
            throw new SeeTecException(-21600, exception.getMessage());
        }
        finally {
            this.transcodingChannelId = -1L;
        }
    }

    public long getTranscodingChannelID() {
        return this.transcodingChannelId;
    }
}

