/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.shared.communication.RecordingEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class RecordingEventHandler {
    private final long reTryInterval;
    private long nextRestartTime = -1L;
    private final ConcurrentHashMap<Long, RecordingEvent> recordingEvents = new ConcurrentHashMap();

    public RecordingEventHandler() {
        this.reTryInterval = TimeUnit.SECONDS.toMillis(3L);
    }

    protected RecordingEventHandler(long reTryInterval) {
        this.reTryInterval = reTryInterval;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_OF_PUTIFABSENT_IGNORED"}, justification="Return value of putIfAbsent(k, v) is not relevant for computeIfPresent(...)")
    public RecordingEvent putNewRecordingEvent(long key, RecordingEvent recordingEventToStore) {
        RecordingEvent recordingEvent = null;
        if (recordingEventToStore != null) {
            this.recordingEvents.putIfAbsent(key, recordingEventToStore);
            recordingEvent = this.recordingEvents.computeIfPresent(key, (existingKey, existingRecordingEvent) -> existingRecordingEvent.getMaxRecording() < recordingEventToStore.getMaxRecording() ? recordingEventToStore : existingRecordingEvent);
        }
        return recordingEvent;
    }

    public RecordingEvent removeRecordingEvent(long key) {
        RecordingEvent removedRecordingEvent = this.recordingEvents.remove(key);
        return removedRecordingEvent;
    }

    public RecordingEvent getAlarmRecordingEvent() {
        RecordingEvent recordingEventToStart = null;
        long timeNow = System.currentTimeMillis();
        if (!this.recordingEvents.isEmpty() && this.nextRestartTime < timeNow) {
            this.nextRestartTime = timeNow + this.reTryInterval;
            Set notStartedAlarmInstanceIDs = this.recordingEvents.keySet();
            Iterator iterator = notStartedAlarmInstanceIDs.iterator();
            if (iterator.hasNext()) {
                Long alarmInstanceID = (Long)iterator.next();
                RecordingEvent recordingEvent = this.recordingEvents.get(alarmInstanceID);
                if (timeNow >= recordingEvent.getMaxRecording()) {
                    this.recordingEvents.remove(alarmInstanceID);
                } else {
                    recordingEventToStart = this.recordingEvents.get(alarmInstanceID);
                    return recordingEventToStart;
                }
            }
        }
        return recordingEventToStart;
    }

    public void setMaxRecording(long alarmInstanceId, long maxRecording) {
        this.recordingEvents.computeIfPresent(alarmInstanceId, (existingKey, existingRecordingEvent) -> {
            existingRecordingEvent.setMaxRecording(maxRecording);
            return existingRecordingEvent;
        });
    }

    public boolean isEmpty() {
        return this.recordingEvents.isEmpty();
    }

    public int size() {
        return this.recordingEvents.size();
    }
}

