/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.shared.communication.NetworkClientProxy;
import de.seetec.v5.shared.Basic;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class NetworkClientProxyBlockingOutputStreamWatchdog
extends Basic
implements Runnable {
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private static final String CLASS_NAME = "NetworkClientProxyBlockingOutputStreamWatchdog";
    private Thread myThread = null;
    private final NetworkClientProxy outer;

    public NetworkClientProxyBlockingOutputStreamWatchdog(NetworkClientProxy outer) {
        this.outer = outer;
    }

    public int init() {
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        this.outer.shutdown();
        return 0;
    }

    @Override
    public void run() {
        try {
            while (!this.outer.isShutdown() && !this.isShutdown()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                long duration = System.currentTimeMillis() - this.outer.getTimestampOfLastSending();
                if (duration < 0L) {
                    this.logger.info("Adjustment of system clock for [" + Basic.longToFormattedString((long)duration) + " ms]");
                    continue;
                }
                if (duration <= 60000L) continue;
                this.logger.error("Sending to client blocks for more than [" + Basic.longToFormattedString((long)duration) + " ms], so " + this.outer + " will be discarded!");
                break;
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public String toString() {
        String sThis = "NetworkClientProxyBlockingOutputStreamWatchdog@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.outer.toString() + "]";
    }
}

