/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.DeviceManagerStatistic;
import de.seetec.v5.re.cm.device.shared.ImageStreamPaket;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueue;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueueManager;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxyBandwidthStatistics;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxyBlockingOutputStreamWatchdog;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxyDeliveryStatistics;
import de.seetec.v5.re.cm.shared.communication.NetworkClientReaderPublisher;
import de.seetec.v5.re.cm.shared.communication.NetworkClientReaderPublisherTCP;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.TimeHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkClientProxy
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.NetworkClientProxy";
    public static final String PROTOCOL_UDP = "udp";
    public static final String PROTOCOL_TCP = "tcp";
    public static final int MIN_TCP_PACKET_LENGTH = 1480;
    private Logger logger = null;
    private Thread myThread = null;
    private String protocol = "udp";
    private Socket tcpSocket = null;
    private DatagramSocket udpSocket = null;
    private InetAddress iHost = null;
    private int port = -1;
    private long tsLastSending = System.currentTimeMillis();
    private NetworkClientProxyBlockingOutputStreamWatchdog watchdog = null;
    private Long clientID = null;
    private int bandwidthLimitation = -1;
    private final NetworkClientProxyDeliveryStatistics deliveryStatistics = new NetworkClientProxyDeliveryStatistics(64);
    private long lastCalculatedRatio = 100000L;
    private long sessionID;
    private final ContentTransportQueueManager ctqManager = new ContentTransportQueueManager();
    private NetworkClientProxyBandwidthStatistics bandwidthStatistics = new NetworkClientProxyBandwidthStatistics();
    private final long tsStartup = System.currentTimeMillis();
    private NetworkClientReaderPublisher networkClientReadingProxy;
    private final ConfigurationProvider configurationProvider;

    public NetworkClientProxy(ConfigurationProvider configurationProvider) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.configurationProvider = configurationProvider;
    }

    public int init(Socket tcpSocket, Long clientID) {
        this.tcpSocket = tcpSocket;
        if (this.tcpSocket == null) {
            throw new RuntimeException("Implementation error: Paramter [TcpSocket]==is null!");
        }
        try {
            this.tcpSocket.setSoTimeout(10000);
            this.tcpSocket.setTcpNoDelay(true);
            this.tcpSocket.setSendBufferSize(0x100000);
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        this.clientID = clientID;
        if (this.clientID == null) {
            throw new RuntimeException("Implementation error: Paramter [ClientID]==is null!");
        }
        this.protocol = PROTOCOL_TCP;
        this.iHost = this.tcpSocket.getInetAddress();
        this.port = this.tcpSocket.getPort();
        try {
            this.networkClientReadingProxy = new NetworkClientReaderPublisherTCP(tcpSocket.getInputStream());
            this.networkClientReadingProxy.init();
        }
        catch (Exception e) {
            throw new RuntimeException("Implementation error: Paramter [InputStream of TcpSocket]==is null!");
        }
        this.startThread();
        this.watchdog = new NetworkClientProxyBlockingOutputStreamWatchdog(this);
        this.watchdog.init();
        this.logger.info(this + " initialized");
        return 0;
    }

    public int init(DatagramSocket udpSocket, InetAddress iHost, int port, long sessionID, NetworkClientReaderPublisher networkClientReaderPublisherUDP) {
        this.udpSocket = udpSocket;
        if (this.udpSocket == null || networkClientReaderPublisherUDP == null) {
            throw new RuntimeException("Implementation error: Paramter is null");
        }
        this.iHost = iHost;
        if (this.iHost == null) {
            throw new RuntimeException("Implementation error: Paramter [Host] is [null]!");
        }
        this.port = port;
        if (this.port <= 0 || port >= 65535) {
            throw new RuntimeException("Implementation error: Paramter [Port]==[" + port + "] is invalid!");
        }
        this.sessionID = sessionID;
        if (this.sessionID < 0L) {
            throw new RuntimeException("Implementation error: Paramter [sessionID]==[" + sessionID + "] is invalid!");
        }
        this.protocol = PROTOCOL_UDP;
        this.networkClientReadingProxy = networkClientReaderPublisherUDP;
        this.startThread();
        return 0;
    }

    private void startThread() {
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.setPriority(10);
        this.myThread.start();
    }

    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.networkClientReadingProxy != null) {
            this.networkClientReadingProxy.shutdown();
        }
        if (this.tcpSocket != null) {
            try {
                this.tcpSocket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tcpSocket = null;
        }
        if (this.watchdog != null) {
            this.watchdog.shutdown();
            this.watchdog = null;
        }
        if (this.ctqManager != null) {
            this.ctqManager.shutdown();
        }
        return 0;
    }

    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long tsLastStatistics = System.currentTimeMillis();
        OutputStream os = null;
        try {
            long tsLastSent = System.currentTimeMillis();
            long tsLastBandwidthCheck = System.currentTimeMillis();
            long timeStampForQueue = System.currentTimeMillis();
            long maxIdleTime = 600000L;
            while (!this.isShutdown()) {
                ContentTransportQueue queue;
                int n;
                ContentTransportQueue[] queues = this.ctqManager.getQueues();
                if (queues.length > 0) {
                    timeStampForQueue = System.currentTimeMillis();
                } else if (System.currentTimeMillis() - timeStampForQueue > maxIdleTime) {
                    this.logger.info("Queue was idle for more than " + maxIdleTime / 1000L + " seconds, discarding...");
                    this.shutdown();
                    return;
                }
                try {
                    if (tsLastBandwidthCheck > System.currentTimeMillis()) {
                        tsLastBandwidthCheck = System.currentTimeMillis();
                    }
                    if (System.currentTimeMillis() - tsLastBandwidthCheck > 1000L) {
                        tsLastBandwidthCheck = System.currentTimeMillis();
                        long fullDatarate = 0L;
                        for (ContentTransportQueue queue2 : queues) {
                            if (queue2.isShutdown()) continue;
                            fullDatarate += queue2.getFullDatarate(5000L);
                        }
                        if (fullDatarate > 0L && (long)this.bandwidthLimitation > 0L) {
                            long ratio;
                            this.lastCalculatedRatio = ratio = (long)(this.bandwidthLimitation >> 3) * 100000L / fullDatarate;
                            ContentTransportQueue[] contentTransportQueueArray = queues;
                            int queue2 = contentTransportQueueArray.length;
                            for (n = 0; n < queue2; ++n) {
                                queue = contentTransportQueueArray[n];
                                if (queue.isShutdown()) continue;
                                queue.setDatarateRatio(ratio);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    this.logger.warn("Problems while checking bandwidth restrictions --> " + this, t);
                }
                try {
                    if (Math.abs(System.currentTimeMillis() - tsLastStatistics) > TimeUnit.MINUTES.toMillis(10L)) {
                        tsLastStatistics = System.currentTimeMillis();
                        long actualDatarate = 0L;
                        for (ContentTransportQueue queue3 : queues) {
                            if (queue3.isShutdown()) continue;
                            actualDatarate += queue3.getDatarate();
                        }
                        int counter = 0;
                        StringBuilder sb = new StringBuilder(1024);
                        sb.append("---[").append(this.iHost).append(":").append(this.port).append("], Datarate=[").append(Basic.longToFormattedString((long)(actualDatarate >> 10))).append(" KB/s] --> ").append(this);
                        ContentTransportQueue[] contentTransportQueueArray = queues;
                        int queue3 = contentTransportQueueArray.length;
                        for (n = 0; n < queue3; ++n) {
                            queue = contentTransportQueueArray[n];
                            if (queue.isShutdown()) continue;
                            sb.append("\r\n");
                            sb.append("       ");
                            sb.append(String.format("#%2d=", ++counter));
                            sb.append(queue.toString());
                        }
                        this.logger.info(sb.toString());
                    }
                }
                catch (Throwable t) {
                    this.logger.warn("Problems with cyclic statistics --> " + this, t);
                }
                if (this.protocol.equals(PROTOCOL_UDP)) {
                    int dataSent = 0;
                    for (ContentTransportQueue queue4 : queues) {
                        if (queue4.isShutdown()) continue;
                        int sent = 0;
                        for (int sentPerCam = 0; sentPerCam < 4096 && (sent = queue4.sendContentFrame(this.udpSocket)) > 0; sentPerCam += sent) {
                            dataSent += sent;
                        }
                    }
                    if (dataSent <= 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - tsLastSent < maxIdleTime) continue;
                        break;
                    }
                    this.bandwidthStatistics.notifyDataSent(dataSent);
                    tsLastSent = System.currentTimeMillis();
                    continue;
                }
                if (this.protocol.equals(PROTOCOL_TCP)) {
                    this.tsLastSending = System.currentTimeMillis();
                    try {
                        if (this.tcpSocket == null) {
                            this.logger.info("Creating tcp socket to [" + this.iHost + ":" + this.port + "] ...");
                            try {
                                this.tcpSocket = new Socket(this.iHost, this.port);
                                this.tcpSocket.setSendBufferSize(0x100000);
                                this.tcpSocket.setSoTimeout(10000);
                                this.tcpSocket.setTcpNoDelay(true);
                                os = this.tcpSocket.getOutputStream();
                            }
                            catch (IOException ioex) {
                                this.logger.error("Problems connecting to client [" + this.iHost + ":" + this.port + "]");
                                break;
                            }
                            this.logger.info("Connecting the client via " + this.tcpSocket);
                        } else if (os == null) {
                            os = this.tcpSocket.getOutputStream();
                        }
                        long nanoStart = System.nanoTime();
                        int dataSent = 0;
                        for (ContentTransportQueue queue5 : queues) {
                            int sentPerQueue;
                            if (queue5.isShutdown()) continue;
                            int sent = 0;
                            for (sentPerQueue = 0; (sent = queue5.sendContentFrame(os)) > 0 && sentPerQueue < 4096; sentPerQueue += sent) {
                            }
                            if (sentPerQueue >= 1480) {
                                os.flush();
                            }
                            dataSent += sentPerQueue;
                        }
                        if (dataSent > 0) {
                            os.flush();
                            this.bandwidthStatistics.notifyDataSent(dataSent);
                            tsLastSent = System.currentTimeMillis();
                            long transmissionTime = System.nanoTime() - nanoStart;
                            if (transmissionTime <= 80000000L) continue;
                            this.logger.info("Transmission: [" + Basic.longToFormattedString((long)dataSent) + " B], [" + Basic.longToFormattedString((long)(transmissionTime / 1000000L)) + " ms], this=" + this);
                            continue;
                        }
                        long durationOfInactivity = Math.abs(System.currentTimeMillis() - tsLastSent);
                        if (durationOfInactivity > 100L) {
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException sent) {}
                        } else if (durationOfInactivity > 10L) {
                            try {
                                Thread.sleep(durationOfInactivity >> 1);
                            }
                            catch (InterruptedException sent) {}
                        } else {
                            try {
                                Thread.sleep(5L);
                            }
                            catch (InterruptedException sent) {
                                // empty catch block
                            }
                        }
                        if (System.currentTimeMillis() - tsLastSent <= 10000L) continue;
                        ImageStreamPaket tcpStillAlivePacket = new ImageStreamPaket(-1L, -1, -1, 0, null);
                        byte[] serializedTCPStillAlivePacket = tcpStillAlivePacket.serialize();
                        os.write(serializedTCPStillAlivePacket);
                        os.flush();
                        tsLastSent = System.currentTimeMillis();
                        this.deliveryStatistics.notifyFrameSent(serializedTCPStillAlivePacket.length);
                        continue;
                    }
                    catch (SocketException socketException) {
                        this.logger.error("Terminate thread because of exception [" + socketException.getMessage() + "] --> " + this);
                        break;
                    }
                    catch (Throwable e) {
                        this.logger.error("Terminate thread because of exception [" + e.getMessage() + "] --> " + this, e);
                        break;
                    }
                }
                throw new RuntimeException("Undefined protocol [" + this.protocol + "] for " + this);
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    public Long getClientID() {
        return this.clientID;
    }

    public ContentTransportQueue determineClientRecipient(long targetSessionID) {
        ContentTransportQueue[] queues;
        for (ContentTransportQueue ctq : queues = this.ctqManager.getQueues()) {
            if (ctq.getSessionID() != targetSessionID) continue;
            return ctq;
        }
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public InetAddress getHost() {
        return this.iHost;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isAssociatedClient(InetAddress iHost, int port, long sessionID) {
        return this.getHost().hashCode() == iHost.hashCode() && this.getPort() == port && this.getSessionID() == sessionID;
    }

    public boolean isAssociatedClient(Long clientID) {
        return this.clientID != null && clientID != null && this.clientID.longValue() == clientID.longValue();
    }

    public ContentTransportQueue createContentTransportQueue(long sessionID, DeviceManagerStatistic deviceManagerStatistic) {
        ContentTransportQueue queue = new ContentTransportQueue(this.configurationProvider);
        if (queue.init(this, this.iHost, this.port, sessionID, deviceManagerStatistic) != 0) {
            throw new RuntimeException("Cannot create [ContentTransportQueue]");
        }
        queue.setDatarateRatio(this.lastCalculatedRatio);
        this.ctqManager.addContentTransportQueue(queue);
        return queue;
    }

    public void setBandwidthLimitation(int bandwidthLimitation) {
        if (this.bandwidthLimitation != bandwidthLimitation) {
            this.bandwidthLimitation = bandwidthLimitation;
            this.deliveryStatistics.resetRatioStatistics();
        }
    }

    private long getSessionID() {
        return this.sessionID;
    }

    private long getUptime() {
        return System.currentTimeMillis() - this.tsStartup;
    }

    public String getDescription(boolean extendedDetails) {
        String sThis = "de.seetec.v5.re.cm.shared.communication.NetworkClientProxy@" + Integer.toHexString(this.hashCode());
        try {
            String bandwidth = "";
            if (extendedDetails) {
                bandwidth = ", " + this.bandwidthStatistics.getDescription();
                if (this.bandwidthStatistics.getDuration() >= TimeUnit.MINUTES.toMillis(1L)) {
                    this.bandwidthStatistics = new NetworkClientProxyBandwidthStatistics();
                }
            }
            String ctqManagerInfo = "";
            if (extendedDetails && this.ctqManager != null) {
                ctqManagerInfo = ", " + this.ctqManager.toString();
            }
            String statistics = "";
            if (extendedDetails) {
                Long[] ctqStatistics;
                Long[] longArray = ctqStatistics = this.ctqManager != null ? this.ctqManager.getContentTransportQueueStatistics() : null;
                if (ctqStatistics != null) {
                    statistics = ", Min/Max/AvgQueueLength=[" + ctqStatistics[0] + " ms]/[" + ctqStatistics[1] + " ms]/[" + ctqStatistics[2] + " ms]";
                }
            }
            return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", ClientID=[" + Basic.longToFormattedString((Long)this.clientID) + "], Protocol=[" + this.protocol + "], Address=[" + this.iHost.toString() + ":" + this.port + "], Uptime=[" + TimeHelper.getReadableTimerange((long)this.getUptime()) + "]" + bandwidth + statistics + ctqManagerInfo + "]";
        }
        catch (Throwable t) {
            return sThis;
        }
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.NetworkClientProxy@" + Integer.toHexString(this.hashCode());
        try {
            return this.getDescription(false);
        }
        catch (Throwable t) {
            return sThis;
        }
    }

    public long getTimestampOfLastSending() {
        return this.tsLastSending;
    }

    public NetworkClientReaderPublisher getNetworkClientReadingProxy() {
        return this.networkClientReadingProxy;
    }
}

