/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.DeviceManagerStatistic;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueue;
import de.seetec.v5.re.cm.shared.communication.NetworkClientProxy;
import de.seetec.v5.re.cm.shared.communication.NetworkClientReaderPublisher;
import de.seetec.v5.re.cm.shared.communication.NetworkClientReaderPublisherUDP;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkClientHandler
extends Basic
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.NetworkClientHandler";
    private final Logger logger;
    private Thread myThread = null;
    private int nUDPPort = -1;
    private DatagramSocket udpSocket = null;
    private final List<NetworkClientProxy> networkClientProxies = new ArrayList<NetworkClientProxy>();
    private NetworkClientReaderPublisher networkClientReadingProxyUDP;
    private final DeviceManagerStatistic deviceManagerStatistic;
    private final ConfigurationProvider configurationProvider;

    public NetworkClientHandler(DeviceManagerStatistic deviceManagerStatistic, ConfigurationProvider configurationProvider) {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.deviceManagerStatistic = deviceManagerStatistic;
        this.configurationProvider = configurationProvider;
    }

    public int init(int nUDPPort) {
        this.nUDPPort = nUDPPort;
        if (this.nUDPPort <= 0 || nUDPPort >= 65535) {
            return -21601;
        }
        try {
            this.udpSocket = new DatagramSocket(this.nUDPPort);
            this.udpSocket.setSoTimeout(10);
            this.udpSocket.setSendBufferSize(0x100000);
            this.udpSocket.setReceiveBufferSize(65536);
            this.networkClientReadingProxyUDP = new NetworkClientReaderPublisherUDP(this.udpSocket);
            this.networkClientReadingProxyUDP.init();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            this.logger.error("Allocating udp port [" + this.nUDPPort + "] failed :-(");
            return -21600;
        }
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
        return 0;
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.networkClientReadingProxyUDP != null) {
            this.networkClientReadingProxyUDP.shutdown();
            this.networkClientReadingProxyUDP = null;
        }
        if (this.udpSocket != null) {
            try {
                this.udpSocket.close();
            }
            catch (Throwable ex) {
                this.logger.warn((Object)ex, ex);
            }
            this.udpSocket = null;
        }
        List<NetworkClientProxy> list = this.networkClientProxies;
        synchronized (list) {
            for (int i = 0; i < this.networkClientProxies.size(); ++i) {
                this.networkClientProxies.get(i).shutdown();
            }
            this.networkClientProxies.clear();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        try {
            while (!this.isShutdown()) {
                List<NetworkClientProxy> list = this.networkClientProxies;
                synchronized (list) {
                    try {
                        for (int i = this.networkClientProxies.size() - 1; i >= 0; --i) {
                            NetworkClientProxy networkClientProxy = this.networkClientProxies.get(i);
                            if (!networkClientProxy.isShutdown()) continue;
                            this.logger.info("Removing " + networkClientProxy + " because of shutdown!");
                            this.networkClientProxies.remove(i);
                        }
                    }
                    catch (Throwable t) {
                        this.logger.warn("Trouble checking list of NetworkClientProxies!", t);
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContentTransportQueue createContentTransportQueue(InetAddress host, int port, long sessionId) throws SeeTecException {
        NetworkClientProxy networkClientProxy = null;
        List<NetworkClientProxy> list = this.networkClientProxies;
        synchronized (list) {
            for (int i = 0; i < this.networkClientProxies.size(); ++i) {
                networkClientProxy = this.networkClientProxies.get(i);
                if (networkClientProxy.isShutdown() || !networkClientProxy.isAssociatedClient(host, port, sessionId)) continue;
                if (networkClientProxy.getProtocol().equals("udp")) {
                    return networkClientProxy.createContentTransportQueue(sessionId, this.deviceManagerStatistic);
                }
                this.logger.info("Discarding " + networkClientProxy + ", because the protocol changed for " + this);
                networkClientProxy.shutdown();
                break;
            }
            if ((networkClientProxy = new NetworkClientProxy(this.configurationProvider)).init(this.udpSocket, host, port, sessionId, this.networkClientReadingProxyUDP) != 0) {
                throw new SeeTecException(-21681, "Cannot create [NetworkClientProxy] with [" + host + ":" + port + "] for " + this);
            }
            this.networkClientProxies.add(networkClientProxy);
            return networkClientProxy.createContentTransportQueue(sessionId, this.deviceManagerStatistic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ContentTransportQueue createContentTransportQueue(Long clientId, long sessionId, String protocol) throws SeeTecException {
        NetworkClientProxy networkClientProxy = null;
        List<NetworkClientProxy> list = this.networkClientProxies;
        synchronized (list) {
            for (int i = 0; i < this.networkClientProxies.size(); ++i) {
                networkClientProxy = this.networkClientProxies.get(i);
                if (networkClientProxy.isShutdown() || !networkClientProxy.isAssociatedClient(clientId)) continue;
                if (networkClientProxy.getProtocol().equals(protocol.trim().toLowerCase())) {
                    return networkClientProxy.createContentTransportQueue(sessionId, this.deviceManagerStatistic);
                }
                this.logger.info("Discarding " + networkClientProxy + ", because protocol [" + protocol + "] is wanted for " + this);
                networkClientProxy.shutdown();
                break;
            }
        }
        this.logger.error("Registered [NetworkClientProxy]=" + this.networkClientProxies);
        throw new SeeTecException(-21681, "No valid [NetworkClientProxy] found for ClientID=[" + Basic.longToFormattedString((Long)clientId) + "], SessionID=[" + Basic.longToFormattedString((long)sessionId) + "], Protocol=[" + protocol + "] for " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerNetworkClientProxy(NetworkClientProxy networkClientProxy) {
        List<NetworkClientProxy> list = this.networkClientProxies;
        synchronized (list) {
            this.networkClientProxies.add(networkClientProxy);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentTransportQueue determineClientRecipient(long targetClientID, long targetSessionID) {
        List<NetworkClientProxy> list = this.networkClientProxies;
        synchronized (list) {
            for (NetworkClientProxy networkClientProxy : this.networkClientProxies) {
                if (networkClientProxy.getClientID() != targetClientID) continue;
                return networkClientProxy.determineClientRecipient(targetSessionID);
            }
        }
        return null;
    }

    public final int getNumberOfNetworkClientProxies() {
        return this.networkClientProxies != null ? this.networkClientProxies.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.NetworkClientHandler@" + Integer.toHexString(this.hashCode());
        StringBuilder sbClients = new StringBuilder(1024);
        if (this.networkClientProxies != null && this.networkClientProxies.size() > 0) {
            List<NetworkClientProxy> list = this.networkClientProxies;
            synchronized (list) {
                for (int i = 0; i < this.networkClientProxies.size(); ++i) {
                    sbClients.append("\r\n                        " + this.networkClientProxies.get(i).getDescription(true));
                }
            }
        } else {
            sbClients.append("<empty>");
        }
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", UDPPort=[" + this.nUDPPort + "]" + sbClients.toString();
    }
}

