/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxyListener;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.srpc.ReqChangeRecordingMode;
import de.seetec.v5.re.shared.srpc.ReqFinalizeLocalStorageRecording;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmInstance;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmInstances;
import de.seetec.v5.re.shared.srpc.ReqGetAlarmScenarioOccurrencies;
import de.seetec.v5.re.shared.srpc.ReqGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.ReqOpenContent;
import de.seetec.v5.re.shared.srpc.ReqReadMultipleFrames;
import de.seetec.v5.re.shared.srpc.ReqReadNextFrame;
import de.seetec.v5.re.shared.srpc.ReqReadPreviousFrame;
import de.seetec.v5.re.shared.srpc.ReqSetupLocalStorageRecording;
import de.seetec.v5.re.shared.srpc.ReqStatusContent;
import de.seetec.v5.re.shared.srpc.ReqWriteAlarmInstances;
import de.seetec.v5.re.shared.srpc.ReqWriteFrame;
import de.seetec.v5.re.shared.srpc.ReqWriteLocalStorageFrames;
import de.seetec.v5.re.shared.srpc.ReqWriteMultipleFrames;
import de.seetec.v5.re.shared.srpc.RspGetAlarmInstance;
import de.seetec.v5.re.shared.srpc.RspGetAlarmInstances;
import de.seetec.v5.re.shared.srpc.RspGetAlarmScenarioOccurrencies;
import de.seetec.v5.re.shared.srpc.RspGetCameraRecordingStatistics;
import de.seetec.v5.re.shared.srpc.RspGetRecordingInfos;
import de.seetec.v5.re.shared.srpc.RspOpenContent;
import de.seetec.v5.re.shared.srpc.RspReadMultipleFrames;
import de.seetec.v5.re.shared.srpc.RspReadNextFrame;
import de.seetec.v5.re.shared.srpc.RspReadPreviousFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.GObject;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcClientIntf;
import de.seetec.v5.shared.networking.srpc.SrpcFactory;
import de.seetec.v5.shared.networking.srpc.SrpcFuture;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.IOException;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MDSProxy
extends DatabaseProxy
implements SrpcRequestHandlerIntf,
SrpcRequestHandlerFactoryIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.shared.MDSProxy";
    private final Logger logger;
    private SrpcClientIntf srpcClient = null;
    private DatabaseProxyListener listener = null;
    private String host = null;
    private int port = -1;
    private long entityId = Long.MIN_VALUE;
    private int accessMode = 0;
    private Socket socket = null;

    public MDSProxy() {
        this.logger = LogManager.getLogger((String)((Object)((Object)this)).getClass().getName());
    }

    @Override
    public int init(DatabaseProxyListener listener, String host, int port, long entityID) {
        this.host = host;
        this.port = port;
        this.entityId = entityID;
        this.listener = listener;
        this.host = host;
        if (this.host == null) {
            return -20002;
        }
        this.port = port;
        if (this.port <= 0 || port >= 65535) {
            return -20002;
        }
        try {
            this.setupSrpc();
        }
        catch (Exception ex) {
            this.logger.error("   Cannot create socket to [" + host + ":" + port + "]. Message: " + ex.getMessage());
            return -20100;
        }
        return 0;
    }

    private void setupSrpc() throws IOException {
        this.socket = new Socket(this.host, this.port);
        if (this.srpcClient != null) {
            this.srpcClient.shutdown();
        }
        this.srpcClient = SrpcFactory.getSrpc((Socket)this.socket, (SrpcRequestHandlerFactoryIntf)this, (Long)this.entityId, null, (boolean)true);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        long duration;
        long timestamp;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.socket != null) {
            timestamp = System.currentTimeMillis();
            try {
                this.socket.close();
            }
            catch (IOException ioex) {
                this.logger.warn("Discarding socket " + this.socket + " of " + (Object)((Object)this) + " failed with [" + ioex.getMessage() + "]");
            }
            duration = System.currentTimeMillis() - timestamp;
            if (duration >= TimeUnit.SECONDS.toMillis(10L)) {
                this.logger.warn("Closing " + this.socket + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
            }
            this.socket = null;
        }
        if (this.srpcClient != null) {
            try {
                timestamp = System.currentTimeMillis();
                this.srpcClient.shutdown();
                duration = System.currentTimeMillis() - timestamp;
                if (duration >= TimeUnit.SECONDS.toMillis(10L)) {
                    this.logger.warn("Shutting down " + this.srpcClient + " lasts for [" + Basic.longToFormattedString((long)duration) + " ms]!");
                }
            }
            catch (Throwable ex) {
                this.logger.warn("Discarding " + this.srpcClient + " of " + (Object)((Object)this) + " failed");
            }
            this.srpcClient = null;
        }
        return 0;
    }

    @Override
    public final boolean isReady() {
        return !this.isShutdown() && this.srpcClient != null && this.srpcClient.isReady();
    }

    private SrpcFuture sendRequest(SrpcMessage msg) throws SeeTecException {
        Methods method;
        if (this.isShutdown()) {
            this.logger.error((Object)((Object)this) + " is already shutting down");
            throw new SeeTecException(-21017, "");
        }
        if (!this.srpcClient.isReady()) {
            try {
                this.setupSrpc();
            }
            catch (Exception ex) {
                this.logger.error((Object)ex, (Throwable)ex);
                throw new SeeTecException(-20214, ex.getMessage());
            }
        }
        if ((method = Methods.valueOf((int)msg.getHash())) == Methods.MD_REQ_WRITEFRAME || method == Methods.MD_REQ_WRITELOCALSTORAGEFRAMES || method == Methods.MD_REQ_WRITEMULTIPLEFRAMES) {
            msg.setCompression((byte)0);
            msg.setEncryption((byte)0);
        }
        return this.srpcClient.sendAsync(msg);
    }

    @Override
    public SrpcMessage sendGenericRequest(SrpcMessage req, long timeout) throws SeeTecException, InterruptedException, ExecutionException, TimeoutException {
        SrpcFuture asyncResult = this.sendRequest(req);
        if (null == asyncResult) {
            throw new SeeTecException(-20201, "Future is null!");
        }
        return asyncResult.get(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public int openContentForReading(long contentID, String contentName) {
        return this.openContent(contentID, contentName, 1);
    }

    @Override
    public int openContentForWriting(long contentID, String contentName) {
        return this.openContent(contentID, contentName, 3);
    }

    @Override
    public final int openContentForAdditionalWriting(long contentID, String contentName) {
        return this.openContent(contentID, contentName, 5);
    }

    private int openContent(long contentID, String contentName, int accessMode) {
        if (this.accessMode != 0) {
            this.logger.error("Content is still opened");
            return -23034;
        }
        if (contentID < 0L && (contentName == null || contentName.trim().length() == 0)) {
            this.logger.error("No valid id or alias of the content given");
            return -20002;
        }
        try {
            ReqOpenContent req = new ReqOpenContent(Long.valueOf(contentID), contentName, Integer.valueOf(accessMode));
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_OPENCONTENT, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            this.accessMode = accessMode;
            RspOpenContent rsp = RspOpenContent.parseGObject((GObject)response.getPayload());
            return rsp.getResultCode();
        }
        catch (TimeoutException tox) {
            this.logger.error(String.format("Timeout while opening content [%s (%s)] on [%s]", contentID, contentName, this.host), (Throwable)tox);
            return -23032;
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -23032;
        }
    }

    @Override
    public int changeRecordingMode(int recordingMode, long preAlarmTimerange, long preAlarmFPS, boolean forceRecalculationPreAlarm) {
        try {
            ReqChangeRecordingMode req = new ReqChangeRecordingMode(Integer.valueOf(recordingMode), Long.valueOf(preAlarmTimerange), Long.valueOf(preAlarmFPS), Boolean.valueOf(forceRecalculationPreAlarm));
            GObject goREQ = req.createGObject();
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_CHANGERECORDINGMODE, (GObject)goREQ);
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            return response.getError();
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return -23032;
        }
    }

    @Override
    public int writeFrame(ContentFrame contentFrame) {
        if (contentFrame.getStartTimestamp() < 1343197544448L) {
            this.logger.error(contentFrame + " has invalid timestamps");
            return -21050;
        }
        if (this.accessMode != 5 && this.accessMode != 3 && this.accessMode != 4) {
            this.logger.error("Content not opened for writing");
            return -23034;
        }
        try {
            ReqWriteFrame req = new ReqWriteFrame(Integer.valueOf(contentFrame.getMediatype()), Integer.valueOf(contentFrame.getAttributes()), Long.valueOf(contentFrame.getStartTimestamp()), Long.valueOf(contentFrame.getEndTimestamp()), contentFrame.getData());
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_WRITEFRAME, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            return response.getError();
        }
        catch (Exception ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            return -23032;
        }
    }

    @Override
    public int writeMultipleFrames(ContentFrame[] contentFrames) {
        if (contentFrames != null) {
            for (ContentFrame contentFrame : contentFrames) {
                if (contentFrame.getStartTimestamp() >= 1343197544448L) continue;
                this.logger.error(contentFrame + " has invalid timestamps");
                return -21050;
            }
        }
        if (this.accessMode != 5 && this.accessMode != 3 && this.accessMode != 4) {
            this.logger.error("Content not opened for writing");
            return -23034;
        }
        try {
            SrpcMessage response;
            ReqWriteMultipleFrames req = new ReqWriteMultipleFrames(contentFrames);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_WRITEMULTIPLEFRAMES, (GObject)req.createGObject());
            long nanoTimestamp = System.nanoTime();
            try {
                response = this.sendGenericRequest(request, 30000L);
            }
            catch (TimeoutException tex) {
                this.logger.warn("TIMEOUT while writing multiple Frames : " + request);
                response = SrpcMessage.createResponse((SrpcMessage)request, null);
                response.setError(-23032);
            }
            long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoTimestamp);
            if (duration > 2000L) {
                this.logger.warn("Response for " + request + " lasts for [" + duration + " ms].");
            }
            return response.getError();
        }
        catch (Exception ex) {
            this.logger.warn((Object)ex, (Throwable)ex);
            return -23032;
        }
    }

    @Override
    public int writeLocalStorageFrames(ContentFrame[] contentFrames) {
        try {
            ReqWriteLocalStorageFrames req = new ReqWriteLocalStorageFrames(contentFrames);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_WRITELOCALSTORAGEFRAMES, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            return response.getError();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
            return -23032;
        }
    }

    @Override
    public int setupLocalStorageRecording(Long contentID, Integer trackId) {
        try {
            ReqSetupLocalStorageRecording req = new ReqSetupLocalStorageRecording(contentID, trackId);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_SETUPLOCALSTORAGERECORDING, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            return response.getError();
        }
        catch (Throwable ex) {
            this.logger.error(ex.getMessage());
            return -23032;
        }
    }

    @Override
    public int finalizeLocalStorageRecording(Long contentID) {
        try {
            ReqFinalizeLocalStorageRecording req = new ReqFinalizeLocalStorageRecording(contentID);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_FINALIZELOCALSTORAGERECORDING, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            return response.getError();
        }
        catch (Throwable ex) {
            this.logger.error(ex.getMessage());
            return -23032;
        }
    }

    @Override
    public int finalizeCurrentSequence() {
        try {
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_FINALIZECURRENTSEQUENCE, null);
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            return response.getError();
        }
        catch (Throwable ex) {
            this.logger.error(ex.getMessage());
            return -23032;
        }
    }

    @Override
    public int readNextFrame(Integer mediatype, Integer track, Long timestamp, Integer transactionId, String token, List<ContentFrame> frames) {
        if (this.accessMode != 1 && this.accessMode != 2) {
            this.logger.error("Content not opened for reading");
            return -23034;
        }
        try {
            ReqReadNextFrame req = new ReqReadNextFrame(mediatype, track, timestamp, transactionId);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_READNEXTFRAME, (GObject)req.createGObject(), (String)token);
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            RspReadNextFrame rsp = RspReadNextFrame.parseGObject((GObject)response.getPayload());
            frames.add(null);
            frames.add(null);
            frames.add(rsp.getContentFrame());
            return response.getError();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -23032;
        }
    }

    @Override
    public int readPreviousFrame(Integer mediatype, Integer track, Long timestamp, Integer transactionId, String token, List<ContentFrame> frames) {
        if (this.accessMode != 1 && this.accessMode != 2) {
            this.logger.error("Content not opened for reading");
            return -23034;
        }
        try {
            ReqReadPreviousFrame req = new ReqReadPreviousFrame(mediatype, track, timestamp, transactionId);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_READPREVIOUSFRAME, (GObject)req.createGObject(), (String)token);
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            RspReadPreviousFrame rsp = RspReadPreviousFrame.parseGObject((GObject)response.getPayload());
            frames.add(null);
            frames.add(null);
            frames.add(rsp.getContentFrame());
            return response.getError();
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage());
            return -23032;
        }
    }

    @Override
    public ContentFrame[] readMultipleFrames(ReqReadMultipleFrames req) throws SeeTecException {
        if (this.accessMode != 1 && this.accessMode != 2) {
            this.logger.error("Content not opened for reading");
            throw new SeeTecException(-23034, "Reading multiple frames failed");
        }
        try {
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_READMULTIPLEFRAMES, (GObject)req.createGObject(), (String)req.getToken());
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            RspReadMultipleFrames rsp = RspReadMultipleFrames.parseGObject((GObject)response.getPayload());
            return rsp.getContentFrames();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            throw new SeeTecException(-23032, "Reading multiple frames failed");
        }
    }

    @Override
    public int getRecordingInformation(ReqGetRecordingInfos req, List<RspGetRecordingInfos> results) {
        try {
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_GETRECORDINGINFOS, (GObject)req.createGObject(), (String)req.getToken());
            SrpcMessage response = this.sendGenericRequest(request, TimeUnit.SECONDS.toMillis(30000L));
            if (response.getPayload().size() > 1 && response.getError() == 0) {
                results.add(RspGetRecordingInfos.parseGObject((GObject)response.getPayload()));
            } else {
                this.logger.warn("No recording infos found. Database seems to be empty for " + this.toString());
            }
            return response.getError();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -23032;
        }
    }

    @Override
    public int writeAlarmInstances(LinkedList<Long[]> alarmInstances) {
        try {
            ReqWriteAlarmInstances req = new ReqWriteAlarmInstances(alarmInstances);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_WRITEALARMINSTANCES, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, 30000L);
            return response.getError();
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
            return -23032;
        }
    }

    @Override
    public int getAlarmInstance(long contentID, long alarmInstanceID, List<Long[]> results) {
        try {
            ReqGetAlarmInstance req = new ReqGetAlarmInstance(Long.valueOf(contentID), Long.valueOf(alarmInstanceID));
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_GETALARMINSTANCE, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, 600000L);
            RspGetAlarmInstance rsp = RspGetAlarmInstance.parseGObject((GObject)response.getPayload());
            results.clear();
            results.add(new Long[]{rsp.getStartTimestamp(), rsp.getEndTimestamp()});
            return response.getError();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -23032;
        }
    }

    @Override
    public int getAlarmInstances(Long contentID, Long tsStart, Long tsEnd, List<List<Long[]>> results) {
        try {
            ReqGetAlarmInstances req = new ReqGetAlarmInstances(contentID, tsStart, tsEnd);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_GETALARMINSTANCES, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, TimeUnit.MINUTES.toMillis(10L));
            RspGetAlarmInstances rsp = RspGetAlarmInstances.parseGObject((GObject)response.getPayload());
            results.clear();
            results.add(rsp.getAlarmInstances());
            return rsp.getResultCode();
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            return -23032;
        }
    }

    @Override
    public int getAlarmScenarioOccurrencies(Long contentID, Long tsStart, Long tsEnd, List<? super RspGetAlarmScenarioOccurrencies> results) {
        int result;
        long nanoStart = System.nanoTime();
        try {
            ReqGetAlarmScenarioOccurrencies req = new ReqGetAlarmScenarioOccurrencies(contentID, tsStart, tsEnd);
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_REQ_GETALARMSCENARIOOCCURRENCIES, (GObject)req.createGObject());
            SrpcMessage response = this.sendGenericRequest(request, TimeUnit.SECONDS.toMillis(30L));
            RspGetAlarmScenarioOccurrencies rsp = RspGetAlarmScenarioOccurrencies.parseGObject((GObject)response.getPayload());
            results.clear();
            results.add((RspGetAlarmScenarioOccurrencies)rsp);
            return response.getError();
        }
        catch (TimeoutException tex) {
            long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoStart);
            this.logger.warn("Got no response within [" + duration + " ms] - " + tex.getMessage());
            result = -23032;
        }
        catch (Throwable ex) {
            this.logger.error((Object)ex, ex);
            result = -23032;
        }
        return result;
    }

    @Override
    public int execManualExport() {
        int result = 0;
        try {
            SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.MD_REQ_STARTMANUALEXPORT, null);
            this.sendGenericRequest(request, TimeUnit.SECONDS.toMillis(30L));
        }
        catch (Exception e) {
            this.logger.error((Object)e, (Throwable)e);
            result = -23032;
        }
        return result;
    }

    public String toString() {
        String sThis = ((Object)((Object)this)).getClass().getName() + "@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.srpcClient + "]";
    }

    public final void handleRequest(SrpcMessage request, RequestHandlerCallback callback) {
        switch (Methods.valueOf((int)request.getHash())) {
            case PING: {
                try {
                    List parameters = request.getPayload().getChildren();
                    if (parameters.size() != 1) {
                        this.logger.error("Signature of response [Ping] invalid");
                        break;
                    }
                    GObject goParamter0 = (GObject)parameters.get(0);
                    if (goParamter0.getType() != 12) {
                        this.logger.error("Signature of response [Ping] invalid");
                        break;
                    }
                    Long timestamp = goParamter0.getAsLong();
                    this.logger.info("[Ping] had a delay of [" + (System.currentTimeMillis() - timestamp) + "] ms");
                }
                catch (Exception exception) {
                    this.logger.error(exception.getMessage());
                }
                break;
            }
            case SSL_SRPC_REQ_STATUSCONTENT: {
                this.listener.sendContentStatus((ReqStatusContent)ReqStatusContent.parseGObject((GObject)request.getPayload()));
                break;
            }
        }
    }

    @Override
    public int getCameraRecordingStatistics(RspGetCameraRecordingStatistics result, long granularity) {
        int errorCode = 0;
        SrpcMessage request = SrpcMessage.createRequest((Methods)Methods.RE_SRPC_GET_CAMERA_RECORDING_STATISTICS, (GObject)GObject.create((long)granularity));
        SrpcMessage response = null;
        try {
            response = this.sendGenericRequest(request, TimeUnit.SECONDS.toMillis(30L));
        }
        catch (SeeTecException | InterruptedException | ExecutionException | TimeoutException exception) {
            this.logger.error("Could not get Camera Recording Statistics [" + exception.getMessage() + "] for " + (Object)((Object)this));
            errorCode = -20001;
            result.setResultCode(errorCode);
        }
        if (response != null) {
            result.setRspGetCameraRecordingStatistics(response.getPayload());
        }
        return errorCode;
    }

    public final SrpcRequestHandlerIntf getRequestHandler(SrpcMessage message) {
        return this;
    }
}

