/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterType;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.communication.MDBWriter;
import de.seetec.v5.re.cm.shared.communication.MDBWriterFactory;
import de.seetec.v5.shared.util.SeeTecException;

public class MDBWriterFactoryImpl
implements MDBWriterFactory {
    private boolean additionalAlarmRecordingEnabled;
    private Core core;
    private MDBAccessorIntf mdbAccessor;
    private DatabaseWriterType mdbWriterType;

    private MDBWriterFactoryImpl() {
    }

    public MDBWriterFactoryImpl(boolean additionalAlarmRecordingEnabled, Core core, MDBAccessorIntf mdbAccessor, DatabaseWriterType mdbWriterType) throws SeeTecException {
        this.assureInputParametersNotNull(core, mdbAccessor, mdbWriterType);
        this.additionalAlarmRecordingEnabled = additionalAlarmRecordingEnabled;
        this.core = core;
        this.mdbAccessor = mdbAccessor;
        this.mdbWriterType = mdbWriterType;
    }

    @Override
    public MDBWriter getInstance(int index) throws SeeTecException {
        return new MDBWriter(this.additionalAlarmRecordingEnabled, this.core, this.mdbAccessor, this.mdbWriterType, index);
    }

    private void assureInputParametersNotNull(Core core, MDBAccessorIntf mdbAccessor, DatabaseWriterType mdbWriterType) throws SeeTecException {
        if (core == null) {
            throw new SeeTecException(-20002, "Core null");
        }
        if (mdbAccessor == null) {
            throw new SeeTecException(-20002, "MDBAccessorIntf null");
        }
        if (mdbWriterType == null) {
            throw new SeeTecException(-20002, "DatabaseWriterType null");
        }
    }
}

