/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.device.shared.videosource.UseRelativeRTPTimestamp;
import de.seetec.v5.re.cm.shared.AlarmScenario;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxyListener;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriterType;
import de.seetec.v5.re.cm.shared.communication.MDBAccessorIntf;
import de.seetec.v5.re.cm.shared.sql.FrameStatisticDoNothing;
import de.seetec.v5.re.cm.shared.sql.FrameStatisticIntf;
import de.seetec.v5.re.cm.shared.sql.StatisticalSummary;
import de.seetec.v5.re.shared.CnfVideoSourceFtpExport;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.re.shared.ContentFrameTools;
import de.seetec.v5.re.shared.FramerateChecker;
import de.seetec.v5.re.shared.MDBCnfIntf;
import de.seetec.v5.re.shared.SmoothingBuffer;
import de.seetec.v5.re.shared.SmoothingBufferImpl;
import de.seetec.v5.re.shared.VideoSourceCnf;
import de.seetec.v5.re.shared.srpc.ReqStatusContent;
import de.seetec.v5.re.shared.srpc.TrackContentInfo;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.DefaultSystemTimeProvider;
import de.seetec.v5.shared.OPCLowerNodeIDType;
import de.seetec.v5.shared.SystemTimeProvider;
import de.seetec.v5.shared.util.AccumulatingLogger;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MDBWriter
extends Basic
implements Runnable,
DatabaseProxyListener {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.MDBWriter";
    private final Object mdsProxySemaphore = new Object();
    private final Object syncObj = new Object();
    private final LinkedList<ContentFrame> contentFrameBuffer = new LinkedList();
    private final SmoothingBuffer smoothingBuffer = new SmoothingBufferImpl();
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private final boolean additionalAlarmRecordingEnabled;
    private final Core core;
    private final MDBAccessorIntf mdbAccessor;
    private final DatabaseWriterType mdbWriterType;
    private final int proxyIndex;
    private Thread myThread = null;
    private DatabaseProxy mdsProxy = null;
    private long maxVideoQueueLength = -1L;
    private boolean finalizeSignal = false;
    private long previousLiveFrameTimestamp = -1L;
    private int previousLiveFrameMediatype = -1;
    private volatile long nanoLastBufferOverflowCheck = -1L;
    private StatisticalSummary statisticalSummary = null;
    private long contentID = -1L;
    private String contentName = "Name of content unknown";
    private FramerateChecker framerateChecker = null;
    private boolean standardOrAlarmRecordingEnabled = false;
    private boolean standardRecordingEnabled = false;
    private boolean alarmRecordingEnabled = false;
    private boolean alarmRecordingActive = false;
    private boolean preAlarmRecordingEnabled = false;
    private long stdRecFramerate = 0L;
    private long alarmRecFramerate = 0L;
    private long lastWriteTimestamp = -1L;
    private boolean setupLocalStorageFinished = false;
    private int recentlySetRecordingMode = -1;
    private long recentlyPreAlarmTimerange = -1L;
    private long recentlyAlarmFPS = -1L;
    private boolean hasRTPTimestamp = false;
    private final AccumulatingLogger accumulatingLogger = new AccumulatingLogger(this.logger);

    public MDBWriter(boolean additionalAlarmRecordingEnabled, Core core, MDBAccessorIntf mdbAccessor, DatabaseWriterType mdbWriterType, int proxyIndex) throws SeeTecException {
        this.accumulatingLogger.startSession(Level.WARN, TimeUnit.MINUTES.toMillis(1L), "rtp");
        this.accumulatingLogger.startSession(Level.WARN, TimeUnit.MINUTES.toMillis(1L), "nonrtp");
        this.additionalAlarmRecordingEnabled = additionalAlarmRecordingEnabled;
        this.core = core;
        if (this.core == null) {
            throw new SeeTecException(-21601, "Argument for MDBWriter was null");
        }
        this.mdbAccessor = mdbAccessor;
        if (this.mdbAccessor == null) {
            throw new SeeTecException(-21601, "Argument for MDBWriter was null");
        }
        this.mdbWriterType = mdbWriterType;
        try {
            MDBCnfIntf mdbCnf = this.mdbAccessor.getMDBCnf();
            this.standardOrAlarmRecordingEnabled = mdbCnf.isRecordingEnabled();
            this.standardRecordingEnabled = mdbCnf.isRecordingEnabled("Standard");
            this.alarmRecordingEnabled = mdbCnf.isRecordingEnabled("Alarm");
            long preAlarmTime = mdbCnf instanceof VideoSourceCnf ? ((VideoSourceCnf)mdbCnf).getPreAlarmTime() : -1L;
            this.preAlarmRecordingEnabled = preAlarmTime > 0L;
            this.framerateChecker = new FramerateChecker();
            this.framerateChecker.init(0L);
            this.contentID = this.mdbAccessor.getContentID();
            this.contentName = this.mdbAccessor.getContentName();
            this.stdRecFramerate = this.mdbAccessor.getMDBCnf().getFramerate("Standard");
            this.alarmRecFramerate = this.mdbAccessor.getMDBCnf().getFramerate("Alarm");
            FrameStatisticIntf frameStatistic = proxyIndex == 1 ? new FrameStatisticDoNothing() : this.core.getFrameStatistic();
            this.statisticalSummary = new StatisticalSummary(this.contentID, frameStatistic, this.additionalAlarmRecordingEnabled);
            this.statisticalSummary.init();
            this.maxVideoQueueLength = Math.max(3000L, this.core.getDmCnfMgr().getMaxVideoQueueLength());
        }
        catch (ConfigurationException ex) {
            throw new SeeTecException(-21601, "Error while reading configuration for " + mdbAccessor);
        }
        this.proxyIndex = proxyIndex;
    }

    public void init() {
        this.getMultimediaDatabaseProxy();
        this.myThread = new Thread((Runnable)this, this.toString());
        this.myThread.start();
    }

    protected static int getNumberOfFrames(ContentFrame[] cummulatedContentFrames) {
        int numberOfFrames = 0;
        for (ContentFrame cf : cummulatedContentFrames) {
            numberOfFrames += cf.getNumberOfFrameParts();
        }
        return numberOfFrames;
    }

    protected static long getLastTimestamp(ContentFrame[] cummulatedContentFrames) {
        long lastTimestamp = 0L;
        for (ContentFrame cf : cummulatedContentFrames) {
            if (cf.isPacked()) {
                List unpackedFrames = cf.getUnpackedContentFrames();
                lastTimestamp = Collections.max(unpackedFrames, Comparator.comparing(contentFrame -> contentFrame.getStartTimestamp())).getStartTimestamp();
                continue;
            }
            if (cf.getStartTimestamp() <= lastTimestamp) continue;
            lastTimestamp = cf.getStartTimestamp();
        }
        return lastTimestamp;
    }

    public boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        try {
            this.flushRecordingQueue();
        }
        catch (Throwable throwable) {
            this.logger.warn("Error flushing recording queue [" + throwable.getMessage() + "] for " + this);
        }
        this.statisticalSummary.shutdown();
        if (this.myThread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + this + " didn't finished in time ");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.warn("Error while sleeping...");
                }
            }
            this.myThread = null;
        }
        try {
            if (this.mdsProxy != null) {
                int errorCode = this.mdsProxy.shutdown();
                if (errorCode != 0) {
                    this.logger.warn("Shutting down " + (Object)((Object)this.mdsProxy) + " of " + this + " failed with error [" + errorCode + "]");
                }
                this.mdsProxy = null;
            }
        }
        catch (Throwable throwable) {
            this.logger.warn("Discarding " + (Object)((Object)this.mdsProxy) + " of " + this + " failed ");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block18: {
            super.setRunFinished(CLASS_NAME, false);
            int errorCode = 0;
            try {
                do {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.warn("Error while sleeping...");
                    }
                    if (this.isShutdown()) break block18;
                    if (this.finalizeSignal) {
                        try {
                            this.logger.info("Finalizing current sequence of " + this);
                            this.finalizeSignal = false;
                            this.finalizeLocalStorage();
                            this.getMultimediaDatabaseProxy().finalizeCurrentSequence();
                            Object interruptedException = this.syncObj;
                            synchronized (interruptedException) {
                                this.contentFrameBuffer.clear();
                            }
                        }
                        catch (Throwable throwable) {
                            this.logger.warn("Error while handling finalizing signal for " + this, throwable);
                        }
                    }
                    if (System.currentTimeMillis() - this.lastWriteTimestamp <= this.maxVideoQueueLength) continue;
                    LinkedList<ContentFrame> temporaryContentBuffer = null;
                    Object object = this.syncObj;
                    synchronized (object) {
                        boolean containsAtLeast2FullFrames = ContentFrameTools.containsAtLeastNumberOfFullFrames(this.contentFrameBuffer, (int)2);
                        if (containsAtLeast2FullFrames) {
                            int pointer = this.findLastFullFrame(this.contentFrameBuffer);
                            temporaryContentBuffer = this.sortContentFrameBuffer(pointer, this.contentFrameBuffer);
                        }
                    }
                    if (temporaryContentBuffer == null || temporaryContentBuffer.size() <= 0) continue;
                    errorCode = this.writeFrames(temporaryContentBuffer);
                } while (!this.core.isShutdown() && errorCode == 0);
                try {
                    Thread.sleep(Math.round(Math.random() * 10000.0));
                }
                catch (InterruptedException interruptedException) {
                    this.logger.warn("Error while sleeping...");
                }
                if (errorCode != 0) {
                    this.logger.warn("Error: " + errorCode + " for " + this);
                }
            }
            catch (Throwable throwable) {
                this.logger.warn(this + " has an error and terminates thread [" + throwable.getMessage() + "]");
            }
        }
        super.setRunFinished(CLASS_NAME, true);
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliverFrameToArchive(ContentFrame contentFrame, boolean hasRTPTimestamp) {
        long duration;
        if (contentFrame == null) {
            return;
        }
        if (contentFrame.isVideoFrame() && this.hasRTPTimestamp != hasRTPTimestamp) {
            this.logger.info("Using RTP timestamp [" + hasRTPTimestamp + "] for " + this);
            this.hasRTPTimestamp = hasRTPTimestamp;
        }
        if (this.isShutdown()) {
            throw new RuntimeException(this + " is already shutting down!");
        }
        try {
            if (this.mdbWriterType != DatabaseWriterType.LOCAL_STORAGE && !this.standardOrAlarmRecordingEnabled && ((VideoSourceCnf)this.mdbAccessor.getMDBCnf()).getPreAlarmTime() <= 0L) {
                return;
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Error while checking/discarding frame because of no recording for " + this);
        }
        this.statisticalSummary.notifyForReceivedFrame(contentFrame);
        int contentFrameMediaType = contentFrame.getMediatype();
        if (contentFrameMediaType == 65) {
            return;
        }
        long timeNow = System.currentTimeMillis();
        long calibratedTimestamp = this.ensureIncreasingTimestamp(contentFrame.getStartTimestamp(), contentFrameMediaType, hasRTPTimestamp);
        contentFrame.setStartTimestamp(calibratedTimestamp);
        contentFrame.setEndTimestamp(calibratedTimestamp);
        if (contentFrameMediaType == 0 && this.mdbWriterType != DatabaseWriterType.LOCAL_STORAGE) {
            this.framerateChecker.setFramerate(this.getFramerate());
            if (!this.framerateChecker.checkForFramerate(contentFrame.getStartTimestamp())) {
                return;
            }
        }
        Object object = this.syncObj;
        synchronized (object) {
            this.smoothingBuffer.addContentFrame(contentFrame);
            if (this.smoothingBuffer.containsAtLeast2FullFrames()) {
                List tmpList = this.hasRTPTimestamp ? this.smoothingBuffer.getCollisionPreventedFrames() : this.smoothingBuffer.getSmoothAndCollisionPreventedFrames();
                this.contentFrameBuffer.addAll(tmpList);
            }
        }
        long lastBufferOverflowCheck = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.nanoLastBufferOverflowCheck);
        if (lastBufferOverflowCheck > 1000L) {
            this.checkQueueForOverflow();
        }
        if ((duration = System.currentTimeMillis() - timeNow) > 800L) {
            this.logger.warn("Adding frame to writing buffer takes " + duration + " ms for " + this);
        }
    }

    private long ensureIncreasingTimestamp(long contentFrameTimestamp, int contentFrameMediaType, boolean hasRtpTimestamp) throws RuntimeException {
        long calibratedTimestamp = contentFrameTimestamp;
        long deltaLastFrame = this.previousLiveFrameTimestamp - contentFrameTimestamp;
        if (deltaLastFrame >= 0L && this.previousLiveFrameMediatype == contentFrameMediaType) {
            if (deltaLastFrame < UseRelativeRTPTimestamp.THRESHOLD_FOR_JUMP_DETECTION) {
                this.logNotIncreasingTimestampWarning(hasRtpTimestamp, contentFrameTimestamp);
                calibratedTimestamp = this.previousLiveFrameTimestamp + 1L;
            } else {
                throw new RuntimeException("System time turned back for [" + deltaLastFrame + " ms]!");
            }
        }
        this.previousLiveFrameTimestamp = calibratedTimestamp;
        this.previousLiveFrameMediatype = contentFrameMediaType;
        return calibratedTimestamp;
    }

    private void logNotIncreasingTimestampWarning(boolean hasRtpTimestamp, long contentFrameTimestamp) {
        try {
            if (hasRtpTimestamp) {
                this.accumulatingLogger.log("rtp", "Adjusting Rtp timestamp of frame. (DM high load). [" + this + "]");
            } else {
                this.accumulatingLogger.log("nonrtp", "Adjusting non Rtp timestamp of frame. (System time changed). Previous timestamp: " + Core.getUniformFormattedDateTime((long)this.previousLiveFrameTimestamp) + " | frame timestamp: " + Core.getUniformFormattedDateTime((long)contentFrameTimestamp) + " for " + this);
            }
        }
        catch (SeeTecException | IllegalArgumentException exception) {
            this.logger.warn("Error cumulating messages: " + exception.getMessage());
        }
    }

    public int deliverFrameToArchiveImmediately(ContentFrame contentFrame) {
        int errorCode = this.getMultimediaDatabaseProxy().writeFrame(contentFrame);
        if (errorCode != 0) {
            this.logger.warn("Error while writing frame directly to MDS: " + errorCode + " for " + this);
        }
        return errorCode;
    }

    public int writeFtpOrMailExport(AlarmScenario alarmScenario, long alarmStart, long alarmStop) {
        try {
            try {
                long preAlarmTimerangeOfCamera = ((VideoSourceCnf)this.mdbAccessor.getMDBCnf()).getPreAlarmTime();
                long preAlarmTimerangeOfAlarmScenario = alarmScenario.getPreAlarmTime();
                if (preAlarmTimerangeOfAlarmScenario >= 0L) {
                    alarmStart -= preAlarmTimerangeOfAlarmScenario;
                } else if (preAlarmTimerangeOfCamera > 0L) {
                    alarmStart -= preAlarmTimerangeOfCamera;
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
            }
            try {
                VideoSourceCnf vdeoSourceCnf = ((VideoSrv)this.mdbAccessor).getVideoSourceCnf();
                CnfVideoSourceFtpExport cnfVideoSourceFtpExport = vdeoSourceCnf.getFtpExport();
                Long nMaximumDuration = cnfVideoSourceFtpExport.getMaximumDuration();
                if (nMaximumDuration != null && nMaximumDuration > 0L && alarmStart + nMaximumDuration < alarmStop) {
                    alarmStop = alarmStart + nMaximumDuration;
                }
            }
            catch (Throwable throwable) {
                this.logger.warn((Object)throwable, throwable);
            }
            String sXML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ExportJob>\n\r   <AlarmScenarioID>" + alarmScenario.getAlarmScenarioID() + "</AlarmScenarioID>\n\r   <CameraID>" + this.contentID + "</CameraID>\n\r   <StartTimestamp>" + alarmStart + "</StartTimestamp>\n\r   <StopTimestamp>" + alarmStop + "</StopTimestamp>\n\r</ExportJob>";
            try (FileOutputStream fos = new FileOutputStream("../../../tools/AVExport/jobs/ExportJob." + Long.toHexString(Basic.createInt8UID((SystemTimeProvider)new DefaultSystemTimeProvider())) + ".xml");){
                fos.write(sXML.getBytes());
            }
        }
        catch (Throwable throwable) {
            this.logger.error("Executing the ftp export job failed for " + this, throwable);
            return -21688;
        }
        return 0;
    }

    public void finalizeCurrentSequence() {
        this.flushRecordingQueue();
        this.finalizeSignal = true;
    }

    public int changeRecordingMode(int recordingMode) {
        return this.changeRecordingMode(recordingMode, false);
    }

    public int changeRecordingMode(int recordingMode, boolean forceRecalculationPreAlarm) {
        return this.changeRecordingMode(recordingMode, -1L, -1L, false, forceRecalculationPreAlarm);
    }

    public int changeRecordingMode(int recordingMode, long preAlarmTimerange, long preAlarmFPS, boolean alarmRecordingActive, boolean forceRecalculationPreAlarm) {
        if (recordingMode == 0 || recordingMode == 1 || recordingMode == 255) {
            this.standardOrAlarmRecordingEnabled = true;
        } else if (recordingMode == -1) {
            this.standardOrAlarmRecordingEnabled = false;
        }
        int error = this.core.sendOPCEvent(String.valueOf(recordingMode), OPCLowerNodeIDType.CAMERA_RECORDING_STATUS, this.mdbAccessor.getContentID());
        if (error != 0 && error != -21601) {
            this.logger.warn("Publishing new recording mode [" + recordingMode + "] to OPC failed for " + this);
        }
        if (error == 0 && this.logger.isDebugEnabled()) {
            this.logger.info("New recording mode [" + recordingMode + "] published to OPC for " + this);
        }
        this.flushRecordingQueue();
        this.alarmRecordingActive = alarmRecordingActive;
        this.statisticalSummary.setRecordingModus(recordingMode);
        this.statisticalSummary.setAlarmRecordingActive(alarmRecordingActive);
        error = this.getMultimediaDatabaseProxy().changeRecordingMode(recordingMode, preAlarmTimerange, preAlarmFPS, forceRecalculationPreAlarm);
        this.recentlySetRecordingMode = recordingMode;
        this.recentlyPreAlarmTimerange = preAlarmTimerange;
        this.recentlyAlarmFPS = preAlarmFPS;
        try {
            if (recordingMode == -1) {
                TrackContentInfo trackContentInfo = new TrackContentInfo(Long.valueOf(this.contentID), this.contentName, Integer.valueOf(-1), new ArrayList());
                ReqStatusContent reqStatusContent = new ReqStatusContent(trackContentInfo);
                this.mdbAccessor.sendContentStatus(reqStatusContent);
            }
        }
        catch (Throwable t) {
            this.logger.warn((Object)t, t);
        }
        return error;
    }

    public void changeAdditionalRecordingMode(boolean alarmRecordingActive) {
        this.alarmRecordingActive = alarmRecordingActive;
    }

    public void setAlarmRecFramerate(long framerate) {
        this.alarmRecFramerate = framerate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushRecordingQueue() {
        LinkedList<ContentFrame> temporaryContentBuffer = null;
        this.flushSmoothingBuffer();
        Object object = this.syncObj;
        synchronized (object) {
            if (this.contentFrameBuffer.size() > 0) {
                int pointer = this.contentFrameBuffer.size();
                try {
                    temporaryContentBuffer = this.sortContentFrameBuffer(pointer, this.contentFrameBuffer);
                }
                catch (SeeTecException seeTecException) {
                    this.logger.warn("Error [" + seeTecException.getMessage() + "] sorting content frame buffer for " + this);
                }
            }
        }
        if (temporaryContentBuffer != null && !temporaryContentBuffer.isEmpty()) {
            this.writeFrames(temporaryContentBuffer);
        }
    }

    public void flushRecordingQueue(Long requestTimestamp) {
        if (System.currentTimeMillis() - requestTimestamp < this.maxVideoQueueLength) {
            this.flushRecordingQueue();
        }
    }

    public int setupLocalStorage(Integer track) {
        int errorCode = 0;
        if (this.mdbWriterType == DatabaseWriterType.LOCAL_STORAGE) {
            errorCode = this.getMultimediaDatabaseProxy().setupLocalStorageRecording(this.contentID, track);
            if (errorCode != 0) {
                this.logger.error("Initializing " + this.statisticalSummary + " failed with error [" + errorCode + "] while setting up local storage for " + this);
                return errorCode;
            }
        } else {
            this.logger.warn("Localstorage not active for " + this);
        }
        this.setupLocalStorageFinished = true;
        this.previousLiveFrameTimestamp = -1L;
        this.previousLiveFrameMediatype = -1;
        return errorCode;
    }

    @Override
    public void sendContentStatus(ReqStatusContent reqContentStatus) {
        this.mdbAccessor.sendContentStatus(reqContentStatus);
    }

    public boolean isReady() {
        return !this.isShutdown() && this.mdsProxy != null && this.mdsProxy.isReady();
    }

    public int getRecentlySetRecordingmode() {
        return this.recentlySetRecordingMode;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.MDBWriter@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Entity=[" + this.contentID + "]/[" + this.contentName + "], " + (Object)((Object)this.mdsProxy) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseProxy getMultimediaDatabaseProxy() {
        Object object = this.mdsProxySemaphore;
        synchronized (object) {
            int errorCode;
            if (this.mdsProxy != null && this.mdsProxy.isReady()) {
                return this.mdsProxy;
            }
            if (this.isShutdown()) {
                throw new RuntimeException(this + " is already shutting down!");
            }
            DatabaseProxy tempMdsProxy = null;
            try {
                tempMdsProxy = this.core.createDatabaseProxy((DatabaseProxyListener)this, this.proxyIndex);
            }
            catch (Exception exception) {
                throw new RuntimeException("Creating mds for " + this.mdbAccessor + " failed");
            }
            if (this.mdbWriterType != DatabaseWriterType.LOCAL_STORAGE && (errorCode = this.mdbWriterType == DatabaseWriterType.ADDITIONAL_RECORDING ? tempMdsProxy.openContentForAdditionalWriting(this.contentID, this.contentName) : tempMdsProxy.openContentForWriting(this.contentID, this.contentName)) != 0) {
                tempMdsProxy.shutdown();
                throw new RuntimeException("Opening content [" + this.contentID + "]/[" + this.contentName + "] failed with error [" + errorCode + "]");
            }
            if (this.recentlySetRecordingMode != -1 && (errorCode = tempMdsProxy.changeRecordingMode(this.recentlySetRecordingMode, this.recentlyPreAlarmTimerange, this.recentlyAlarmFPS, false)) != 0) {
                tempMdsProxy.shutdown();
                throw new RuntimeException("Changing recording mode of [" + this.contentID + "]/[" + this.contentName + "] failed with error [" + errorCode + "]");
            }
            this.mdsProxy = tempMdsProxy;
            return this.mdsProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkQueueForOverflow() {
        if (this.mdbWriterType == DatabaseWriterType.LOCAL_STORAGE) {
            return;
        }
        this.nanoLastBufferOverflowCheck = System.nanoTime();
        Object object = this.syncObj;
        synchronized (object) {
            boolean containsAtLeast5FullFrames = ContentFrameTools.containsAtLeastNumberOfFullFrames(this.contentFrameBuffer, (int)5);
            long queueLength = this.maxVideoQueueLength;
            if (containsAtLeast5FullFrames || this.contentFrameBuffer.size() >= 10000) {
                long actualQueueLength;
                if (this.contentFrameBuffer.size() >= 10000) {
                    this.logger.warn("Discarding frames for " + this + ". Queue length: " + this.contentFrameBuffer.size() + " for " + this);
                }
                if ((actualQueueLength = this.contentFrameBuffer.getLast().getEndTimestamp() - this.contentFrameBuffer.getFirst().getEndTimestamp()) > queueLength * 2L) {
                    int numberOfDiscardedIFrames = 0;
                    int numberOfDiscardedNonIFrames = 0;
                    if (this.contentFrameBuffer.getFirst().getMediatype() == 0) {
                        for (int i = this.contentFrameBuffer.size() - 1; i >= 0; i -= 2) {
                            this.notifyForDiscardedFrame(this.contentFrameBuffer.get(i));
                            ++numberOfDiscardedNonIFrames;
                            this.contentFrameBuffer.remove(i);
                        }
                    } else {
                        int i;
                        for (i = this.contentFrameBuffer.size() - 1; i >= 0; --i) {
                            ContentFrame cf = this.contentFrameBuffer.get(i);
                            if (cf.getMediatype() == 33) continue;
                            this.notifyForDiscardedFrame(this.contentFrameBuffer.get(i));
                            ++numberOfDiscardedNonIFrames;
                            this.contentFrameBuffer.remove(i);
                        }
                        if (this.contentFrameBuffer.size() > 16) {
                            for (i = this.contentFrameBuffer.size() - 1; i >= 0; i -= 2) {
                                ++numberOfDiscardedIFrames;
                                this.notifyForDiscardedFrame(this.contentFrameBuffer.get(i));
                                this.contentFrameBuffer.remove(i);
                            }
                        }
                    }
                    this.logger.warn("Discarding " + numberOfDiscardedIFrames + " I-Frames and " + numberOfDiscardedNonIFrames + " non-I-Frames for " + this);
                    this.logger.warn("Queue has now " + this.contentFrameBuffer.size() + " elements and was " + actualQueueLength + " ms long for " + this);
                }
            }
        }
    }

    private void notifyForWrittenFrame(ContentFrame contentFrame) {
        this.statisticalSummary.setAlarmRecordingActive(this.alarmRecordingActive);
        this.statisticalSummary.notifyForWrittenFrame(contentFrame);
        this.core.deviceManagerStatistic.incrementWrittenDatabaseFrames();
    }

    private void notifyForDiscardedFrame(ContentFrame contentFrame) {
        this.statisticalSummary.setAlarmRecordingActive(this.alarmRecordingActive);
        this.statisticalSummary.notifyForDiscardedFrame(contentFrame);
        this.core.deviceManagerStatistic.incrementDiscardedDatabaseFrames();
    }

    protected long getFramerate() {
        if (!this.standardRecordingEnabled && !this.alarmRecordingEnabled) {
            return 0L;
        }
        if (!this.standardRecordingEnabled && this.preAlarmRecordingEnabled) {
            return this.alarmRecFramerate;
        }
        if (this.standardRecordingEnabled && !this.alarmRecordingEnabled) {
            return this.stdRecFramerate;
        }
        if (!this.standardRecordingEnabled && !this.alarmRecordingActive) {
            return 0L;
        }
        if (this.standardRecordingEnabled && this.alarmRecordingEnabled && !this.alarmRecordingActive) {
            return this.stdRecFramerate;
        }
        return this.alarmRecFramerate;
    }

    private ContentFrame cumulateFrames(ArrayList<ContentFrame> cummulatedContentFramesList) {
        ContentFrame contentFrame = cummulatedContentFramesList.get(0);
        if (cummulatedContentFramesList.size() > 1) {
            long tsYoungest = contentFrame.getStartTimestamp();
            for (int i = 1; i < cummulatedContentFramesList.size(); ++i) {
                ContentFrame cf = cummulatedContentFramesList.get(i);
                if (cf.getStartTimestamp() == tsYoungest) {
                    cf.setStartTimestamp(tsYoungest + 1L);
                    cf.setEndTimestamp(tsYoungest + 1L);
                }
                tsYoungest = cf.getStartTimestamp();
                contentFrame.addFramePart(cf.getData(), cf.getEndTimestamp());
            }
        }
        return contentFrame;
    }

    private int findLastFullFrame(LinkedList<ContentFrame> contentFrameBuffer) {
        if (!contentFrameBuffer.isEmpty()) {
            for (int i = contentFrameBuffer.size() - 1; i >= 0; --i) {
                if (!contentFrameBuffer.get(i).isFullVideoFrame()) continue;
                return i;
            }
        }
        return -1;
    }

    private ContentFrame[] cumulateContentFrames(LinkedList<ContentFrame> temporaryContentBuffer) {
        ArrayList<ContentFrame> cummulatedPFrames = new ArrayList<ContentFrame>();
        ArrayList<ContentFrame> cummulatedTrackingFrames = new ArrayList<ContentFrame>();
        ArrayList<ContentFrame> cummulatedAudioFrames = new ArrayList<ContentFrame>();
        ArrayList<ContentFrame> contentFrames2Send = new ArrayList<ContentFrame>();
        for (int i = 0; i < temporaryContentBuffer.size(); ++i) {
            ContentFrame contentFrame = temporaryContentBuffer.get(i);
            switch (contentFrame.getMediatype()) {
                case 35: {
                    cummulatedPFrames.add(contentFrame);
                    break;
                }
                case 16: {
                    cummulatedAudioFrames.add(contentFrame);
                    break;
                }
                case 49: {
                    cummulatedTrackingFrames.add(contentFrame);
                    break;
                }
            }
            if (contentFrame.getMediatype() != 0 && contentFrame.getMediatype() != 33 && contentFrame.getMediatype() != 1 && i != temporaryContentBuffer.size() - 1) continue;
            if (!cummulatedPFrames.isEmpty()) {
                ContentFrame cummulatedPFrame = this.cumulateFrames(cummulatedPFrames);
                contentFrames2Send.add(cummulatedPFrame);
                cummulatedPFrames.clear();
            }
            if (!cummulatedAudioFrames.isEmpty()) {
                ContentFrame cummulatedAudioFrame = this.cumulateFrames(cummulatedAudioFrames);
                contentFrames2Send.add(cummulatedAudioFrame);
                cummulatedAudioFrames.clear();
            }
            if (!cummulatedTrackingFrames.isEmpty()) {
                ContentFrame cummulatedTrackingFrame = this.cumulateFrames(cummulatedTrackingFrames);
                contentFrames2Send.add(cummulatedTrackingFrame);
                cummulatedTrackingFrames.clear();
            }
            if (contentFrame.getMediatype() != 0 && contentFrame.getMediatype() != 1 && contentFrame.getMediatype() != 33) continue;
            contentFrames2Send.add(contentFrame);
        }
        return contentFrames2Send.toArray(new ContentFrame[contentFrames2Send.size()]);
    }

    private LinkedList<ContentFrame> sortContentFrameBuffer(int pointer, LinkedList<ContentFrame> contentFrameBuffer) throws SeeTecException {
        if (pointer > contentFrameBuffer.size()) {
            throw new SeeTecException(-20002, "Sorting List of Content Frames failed");
        }
        LinkedList<ContentFrame> temporaryContentBuffer = new LinkedList<ContentFrame>();
        for (int i = 0; i < pointer; ++i) {
            try {
                ContentFrame contentFrame;
                try {
                    contentFrame = contentFrameBuffer.removeFirst();
                }
                catch (NoSuchElementException ex) {
                    continue;
                }
                boolean positionBetweenFramesFound = false;
                for (int j = temporaryContentBuffer.size() - 1; j >= 0; --j) {
                    if (temporaryContentBuffer.get(j) == null) {
                        this.logger.warn((Object)contentFrame.getMediatype());
                        this.logger.warn(">>>> " + temporaryContentBuffer.get(i));
                    }
                    if (temporaryContentBuffer.get(j).getEndTimestamp() >= contentFrame.getStartTimestamp()) continue;
                    temporaryContentBuffer.add(j + 1, contentFrame);
                    positionBetweenFramesFound = true;
                    break;
                }
                if (positionBetweenFramesFound) continue;
                temporaryContentBuffer.addFirst(contentFrame);
                continue;
            }
            catch (Exception exception) {
                this.logger.warn("Exception while adding content frame to temporary queue for " + this, (Throwable)exception);
            }
        }
        return temporaryContentBuffer;
    }

    private int writeFrames(LinkedList<ContentFrame> temporaryContentBuffer) {
        int errorCode;
        ContentFrame[] cummulatedContentFrames = this.cumulateContentFrames(temporaryContentBuffer);
        this.lastWriteTimestamp = System.currentTimeMillis();
        long nanoTimestamp = System.nanoTime();
        if (this.mdbWriterType == DatabaseWriterType.LOCAL_STORAGE) {
            int numberOfFrames = MDBWriter.getNumberOfFrames(cummulatedContentFrames);
            long lastTimestamp = MDBWriter.getLastTimestamp(cummulatedContentFrames);
            this.logger.info("WRITE LOCAL STORAGE DATA FOR '" + this.contentName + "' | SIZE: " + numberOfFrames + " Timestamps: " + (cummulatedContentFrames.length > 0 ? new Date(cummulatedContentFrames[0].getStartTimestamp()) + " - " + new Date(lastTimestamp) : ""));
            errorCode = this.getMultimediaDatabaseProxy().writeLocalStorageFrames(cummulatedContentFrames);
        } else {
            errorCode = this.getMultimediaDatabaseProxy().writeMultipleFrames(cummulatedContentFrames);
        }
        long duration = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - nanoTimestamp);
        if (duration > 2000L && cummulatedContentFrames != null) {
            long volume = 0L;
            for (ContentFrame cf : cummulatedContentFrames) {
                volume += (long)cf.getFrameSize();
            }
            this.logger.warn("Writing [" + cummulatedContentFrames.length + "] frames with a volume of [" + Basic.longToFormattedString((long)(volume >> 10)) + " KB] lasts for [" + duration + " ms] --> " + this);
        }
        if (errorCode != 0) {
            this.logger.warn("Error while writing to MDS: " + errorCode + " for " + this.contentName);
            return errorCode;
        }
        for (ContentFrame cf : cummulatedContentFrames) {
            this.notifyForWrittenFrame(cf);
        }
        return errorCode;
    }

    private int finalizeLocalStorage() {
        int errorCode = 0;
        if (this.mdbWriterType == DatabaseWriterType.LOCAL_STORAGE && this.setupLocalStorageFinished) {
            this.flushRecordingQueue();
            errorCode = this.getMultimediaDatabaseProxy().finalizeLocalStorageRecording(this.contentID);
            if (errorCode != 0) {
                this.logger.warn("Problems while finalizing local storage recording for " + this + " failed with error [" + errorCode + "]");
            } else {
                this.setupLocalStorageFinished = false;
            }
        } else {
            this.logger.warn("Localstorage not active for " + this);
        }
        return errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushSmoothingBuffer() {
        Object object = this.syncObj;
        synchronized (object) {
            List tmpList = this.smoothingBuffer.flushBuffer();
            this.contentFrameBuffer.addAll(tmpList);
        }
    }
}

