/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.ConfigurationProvider;
import de.seetec.v5.re.cm.ConfigurationProviderListener;
import de.seetec.v5.re.cm.shared.AlarmScenario;
import de.seetec.v5.re.cm.shared.communication.DatabaseWriter;
import de.seetec.v5.re.cm.shared.communication.FailoverConfiguration;
import de.seetec.v5.re.cm.shared.communication.MDBWriter;
import de.seetec.v5.re.cm.shared.communication.MDBWriterFactory;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.NamedThreadFactory;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DatabaseWriterRepository
implements DatabaseWriter,
ConfigurationProviderListener {
    private final AtomicBoolean reinitializeMirroredMdbRunning;
    private final MDBWriter mdbWriter;
    private FailoverConfiguration failoverConfiguration;
    private MDBWriter mirroredMdbWriter = null;
    private MDBWriterFactory mdbWriterFactory;
    private ConfigurationProvider configurationProvider;
    private Logger logger;
    private ScheduledExecutorService scheduledExecutorService;

    public DatabaseWriterRepository(ConfigurationProvider configurationProvider, MDBWriterFactory mdbWriterFactory) throws SeeTecException, ConfigurationException {
        if (configurationProvider == null) {
            throw new SeeTecException(-20002, "ConfigurationProvider null");
        }
        if (mdbWriterFactory == null) {
            throw new SeeTecException(-20002, "MDBWriterFactory null");
        }
        this.logger = LogManager.getLogger((String)this.getClass().getName());
        this.reinitializeMirroredMdbRunning = new AtomicBoolean();
        this.mdbWriterFactory = mdbWriterFactory;
        this.configurationProvider = configurationProvider;
        this.configurationProvider.register(this);
        this.mdbWriter = mdbWriterFactory.getInstance(0);
        this.failoverConfiguration = new FailoverConfiguration(configurationProvider.getDMConfigurationFromDatabase());
        if (this.failoverConfiguration.isMirroredRecordingActivated()) {
            this.mirroredMdbWriter = mdbWriterFactory.getInstance(1);
        }
    }

    @Override
    public void init() {
        this.mdbWriter.init();
        if (this.mirroredMdbWriter != null) {
            try {
                this.mirroredMdbWriter.init();
            }
            catch (Throwable throwable) {
                this.logger.info("Unable to inititalize mirrored MDBWriter [" + throwable.getMessage() + "] for " + this);
                this.startReinitializeMirroredMdbThread();
            }
        }
    }

    @Override
    public void changeAdditionalRecordingMode(boolean alarmRecordingActive) {
        this.mdbWriter.changeAdditionalRecordingMode(alarmRecordingActive);
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.changeAdditionalRecordingMode(alarmRecordingActive);
        }
    }

    @Override
    public int changeRecordingMode(int recordingMode) {
        int firstResult = this.mdbWriter.changeRecordingMode(recordingMode);
        int secondResult = 0;
        if (this.isMirroredRecordingReady()) {
            secondResult = this.mirroredMdbWriter.changeRecordingMode(recordingMode);
        }
        return this.createCumulatedResult(firstResult, secondResult);
    }

    @Override
    public int changeRecordingMode(int recordingMode, long preAlarmTimerange, long preAlarmFPS, boolean alarmRecordingActive, boolean forceRecalculationPreAlarm) {
        int firstResult = this.mdbWriter.changeRecordingMode(recordingMode, preAlarmTimerange, preAlarmFPS, alarmRecordingActive, forceRecalculationPreAlarm);
        int secondResult = 0;
        if (this.isMirroredRecordingReady()) {
            secondResult = this.mirroredMdbWriter.changeRecordingMode(recordingMode, preAlarmTimerange, preAlarmFPS, alarmRecordingActive, forceRecalculationPreAlarm);
        }
        return this.createCumulatedResult(firstResult, secondResult);
    }

    @Override
    public void deliverFrameToArchive(ContentFrame contentFrame, boolean hasRTPTimestamp) {
        this.mdbWriter.deliverFrameToArchive((ContentFrame)contentFrame.clone(), hasRTPTimestamp);
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.deliverFrameToArchive(contentFrame, hasRTPTimestamp);
        }
    }

    @Override
    public int deliverFrameToArchiveImmediately(ContentFrame contentFrame) {
        int firstResult = this.mdbWriter.deliverFrameToArchiveImmediately((ContentFrame)contentFrame.clone());
        int secondResult = 0;
        if (this.isMirroredRecordingReady()) {
            secondResult = this.mirroredMdbWriter.deliverFrameToArchiveImmediately(contentFrame);
        }
        return this.createCumulatedResult(firstResult, secondResult);
    }

    @Override
    public void finalizeCurrentSequence() {
        this.mdbWriter.finalizeCurrentSequence();
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.finalizeCurrentSequence();
        }
    }

    @Override
    public void flushRecordingQueue() {
        this.mdbWriter.flushRecordingQueue();
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.flushRecordingQueue();
        }
    }

    @Override
    public void flushRecordingQueue(Long requestTimestamp) {
        this.mdbWriter.flushRecordingQueue(requestTimestamp);
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.flushRecordingQueue(requestTimestamp);
        }
    }

    @Override
    public boolean isShutdown() {
        boolean firstResult = this.mdbWriter.isShutdown();
        if (this.failoverConfiguration.isMirroredRecordingActivated() && this.mirroredMdbWriter.isShutdown() && !this.mdbWriter.isShutdown()) {
            this.startReinitializeMirroredMdbThread();
        }
        return firstResult;
    }

    @Override
    public void setAlarmRecFramerate(long framerate) {
        this.mdbWriter.setAlarmRecFramerate(framerate);
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.setAlarmRecFramerate(framerate);
        }
    }

    @Override
    public void setupLocalStorage(Integer track) {
        this.mdbWriter.setupLocalStorage(track);
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.setupLocalStorage(track);
        }
    }

    @Override
    public int shutdown() {
        int firstResult = this.mdbWriter.shutdown();
        int secondResult = 0;
        if (this.isMirroredRecordingReady()) {
            secondResult = this.mirroredMdbWriter.shutdown();
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
        return this.createCumulatedResult(firstResult, secondResult);
    }

    @Override
    public void writeFtpOrMailExport(AlarmScenario alarmScenario, long alarmStart, long alarmStop) {
        this.mdbWriter.writeFtpOrMailExport(alarmScenario, alarmStart, alarmStop);
        if (this.isMirroredRecordingReady()) {
            this.mirroredMdbWriter.writeFtpOrMailExport(alarmScenario, alarmStart, alarmStop);
        }
    }

    @Override
    public void configurationFromDatabaseChanged(long changedID) {
        try {
            if (changedID == this.configurationProvider.getDMConfigurationFromFile().getEntityID()) {
                FailoverConfiguration previousFailoverConfiguration = this.failoverConfiguration;
                this.failoverConfiguration = new FailoverConfiguration(this.configurationProvider.getDMConfigurationFromDatabase());
                if (this.failoverConfiguration.isMirroredRecordingActivated()) {
                    if (this.mirroredMdbWriter == null && !this.reinitializeMirroredMdbRunning.get()) {
                        this.logger.info("Configuration changed. Enabling mirrored recording for " + this);
                        this.startReinitializeMirroredMdbThread();
                    } else if (this.failoverConfiguration.isFailoverChanged(previousFailoverConfiguration)) {
                        this.logger.info("Configuration changed. Mirrored mds changed for " + this);
                        this.mirroredMdbWriter.shutdown();
                    }
                } else if (previousFailoverConfiguration.isMirroredRecordingActivated()) {
                    this.logger.info("Configuration changed. Disabling mirrored recording for " + this);
                    this.mirroredMdbWriter.shutdown();
                }
            }
        }
        catch (ConfigurationException | SeeTecException seeTecException) {
            this.logger.error("Error reading from configuration for " + this + "[" + seeTecException.getMessage() + "]");
        }
    }

    @Override
    public boolean isMirroredRecordingActivated() {
        return this.failoverConfiguration.isMirroredRecordingActivated();
    }

    public String toString() {
        String result = "DatabaseWriterRepository for " + this.mdbWriter.toString();
        if (this.failoverConfiguration.isMirroredRecordingActivated()) {
            result = result + " | " + this.failoverConfiguration.toString();
        }
        return result;
    }

    private int createCumulatedResult(int firstResult, int secondResult) {
        if (firstResult == 0 && secondResult != 0) {
            return secondResult;
        }
        if (firstResult != 0) {
            return firstResult;
        }
        return 0;
    }

    private void startReinitializeMirroredMdbThread() {
        Runnable reinitializeMdbTask = () -> {
            try {
                this.mirroredMdbWriter = this.reinitializeMirroredMdb();
                if (this.mirroredMdbWriter.isReady()) {
                    int recordingMode;
                    if (this.mdbWriter.isReady() && (recordingMode = this.mdbWriter.getRecentlySetRecordingmode()) != -1) {
                        this.logger.info("Syncing recording mode [" + recordingMode + "] for mirrored mdb for " + this);
                        this.mirroredMdbWriter.changeRecordingMode(recordingMode);
                    }
                    this.scheduledExecutorService.shutdown();
                    this.reinitializeMirroredMdbRunning.set(false);
                }
            }
            catch (Throwable throwable) {
                this.logger.warn("Initializing mirrored Mdb failed [" + throwable.getMessage() + "] for " + this);
            }
        };
        if ((this.mirroredMdbWriter == null || !this.mirroredMdbWriter.isReady()) && this.reinitializeMirroredMdbRunning.compareAndSet(false, true)) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("DatabaseWriterRepository"));
            this.scheduledExecutorService.scheduleAtFixedRate(reinitializeMdbTask, 0L, 5L, TimeUnit.SECONDS);
        }
    }

    private MDBWriter reinitializeMirroredMdb() throws SeeTecException {
        MDBWriter tempMdbWriter = this.mdbWriterFactory.getInstance(1);
        try {
            tempMdbWriter.init();
        }
        catch (Throwable ex) {
            tempMdbWriter.shutdown();
        }
        return tempMdbWriter;
    }

    private boolean isMirroredRecordingReady() {
        boolean isMirroredMdbWriterReady;
        boolean bl = isMirroredMdbWriterReady = this.mirroredMdbWriter != null && this.mirroredMdbWriter.isReady();
        if (!isMirroredMdbWriterReady && this.isReinitializeMirroredMdbThreadNotRunning()) {
            this.startReinitializeMirroredMdbThread();
        }
        return isMirroredMdbWriterReady;
    }

    private boolean isReinitializeMirroredMdbThreadNotRunning() {
        return this.failoverConfiguration.isMirroredRecordingActivated() && !this.reinitializeMirroredMdbRunning.get();
    }
}

