/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.shared.communication.ContentTransportQueue;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContentTransportQueueManager {
    private static final String CLASS_NAME = "ContentTransportQueueManager";
    private List<ContentTransportQueue> myCTQ = new Vector<ContentTransportQueue>();
    private final Object CTQSemaphore = new Object();
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());

    public int shutdown() {
        try {
            for (ContentTransportQueue ctq : this.myCTQ) {
                ctq.shutdown();
            }
            this.myCTQ.clear();
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentTransportQueue[] getQueues() {
        ContentTransportQueue[] myCopy;
        Object object = this.CTQSemaphore;
        synchronized (object) {
            myCopy = new ContentTransportQueue[this.myCTQ.size()];
            this.myCTQ.toArray(myCopy);
        }
        return myCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContentTransportQueue(ContentTransportQueue newQueue) {
        Object object = this.CTQSemaphore;
        synchronized (object) {
            Vector<ContentTransportQueue> newCTQ = new Vector<ContentTransportQueue>();
            for (ContentTransportQueue queue : this.myCTQ) {
                if (queue.isShutdown()) continue;
                if (queue.getSessionID() == newQueue.getSessionID()) {
                    this.logger.warn((Object)((Object)queue) + " already exists and will be changed with " + (Object)((Object)newQueue));
                    queue.shutdown();
                    continue;
                }
                newCTQ.add(queue);
            }
            newCTQ.add(newQueue);
            this.myCTQ = newCTQ;
        }
    }

    protected Long[] getContentTransportQueueStatistics() {
        try {
            LinkedList<Long> values = new LinkedList<Long>();
            long totalTime = 0L;
            long shortestTime = Long.MAX_VALUE;
            long longestTime = 0L;
            long averageTime = 0L;
            for (ContentTransportQueue ctq : this.getQueues()) {
                long ts = ctq.getTimeBasedLength();
                if (ts <= 0L) continue;
                values.add(ts);
            }
            for (Long value : values) {
                totalTime += value.longValue();
                if (value < shortestTime) {
                    shortestTime = value;
                }
                if (value <= longestTime) continue;
                longestTime = value;
            }
            if (values.size() > 0) {
                averageTime = totalTime / (long)values.size();
                return new Long[]{shortestTime, longestTime, averageTime};
            }
        }
        catch (Throwable t) {
            this.logger.warn("Trouble creating statistics for " + this);
        }
        return new Long[]{0L, 0L, 0L};
    }

    public String toString() {
        String sThis = "ContentTransportQueueManager@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", CTQ[" + this.myCTQ.size() + "]=" + this.myCTQ + "]";
    }
}

