/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.DeviceManagerStatistic;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;

public class ContentTransportQueueDeliveryStatistics {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.ContentTransportQueue.DeliveryStatistics";
    private int queueSize = -1;
    private boolean[] flag = null;
    private long[] ts = null;
    private int[] volume = null;
    private int[] mediatype = null;
    private int pointer = -1;
    private long allFramesSent = 0L;
    private long allDataSent = 0L;
    private long allFramesDiscarded = 0L;
    private long allDataDiscarded = 0L;
    private long datarateRatio = 100000L;
    private DeviceManagerStatistic deviceManagerStatistic;

    public ContentTransportQueueDeliveryStatistics(int queueSize, DeviceManagerStatistic deviceManagerStatistic) {
        this.queueSize = queueSize;
        this.flag = new boolean[this.queueSize];
        this.ts = new long[this.queueSize];
        this.volume = new int[this.queueSize];
        this.mediatype = new int[this.queueSize];
        this.deviceManagerStatistic = deviceManagerStatistic;
    }

    public long getDatarateRatio() {
        return this.datarateRatio;
    }

    public void setDatarateRatio(long datarateRatio) {
        if (datarateRatio < 0L) {
            throw new RuntimeException("Invalid argument [DatarateRatio]==[" + datarateRatio + "] for " + this);
        }
        if ((datarateRatio > this.datarateRatio * 11L / 10L || datarateRatio < this.datarateRatio * 9L / 10L) && this.pointer > 5) {
            int actualPointer;
            int fullVideoFrames = 0;
            for (int i = this.ts.length + this.pointer - 1; i > this.pointer && this.ts[actualPointer = i % this.ts.length] >= 0L; --i) {
                if (this.mediatype[actualPointer] == 33 || this.mediatype[actualPointer] == 0) {
                    ++fullVideoFrames;
                }
                if (fullVideoFrames <= 50 || Math.abs(this.ts[actualPointer] - System.currentTimeMillis()) <= 5000L) continue;
                this.ts[actualPointer] = -1L;
            }
        }
        this.datarateRatio = datarateRatio;
    }

    public void notifyFrameSent(long ts, int data, int mediatype) {
        ++this.allFramesSent;
        this.allDataSent += (long)data;
        ++this.pointer;
        this.flag[this.pointer % this.queueSize] = true;
        this.ts[this.pointer % this.queueSize] = ts;
        this.volume[this.pointer % this.queueSize] = data;
        this.mediatype[this.pointer % this.queueSize] = mediatype;
        if (mediatype != 65 && mediatype != 66) {
            this.deviceManagerStatistic.incrementClientFrames();
        }
    }

    public void notifyFrameDiscarded(long ts, int data, int mediatype) {
        this.deviceManagerStatistic.incrementDiscardedClientFrames();
        ++this.allFramesDiscarded;
        this.allDataDiscarded += (long)data;
        ++this.pointer;
        this.flag[this.pointer % this.queueSize] = false;
        this.ts[this.pointer % this.queueSize] = ts;
        this.volume[this.pointer % this.queueSize] = data;
        this.mediatype[this.pointer % this.queueSize] = mediatype;
    }

    public long getFullDatarate(long timerange) {
        long nVolume = 0L;
        for (int i = 0; i < this.ts.length; ++i) {
            if (this.ts[i] <= System.currentTimeMillis() - timerange) continue;
            nVolume += (long)this.volume[i];
        }
        return nVolume * 1000L / timerange;
    }

    public long getSendDatarate() {
        if (this.pointer < 1) {
            return 0L;
        }
        long tsOldestEntry = System.currentTimeMillis();
        long tsNewestEntry = 0L;
        long dataVolumeSent = 0L;
        for (int i = 0; i < this.ts.length; ++i) {
            if (this.ts[i] > 0L && this.ts[i] < tsOldestEntry) {
                tsOldestEntry = this.ts[i];
            }
            if (this.ts[i] > tsNewestEntry) {
                tsNewestEntry = this.ts[i];
            }
            if (!this.flag[i]) continue;
            dataVolumeSent += (long)this.volume[i];
        }
        if (tsNewestEntry - tsOldestEntry <= 0L) {
            return 0L;
        }
        return dataVolumeSent * 1000L / (tsNewestEntry - tsOldestEntry);
    }

    private long getTimebasedRatio(int videoFrames, long timerange, ContentFrame actualContentFrame) {
        if (this.pointer < 0) {
            return 0L;
        }
        int videoFrameCounter = 0;
        long dataVolumeSent = 0L;
        long dataVolumeDiscarded = 0L;
        if (actualContentFrame.getMediatype() == 33 || actualContentFrame.getMediatype() == 0) {
            ++videoFrameCounter;
        }
        for (int i = this.ts.length + this.pointer; i > this.pointer; --i) {
            int actualPointer = i % this.ts.length;
            if (this.ts[actualPointer] <= 0L) continue;
            if (this.flag[actualPointer]) {
                dataVolumeSent += (long)this.volume[actualPointer];
            } else {
                dataVolumeDiscarded += (long)this.volume[actualPointer];
            }
            if (this.mediatype[actualPointer] != 33 && this.mediatype[actualPointer] != 0 || ++videoFrameCounter < videoFrames || Math.abs(this.ts[actualPointer] - System.currentTimeMillis()) < timerange || dataVolumeSent <= (long)actualContentFrame.getData().length) continue;
            return (dataVolumeSent += (long)actualContentFrame.getData().length) * 100000L / (dataVolumeSent + dataVolumeDiscarded);
        }
        return 0L;
    }

    public long getShortRangeRatio(ContentFrame actualContentFrame) {
        return this.getTimebasedRatio(2, 0L, actualContentFrame);
    }

    public long getLongRangeRatio(ContentFrame actualContentFrame) {
        return this.getTimebasedRatio(20, 10000L, actualContentFrame);
    }

    public void resetRatioStatistics() {
        this.pointer = -1;
        this.flag = new boolean[this.queueSize];
        this.ts = new long[this.queueSize];
        this.volume = new int[this.queueSize];
        this.mediatype = new int[this.queueSize];
    }

    public void notifyForStoppedStreaming() {
        this.resetRatioStatistics();
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.ContentTransportQueue.DeliveryStatistics@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", SentFrames=[" + Basic.longToFormattedString((long)this.allFramesSent) + "], SentData=[" + Basic.longToFormattedString((long)(this.allDataSent >> 10)) + " KB], DiscardedFrames=[" + Basic.longToFormattedString((long)this.allFramesDiscarded) + "], DiscardedData=[" + Basic.longToFormattedString((long)(this.allDataDiscarded >> 10)) + " KB]]";
    }
}

