/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared.communication;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.shared.ContentStreamIntf;
import de.seetec.v5.re.cm.shared.communication.ContentTransportQueue;
import de.seetec.v5.re.shared.ContentFrame;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.InetAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContentStream
extends Basic
implements ContentStreamIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.communication.UDPContentStream";
    private Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Core core = null;
    private ContentTransportQueue contentTransportQueue = null;
    private boolean audioTransmission = true;

    @Override
    public final void init(Core core, InetAddress host, int port, long sessionId, String protocol, Long clientId) throws SeeTecException {
        this.core = core;
        if (this.core == null) {
            throw new RuntimeException("Implementation error: Paramter [Core] is [null]");
        }
        this.contentTransportQueue = clientId != null ? this.core.getNetworkClientHandler().createContentTransportQueue(clientId, sessionId, protocol) : this.core.getNetworkClientHandler().createContentTransportQueue(host, port, sessionId);
    }

    @Override
    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    @Override
    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.contentTransportQueue != null) {
            this.contentTransportQueue.shutdown();
            this.contentTransportQueue = null;
        }
        return 0;
    }

    @Override
    public int sendFrame(ContentFrame contentFrame, short transactionID) {
        return this.sendFrame(new ContentFrame[]{contentFrame}, transactionID);
    }

    @Override
    public int sendFrame(ContentFrame[] contentFrame, short transactionID) {
        return this.sendFrame(false, contentFrame, true, transactionID);
    }

    @Override
    public int sendFrame(boolean privileged, ContentFrame[] contentFrame, boolean isSingleFrameStreaming, short transactionID) {
        return this.sendFrame(privileged, contentFrame, isSingleFrameStreaming, transactionID, 0xC00000L);
    }

    @Override
    public int sendFrame(boolean privileged, ContentFrame[] contentFrame, boolean isSingleFrameStreaming, short transactionID, long maxVolume) {
        if (this.contentTransportQueue == null || this.contentTransportQueue.isShutdown()) {
            this.shutdown();
            return -21609;
        }
        return this.contentTransportQueue.putContentFrame(privileged, -1L, contentFrame, isSingleFrameStreaming, transactionID, this.audioTransmission, maxVolume);
    }

    @Override
    public int sendArchiveContentFrames(short transactionID, ContentFrame[] contentFrames, long reqFrom, long reqTo, boolean containsLastFrame) {
        if (this.contentTransportQueue == null || this.contentTransportQueue.isShutdown()) {
            this.shutdown();
            return -21609;
        }
        return this.contentTransportQueue.putArchiveFrames(transactionID, contentFrames, reqFrom, reqTo, containsLastFrame);
    }

    @Override
    public void setBandwidthLimitation(int bandwidthLimitation) {
        if (this.isShutdown()) {
            this.logger.warn(this + " is already shutting down!");
            return;
        }
        this.contentTransportQueue.setBandwidthLimitation(bandwidthLimitation);
    }

    @Override
    public void notifyForStoppedStreaming() {
        if (this.contentTransportQueue != null && !this.contentTransportQueue.isShutdown()) {
            this.contentTransportQueue.notifyForStoppedStreaming();
        }
    }

    @Override
    public void setAudioTransmission(boolean audioTransmission) {
        this.audioTransmission = audioTransmission;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.communication.UDPContentStream@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + (Object)((Object)this.contentTransportQueue) + ", AudioTransmission=[" + this.audioTransmission + "]]";
    }

    public ContentTransportQueue getContentTransportQueue() {
        return this.contentTransportQueue;
    }
}

