/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.shared.srpc.AbstractSrpcHandler;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.networking.srpc.DefaultRequestHandlerFactoryImpl;
import de.seetec.v5.shared.networking.srpc.ShutdownCallback;
import de.seetec.v5.shared.networking.srpc.SrpcClientIntf;
import de.seetec.v5.shared.networking.srpc.SrpcFactory;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerFactoryIntf;
import de.seetec.v5.shared.networking.srpc.SrpcRequestHandlerIntf;
import de.seetec.v5.shared.util.SeeTecException;
import java.net.Socket;

public final class VideoSrvSRPCConnector
extends Basic
implements ShutdownCallback {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.VideoSrvSRPCConnector";
    private final AbstractSrpcHandler srpcHandler;
    private final SrpcClientIntf nSrpc;

    public VideoSrvSRPCConnector(AbstractSrpcHandler srpcHandler, Socket socket) throws SeeTecException {
        this.srpcHandler = srpcHandler;
        if (this.srpcHandler == null) {
            throw new SeeTecException(-21601, "Mandatory argument null.");
        }
        if (socket == null) {
            throw new SeeTecException(-21601, "Mandatory argument null.");
        }
        try {
            socket.setSoTimeout(60000);
            this.nSrpc = SrpcFactory.getSrpc((Socket)socket, (SrpcRequestHandlerFactoryIntf)new DefaultRequestHandlerFactoryImpl((SrpcRequestHandlerIntf)this.srpcHandler), null, (ShutdownCallback)this, (boolean)false);
        }
        catch (Exception ex) {
            throw new SeeTecException(-20210, ex.getMessage());
        }
    }

    public final boolean isShutdown() {
        return this.isShutdown(CLASS_NAME);
    }

    public int shutdown() {
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.nSrpc != null) {
            this.nSrpc.shutdown();
        }
        if (this.srpcHandler != null) {
            this.srpcHandler.shutdown();
        }
        return 0;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.VideoSrvSRPCConnector@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", SRPC=" + this.nSrpc + "]";
    }

    public void sendFireAndForgetREQ(SrpcMessage msg) {
        this.nSrpc.sendFireAndForget(msg);
    }

    public void onShutdown() {
        this.shutdown();
    }
}

