/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Tools {
    private static final SimpleDateFormat SDF = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");

    public static Integer getNearestAllowedValue(List<Integer> allowedValues, Integer inputValue) {
        if (allowedValues == null || allowedValues.isEmpty()) {
            return null;
        }
        Integer result = allowedValues.get(0);
        Integer nearestDiff = Math.abs(result - inputValue);
        for (Integer toCheck : allowedValues) {
            if (toCheck.equals(inputValue)) {
                return toCheck;
            }
            if (Math.abs(toCheck - inputValue) >= nearestDiff) continue;
            result = toCheck;
            nearestDiff = Math.abs(toCheck - inputValue);
        }
        return result;
    }

    public static final int convertIFrameDistMStoFrameCount(long fps, long iFrameDistMS, int min, int max) {
        int iFrameDistFrameCount = (int)(fps * iFrameDistMS) / 1000000;
        iFrameDistFrameCount = iFrameDistFrameCount < min ? min : iFrameDistFrameCount;
        iFrameDistFrameCount = iFrameDistFrameCount > max ? max : iFrameDistFrameCount;
        return iFrameDistFrameCount;
    }

    public static ASPECTRATIO getNearestAspectRatio(int width, int height) {
        ASPECTRATIO result = height > 0 && Math.round((double)width / (double)height) <= 1L ? ASPECTRATIO.ASPECTRATIO_4_3 : ASPECTRATIO.ASPECTRATIO_16_9;
        return result;
    }

    public static final float convertToCameraValues(float[] allowedValues, float valueToConvert) {
        float result = -2.1474836E9f;
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] > valueToConvert) {
                if (i == 0) {
                    result = allowedValues[0];
                    break;
                }
                float middle = (allowedValues[i] + allowedValues[i - 1]) / 2.0f;
                result = valueToConvert > middle ? allowedValues[i] : allowedValues[i - 1];
                break;
            }
            result = i == allowedValues.length - 1 ? allowedValues[allowedValues.length - 1] : valueToConvert;
        }
        return result;
    }

    public static final long convertToCameraValues(long[] allowedValues, long valueToConvert) {
        long result = Integer.MIN_VALUE;
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] > valueToConvert) {
                if (i == 0) {
                    result = allowedValues[0];
                    break;
                }
                long middle = (allowedValues[i] + allowedValues[i - 1]) / 2L;
                result = valueToConvert > middle ? allowedValues[i] : allowedValues[i - 1];
                break;
            }
            result = i == allowedValues.length - 1 ? allowedValues[allowedValues.length - 1] : valueToConvert;
        }
        return result;
    }

    public static void parseParameters(Map<String, String> cameraParameters, String parameters) {
        if (parameters == null) {
            return;
        }
        for (String parameter : parameters.split("\\r?\\n")) {
            String[] split = parameter.split("=");
            if (split.length != 2) continue;
            cameraParameters.put(split[0], split[1].replaceAll("\"", ""));
        }
    }

    public static final int convertToCameraValues(int[] allowedValues, int valueToConvert) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < allowedValues.length; ++i) {
            if (allowedValues[i] > valueToConvert) {
                if (i == 0) {
                    result = allowedValues[0];
                    break;
                }
                int middle = (allowedValues[i] + allowedValues[i - 1]) / 2;
                result = valueToConvert > middle ? allowedValues[i] : allowedValues[i - 1];
                break;
            }
            result = i == allowedValues.length - 1 ? allowedValues[allowedValues.length - 1] : valueToConvert;
        }
        return result;
    }

    public static long getMilliSecondsSinceYear(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    public static final float round(float value) {
        if (value == 0.0f) {
            return 0.0f;
        }
        if (value > 0.0f) {
            return Math.round(value);
        }
        if (value < 0.0f) {
            return Math.round(value * -1.0f) * -1;
        }
        return 0.0f;
    }

    public static final int random(int min, int max) {
        int random = (int)(Math.random() * (double)(max - min + 1)) + min;
        if (random < min) {
            return min;
        }
        if (random > max) {
            return max;
        }
        return random;
    }

    public static final String convertDoubleToString(double value, Locale locale) {
        return new DecimalFormat("0.#####", DecimalFormatSymbols.getInstance(locale)).format(value);
    }

    public static final String formateTimestamp(long timestamp) {
        return String.format("%d (%s)", timestamp, SDF.format(timestamp));
    }

    public static final int[] convertArrayToIntArray(float[] arrayToConvert) {
        if (arrayToConvert == null) {
            return new int[0];
        }
        int[] returnArray = new int[arrayToConvert.length];
        for (int i = 0; i < arrayToConvert.length; ++i) {
            returnArray[i] = Math.round(arrayToConvert[i]);
        }
        return returnArray;
    }

    public static final String collectionJoin(Collection<String> collection, String delimiter) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException();
        }
        StringBuilder result = new StringBuilder();
        for (String element : collection) {
            if (result.length() > 0) {
                result.append(delimiter);
            }
            result.append(element);
        }
        return result.toString();
    }

    public static enum ASPECTRATIO {
        ASPECTRATIO_4_3,
        ASPECTRATIO_16_9,
        ASPECTRATIO_OTHER;

    }
}

