/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.TimeRangeResult;
import de.seetec.v5.re.cm.configuration.definition.device.DeviceDefinition;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.VideoSrv;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxy;
import de.seetec.v5.re.cm.shared.communication.DatabaseProxyListener;
import de.seetec.v5.re.cm.shared.srpc.RspGetFrameStatistic;
import de.seetec.v5.re.shared.DeviceCnf;
import de.seetec.v5.re.shared.VideoSourceCnf;
import de.seetec.v5.re.shared.VideoSourceParameter;
import de.seetec.v5.re.shared.srpc.RspGetCameraRecordingStatistics;
import de.seetec.v5.re.shared.timerange.TimeRangeInfo;
import de.seetec.v5.re.shared.timerange.TimeRangeInfoContainer;
import de.seetec.v5.re.shared.timerange.TimeRangeList;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.configuration.camerarecordingstatistic.CameraRecordingStatistic;
import de.seetec.v5.shared.configuration.camerarecordingstatistic.ContentStatistic;
import de.seetec.v5.shared.configuration.camerarecordingstatistic.Contents;
import de.seetec.v5.shared.configuration.camerarecordingstatistic.TrackStatistic;
import de.seetec.v5.shared.proxy.ent.Entity;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class RecordingStatistic {
    private final Core core;
    private final Logger logger;

    public RecordingStatistic(Core myCore) {
        this.core = myCore;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public RspGetCameraRecordingStatistics getCameraRecordingStatistics(RspGetCameraRecordingStatistics response, Long granularity) throws SeeTecException, JDOMException, SAXException, JAXBException {
        long duration = System.currentTimeMillis();
        int resultCode = this.getCameraRecordingStatisticsFromDefaultDBProxy(response, granularity);
        this.logger.debug("Duration for reading recording statistics from MDS: " + (System.currentTimeMillis() - duration));
        duration = System.currentTimeMillis();
        if (resultCode == 0) {
            CameraRecordingStatistic cameraRecordingStatistic = (CameraRecordingStatistic)Basic.unmarshalXML(CameraRecordingStatistic.class, (Object)response.getCameraRecordingStatistics());
            Contents contents = cameraRecordingStatistic.getContents();
            List contentStatisticList = contents.getContent();
            long timeStampNow = System.currentTimeMillis();
            HashMap<Long, RspGetFrameStatistic> fullDerbyStatistic = this.core.getFrameStatistic().readStatistic(timeStampNow - granularity);
            this.logger.debug("Duration for reading statistics from local derby: " + (System.currentTimeMillis() - duration));
            duration = System.currentTimeMillis();
            for (ContentStatistic contentStatistic : contentStatisticList) {
                this.addStaticContentStatisticInformation(contentStatistic);
                this.setVideoInformation(contentStatistic, timeStampNow - granularity, timeStampNow, (RspGetFrameStatistic)fullDerbyStatistic.get(contentStatistic.getCameraSourceID()));
            }
            cameraRecordingStatistic.setContents(contents);
            this.logger.debug("Duration for setVideoInformation: " + (System.currentTimeMillis() - duration));
            try {
                response = new RspGetCameraRecordingStatistics(Integer.valueOf(resultCode), Basic.marshalUTF8XML((Object)cameraRecordingStatistic).getBytes());
            }
            catch (FileNotFoundException | JAXBException | SAXException exception) {
                this.logger.error("Could not marshal cameraRecordingStatistic [" + exception.getMessage() + "]");
            }
        }
        return response;
    }

    private ContentStatistic addStaticContentStatisticInformation(ContentStatistic contentStatistic) {
        if (contentStatistic == null) {
            return null;
        }
        long videoSourceID = contentStatistic.getCameraSourceID();
        Entity videoSourceEntity = this.core.getEntityByID(videoSourceID);
        if (videoSourceEntity == null) {
            this.logger.error("Not possible to fetch information for ID = " + videoSourceID);
            return contentStatistic;
        }
        contentStatistic.setCameraName(videoSourceEntity.getEntityName());
        contentStatistic.setCameraModel(videoSourceEntity.getEntityType());
        Entity videoServerEntity = this.core.getEntityByID(videoSourceEntity.getPhysicalParent());
        if (videoServerEntity == null) {
            this.logger.error("Not possible to fetch information for device of source  = " + videoSourceID + "/" + videoSourceEntity.getEntityName());
            return contentStatistic;
        }
        try {
            contentStatistic.setStatusOfRecording(Integer.valueOf(videoServerEntity.isEnabled() != false ? videoSourceEntity.getStatus() : -1));
        }
        catch (Exception exception) {
            contentStatistic.setStatusOfRecording(Integer.valueOf(-1));
        }
        DeviceCnf deviceCnf = new DeviceCnf(null);
        if (deviceCnf.init(videoServerEntity.getConfiguration()) != 0) {
            this.logger.error("Not possible to read information for device of source  = " + videoSourceID + "/" + videoSourceEntity.getEntityName());
            return contentStatistic;
        }
        try {
            contentStatistic.setCameraIP(deviceCnf.getHardwareHost());
        }
        catch (ConfigurationException configurationException) {
            this.logger.info("Not possible to extract host information for " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + configurationException.getMessage());
        }
        try {
            Element root = deviceCnf.getDocument().getRootElement();
            String deviceDefinitionName = "DeviceDefinition";
            DeviceDefinition deviceDefinitionFromConfiguration = Device.unmarshalDefinition(root.getChild(deviceDefinitionName), DeviceDefinition.class);
            contentStatistic.setCameraFirmware(deviceDefinitionFromConfiguration.getSignature());
            contentStatistic.setCameraManufacturer(deviceDefinitionFromConfiguration.getManufacturer());
            contentStatistic.setCameraModelName(deviceDefinitionFromConfiguration.getName());
        }
        catch (SeeTecException seetecException) {
            this.logger.debug("Not possible to extract some information for static driver " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + seetecException.getMessage());
        }
        this.setTracksInformation(videoSourceEntity, contentStatistic, videoSourceID);
        return contentStatistic;
    }

    private void setTracksInformation(Entity videoSourceEntity, ContentStatistic contentStatistic, long videoSourceID) {
        VideoSourceParameter standardVideoSourceParameter = new VideoSourceParameter();
        standardVideoSourceParameter.init(videoSourceEntity, null, "Standard");
        this.initialieStandardTrack(contentStatistic);
        try {
            this.setTrackInformation(contentStatistic.getStandardTrack(), standardVideoSourceParameter);
        }
        catch (ConfigurationException configurationException) {
            this.logger.info("Not possible to extract some standard recording information for " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + configurationException.getMessage());
        }
        this.initialieAlarmTrack(contentStatistic);
        try {
            this.setAlarmTrackInformation(videoSourceEntity, contentStatistic);
        }
        catch (ConfigurationException configurationException) {
            this.logger.info("Not possible to extract some alarm recording information for " + videoSourceID + "/" + videoSourceEntity.getEntityName() + ". Message: " + configurationException.getMessage());
        }
    }

    private void setAlarmTrackInformation(Entity videoSourceEntity, ContentStatistic contentStatistic) throws ConfigurationException {
        VideoSourceCnf videoSourceCnf = new VideoSourceCnf();
        if (videoSourceCnf.init(videoSourceEntity) == 0) {
            VideoSourceParameter alarmVideoSourceParameter = new VideoSourceParameter();
            int alarmRecordingStreamIndex = videoSourceCnf.getAlarmRecordingStreamIndex();
            if (alarmRecordingStreamIndex != 0) {
                String alarmRecordingProfileName = VideoSourceParameter.getAdditionalVideoProfiles((byte[])videoSourceEntity.getConfiguration())[--alarmRecordingStreamIndex];
                this.logger.info("Stream to use for alarm recording: " + alarmRecordingProfileName);
                alarmVideoSourceParameter.init(videoSourceEntity, alarmRecordingProfileName, null);
            } else {
                alarmVideoSourceParameter.init(videoSourceEntity, null, "Alarm");
            }
            this.setTrackInformation(contentStatistic.getAlarmTrack(), alarmVideoSourceParameter);
        }
    }

    private void initialieAlarmTrack(ContentStatistic contentStatistic) {
        if (contentStatistic.getAlarmTrack() == null) {
            contentStatistic.setAlarmTrack(new TrackStatistic());
        }
    }

    private void initialieStandardTrack(ContentStatistic contentStatistic) {
        if (contentStatistic.getStandardTrack() == null) {
            contentStatistic.setStandardTrack(new TrackStatistic());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCameraRecordingStatisticsFromDefaultDBProxy(RspGetCameraRecordingStatistics response, Long granularity) {
        DatabaseProxy databaseProxy = null;
        int resultCode = 0;
        try {
            databaseProxy = this.core.createDatabaseProxy((DatabaseProxyListener)null, 0);
            databaseProxy.getCameraRecordingStatistics(response, granularity);
            resultCode = response.getResultCode();
        }
        catch (ConfigurationException | SeeTecException | JDOMException exception) {
            this.logger.error("Could not get Camera Recording Statistics from MDS [" + exception.getMessage() + "]");
            resultCode = -20001;
        }
        finally {
            if (databaseProxy != null) {
                databaseProxy.shutdown();
            }
        }
        return resultCode;
    }

    private ContentStatistic setVideoInformation(ContentStatistic contentStatistic, long since, long till, RspGetFrameStatistic derbyStatisticForOneVideoSource) {
        VideoSrv videoSrv = null;
        try {
            videoSrv = (VideoSrv)this.core.getDeviceLifeCycleInformation().getService(contentStatistic.getCameraSourceID());
        }
        catch (Exception ex) {
            this.logger.info("No VideoSrv registered for videoSourceID [" + contentStatistic.getCameraSourceID() + "]");
        }
        if (videoSrv != null) {
            TimeRangeResult timeRangeResult = this.getTimeRangeInfomation(videoSrv, since, till);
            RspGetFrameStatistic derbyStatistic = derbyStatisticForOneVideoSource == null ? new RspGetFrameStatistic(0) : derbyStatisticForOneVideoSource;
            contentStatistic.setPacketLossRatio(Long.valueOf(derbyStatistic.getDataPacketLossRatio()));
            int videoFramesStandardStoredAll = derbyStatistic.getVideoFramesStandardStored();
            long standardTimeRangeDerby = derbyStatistic.getStandardTimerange();
            int videoFramesAlarmStoredAll = derbyStatistic.getVideoFramesAlarmStored();
            long alarmTimeRangeDerby = derbyStatistic.getAlarmTimerange();
            int videoFramesPreAlarmStoredAll = derbyStatistic.getVideoFramesPreAlarmStored();
            TrackStatistic standardTrack = contentStatistic.getStandardTrack();
            standardTrack.setAmountOfDroppedFrames((long)derbyStatistic.getVideoFramesStandardDroppped());
            standardTrack.setAmountOfFrames((long)videoFramesStandardStoredAll);
            standardTrack.setVideoFramerate(Long.valueOf(this.calculateFPS(videoFramesStandardStoredAll, standardTimeRangeDerby)));
            standardTrack.setVideoBitrate(Long.valueOf(this.calculateBitrate(derbyStatistic.getDataStandardReceived(), standardTimeRangeDerby)));
            standardTrack.setActualTimerange(timeRangeResult.getTimeRangeStandard());
            TrackStatistic alarmTrack = contentStatistic.getAlarmTrack();
            alarmTrack.setAmountOfDroppedFrames((long)derbyStatistic.getVideoFramesAlarmDroppped());
            alarmTrack.setAmountOfFrames((long)videoFramesAlarmStoredAll);
            alarmTrack.setVideoFramerate(Long.valueOf(this.calculateFPS(videoFramesAlarmStoredAll, alarmTimeRangeDerby)));
            alarmTrack.setVideoBitrate(Long.valueOf(this.calculateBitrate(derbyStatistic.getDataAlarmReceived(), alarmTimeRangeDerby)));
            alarmTrack.setActualTimerange(timeRangeResult.getTimeRangeAlarm());
            TrackStatistic preAlarmTrack = new TrackStatistic();
            preAlarmTrack.setAmountOfDroppedFrames((long)derbyStatistic.getVideoFramesPreAlarmDroppped());
            preAlarmTrack.setAmountOfFrames((long)videoFramesPreAlarmStoredAll);
            preAlarmTrack.setVideoFramerate(Long.valueOf(this.calculateFPS(videoFramesPreAlarmStoredAll, derbyStatistic.getPreAlarmTimerange())));
            contentStatistic.setPreAlarmTrack(preAlarmTrack);
        }
        return contentStatistic;
    }

    private TimeRangeResult getTimeRangeInfomation(VideoSrv videoSrv, long since, long till) {
        TimeRangeInfoContainer recordingInfos = videoSrv.getRecordingInfos(this.core.getCayugaToken());
        TimeRangeList timeRangeInfoList = recordingInfos.getTimeRangeList();
        TimeRangeList timeRangeInfoForTimerange = timeRangeInfoList.getTimeRangeInfoForTimerange(Long.valueOf(since), Long.valueOf(till), Integer.valueOf(-1));
        return this.sumTimeRanges(timeRangeInfoForTimerange);
    }

    private long calculateFPS(int framesStored, long timeRange) {
        long milliFps = 0L;
        if (timeRange > 1000L) {
            milliFps = (long)framesStored * 1000L / (timeRange / 1000L);
        }
        return milliFps;
    }

    private long calculateBitrate(long dataReceived, long timeRange) {
        long bitrate = 0L;
        if (timeRange > 1000L) {
            bitrate = dataReceived / (timeRange / 1000L);
        }
        return bitrate;
    }

    protected TimeRangeResult sumTimeRanges(TimeRangeList timeRangeInfoForTimerange) {
        TimeRangeResult timeRangeResult = new TimeRangeResult();
        for (TimeRangeInfo timeRangeInfo : timeRangeInfoForTimerange) {
            if (timeRangeInfo.isFailover()) continue;
            if (timeRangeInfo.isAlarmTrack()) {
                timeRangeResult.increaseTimeRangeAlarm(timeRangeInfo.getLength());
                continue;
            }
            timeRangeResult.increaseTimeRangeStandard(timeRangeInfo.getLength());
        }
        return timeRangeResult;
    }

    private void setTrackInformation(TrackStatistic track, VideoSourceParameter videoSourceParameter) throws ConfigurationException {
        track.setExpectedCodec(Integer.valueOf(videoSourceParameter.getMediaCodec().getType()));
        try {
            track.setExpectedWidth(Integer.valueOf(videoSourceParameter.getImageSize()[0]));
            track.setExpectedHeight(Integer.valueOf(videoSourceParameter.getImageSize()[1]));
        }
        catch (Exception exception) {
            this.logger.info("Unable to read resolution for recording info for" + videoSourceParameter.getEntity().toString() + " [" + exception.getMessage() + "]");
        }
        if (videoSourceParameter.getBandwidthControl() == 1) {
            track.setExpectedVideoBitrate(Long.valueOf(videoSourceParameter.getBandWidth()));
        } else if (videoSourceParameter.getBandwidthControl() == 0) {
            track.setExpectedVideoBitrate(Long.valueOf(-2L));
        }
        track.setExpectedVideoFramerate(Long.valueOf(videoSourceParameter.getFramerate()));
    }
}

