/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.cm.device.shared.io.IOHandler;
import de.seetec.v5.re.cm.shared.IOSRPCConnector;
import de.seetec.v5.re.cm.shared.srpc.ReqTriggerAction;
import de.seetec.v5.re.shared.srpc.AbstractSrpcHandler;
import de.seetec.v5.shared.TimeHelper;
import de.seetec.v5.shared.networking.srpc.Methods;
import de.seetec.v5.shared.networking.srpc.RequestHandlerCallback;
import de.seetec.v5.shared.networking.srpc.SrpcMessage;
import java.net.Socket;

public class IoClientRequestHandler
extends AbstractSrpcHandler {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.IoClientRequestHandler";
    private IOHandler ioHandler = null;
    private IOSRPCConnector srpcConnector = null;
    private final long tsStartup = System.currentTimeMillis();
    private String clientHost = null;
    private Integer clientPort = null;

    public int init(IOHandler ioHandler, Socket socket) {
        this.ioHandler = ioHandler;
        if (this.ioHandler == null) {
            return -21601;
        }
        this.clientHost = socket.getInetAddress().getHostAddress();
        this.clientPort = socket.getPort();
        try {
            this.srpcConnector = new IOSRPCConnector();
            int errorCode = this.srpcConnector.init(this, socket);
            if (errorCode != 0) {
                this.logger.error("Initializing new connector with socket [" + socket + "] failed with error [" + errorCode + "]");
                return errorCode;
            }
        }
        catch (Exception ex) {
            this.logger.error("Creating new connector with socket [" + socket + "]", (Throwable)ex);
            return -21604;
        }
        this.thread = new Thread((Runnable)((Object)this), this.toString());
        this.thread.start();
        return 0;
    }

    public int shutdown() {
        int errorCode;
        if (this.startShutdown(CLASS_NAME)) {
            return 0;
        }
        if (this.thread != null) {
            long timeout = System.currentTimeMillis() + 30000L;
            while (!super.isRunFinished(CLASS_NAME)) {
                if (System.currentTimeMillis() > timeout) {
                    this.logger.warn("Thread of " + (Object)((Object)this) + " didn't finished in time");
                    break;
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.thread = null;
        }
        if (this.srpcConnector != null) {
            errorCode = this.srpcConnector.shutdown();
            if (errorCode != 0) {
                this.logger.warn("Shutting down connector [" + (Object)((Object)this.srpcConnector) + "] failed with error [" + errorCode + "]");
            }
            this.srpcConnector = null;
        }
        errorCode = super.shutdown();
        this.logger.info("... " + (Object)((Object)this) + " is down");
        return errorCode;
    }

    public void onError(int srpcErrorCode) {
        this.logger.error("SRPC error [" + srpcErrorCode + "] occured. Shutting down " + (Object)((Object)this) + " ...");
        this.shutdown();
    }

    public void run() {
        super.setRunFinished(CLASS_NAME, false);
        long tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
        try {
            while (true) {
                SrpcMessage req;
                if (this.ioHandler == null || this.ioHandler.isShutdown()) {
                    super.stopHandler();
                    break;
                }
                if (tsNextStillAliveMsg < System.currentTimeMillis()) {
                    tsNextStillAliveMsg = System.currentTimeMillis() + 60000L;
                    this.logger.info("Thread " + (Object)((Object)this) + " has an uptime of [" + TimeHelper.getReadableTimerange((long)this.getUptime()) + "]");
                }
                if (null != (req = this.getNextReq())) {
                    if (this.isShutdown(CLASS_NAME)) {
                        super.stopHandler();
                    }
                    RequestHandlerCallback callback = this.getCallback(req.getId());
                    switch (Methods.valueOf((int)req.getHash())) {
                        case ENT_FUNCTION_TRIGGER_ACTION: {
                            this.execTriggerAction(req, callback);
                        }
                    }
                }
                this.doDelayBreakedByShutdown(CLASS_NAME, 25L);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex, (Throwable)ex);
        }
        super.setRunFinished(CLASS_NAME, true);
        int errorCode = this.shutdown();
        if (errorCode != 0) {
            this.logger.error("[shutdown] failed with error [" + errorCode + "]");
        }
    }

    private void execTriggerAction(SrpcMessage req, RequestHandlerCallback rhc) {
        ReqTriggerAction goReq = ReqTriggerAction.parseGObject(req.getPayload());
        int errorCode = this.ioHandler.triggerAction(goReq.getActionID(), goReq.getAlarmScriptID(), goReq.getAlarmInstanceID(), goReq.getAlarmTimerange(), goReq.getGenericData());
        if (errorCode != 0) {
            this.logger.warn("Triggering action failed with error [" + errorCode + "]");
        }
        SrpcMessage rsp = SrpcMessage.createResponse((SrpcMessage)req, null);
        rsp.setError(errorCode);
        rhc.onRequestHandled(req, rsp);
    }

    private long getUptime() {
        return System.currentTimeMillis() - this.tsStartup;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.IoClientRequestHandler@" + Integer.toHexString(((Object)((Object)this)).hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", Socket=[" + this.clientHost + ":" + this.clientPort + "]]";
    }
}

