/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.shared;

import de.seetec.v5.re.shared.ConfigurationManager;
import de.seetec.v5.shared.proxy.ent.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AlarmScenario {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.shared.AlarmScenario";
    private final Logger logger = LogManager.getLogger((String)this.getClass().getName());
    private Entity entity = null;
    private int preAlarmTime = -1;
    private int duration = -1;

    public int init(Entity entity) {
        this.entity = entity;
        if (this.entity == null) {
            return -21601;
        }
        try {
            ConfigurationManager alarmScenarioCfgMgr = new ConfigurationManager();
            alarmScenarioCfgMgr.init(entity.getConfiguration());
            try {
                this.preAlarmTime = alarmScenarioCfgMgr.getRootElement().getChild("PreAlarm").getAsInt4();
            }
            catch (Throwable ex) {
                this.logger.warn("Problems parsing " + entity + " for [PreAlarm] ...");
            }
            try {
                this.duration = alarmScenarioCfgMgr.getRootElement().getChild("Duration").getAsInt4();
            }
            catch (Throwable ex) {
                this.logger.warn("Problems parsing " + entity + " for [Duration] ...");
            }
        }
        catch (Throwable ex) {
            this.logger.warn((Object)ex, ex);
        }
        return 0;
    }

    public long getAlarmScenarioID() {
        return this.entity.getEntityID();
    }

    public int getPreAlarmTime() {
        return this.preAlarmTime;
    }

    public String toString() {
        String sThis = "de.seetec.v5.re.cm.shared.AlarmScenario@" + Integer.toHexString(this.hashCode());
        return "[" + sThis.substring(sThis.lastIndexOf(46) + 1) + ", " + this.entity + "], PreAlarmTime=[" + this.preAlarmTime + "], Duration=[" + this.duration + "]]";
    }
}

