/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.filesystemwatcher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;

public class JpegFileCreationDateFilter
implements FilenameFilter {
    private final long lastTimestamp;

    public JpegFileCreationDateFilter(long lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
    }

    private boolean isJpeg(String name) {
        String[] parts = name.split("\\.");
        if (parts.length < 2) {
            return false;
        }
        int lastPart = parts.length - 1;
        String extension = parts[lastPart].toLowerCase();
        return extension.equals("jpeg") || extension.equals("jpg");
    }

    @Override
    public boolean accept(File dir, String name) {
        if (name != null && this.isJpeg(name)) {
            Path path = Paths.get(dir.getPath() + "\\" + name, new String[0]);
            try {
                BasicFileAttributes attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                FileTime creationTime = attributes.creationTime();
                boolean result = creationTime.toMillis() >= this.lastTimestamp;
                return result;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return false;
    }
}

