/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.filesystemwatcher;

import de.seetec.v5.re.cm.filesystemwatcher.FileSystemListener;
import de.seetec.v5.re.cm.filesystemwatcher.FileSystemWatcherLegacy;
import de.seetec.v5.re.cm.filesystemwatcher.FileSystemWatcherServerIntf;
import de.seetec.v5.re.cm.filesystemwatcher.JpegFileSystemWatcherBase;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileSystemWatcherServer
implements FileSystemWatcherServerIntf {
    private static final int LOCK_TIMEOUT = 20;
    private final Logger logger;
    private final Map<Path, Map<FileSystemListener, String>> actionListener = new HashMap<Path, Map<FileSystemListener, String>>();
    private final Map<Path, JpegFileSystemWatcherBase> watcher = new HashMap<Path, JpegFileSystemWatcherBase>();
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AtomicInteger numberOfRegisteredListener = new AtomicInteger();

    public FileSystemWatcherServer() {
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    public int init() {
        return 0;
    }

    public int shutdown() {
        for (Map.Entry<Path, JpegFileSystemWatcherBase> singleWatcher : this.watcher.entrySet()) {
            singleWatcher.getValue().shutdown();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register(FileSystemListener listener, Path directory, String cameraAlias) throws InterruptedException {
        int errorCode = 0;
        if (listener == null || directory == null || cameraAlias == null) {
            return -20002;
        }
        if (!this.readWriteLock.writeLock().tryLock(20L, TimeUnit.SECONDS)) {
            this.logger.warn("Cannot aquire for register " + this);
            return -20000;
        }
        try {
            Map<FileSystemListener, String> directoryListener = this.actionListener.get(directory);
            if (directoryListener == null || directoryListener.isEmpty()) {
                directoryListener = new HashMap<FileSystemListener, String>();
                this.actionListener.put(directory, directoryListener);
                FileSystemWatcherLegacy fileSystemWatcher = new FileSystemWatcherLegacy();
                errorCode = ((JpegFileSystemWatcherBase)fileSystemWatcher).init(this, directory);
                if (errorCode != 0) {
                    this.logger.error("Error while creating FileSystemWatcher for " + directory);
                    int n = errorCode;
                    return n;
                }
                this.watcher.put(directory, fileSystemWatcher);
            }
            if (directoryListener.put(listener, cameraAlias) == null) {
                this.numberOfRegisteredListener.getAndIncrement();
            }
            int n = errorCode;
            return n;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public int getNumberOfRegisteredListener() {
        return this.numberOfRegisteredListener.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfDisctinctListener() throws InterruptedException {
        if (!this.readWriteLock.readLock().tryLock(20L, TimeUnit.SECONDS)) {
            this.logger.warn("Cannot acquire [lock] for " + this);
            return -20008;
        }
        try {
            HashMap result = new HashMap();
            for (Map<FileSystemListener, String> directoryListener : this.actionListener.values()) {
                for (FileSystemListener listener : directoryListener.keySet()) {
                    result.put(listener, null);
                }
            }
            int n = result.size();
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deregister(FileSystemListener listener, Path directory) throws InterruptedException {
        if (listener == null || directory == null) {
            return -20002;
        }
        if (!this.readWriteLock.writeLock().tryLock(20L, TimeUnit.SECONDS)) {
            this.logger.warn("Cannot aquire for deregister " + this);
            return -20000;
        }
        try {
            Map<FileSystemListener, String> directoryListener = null;
            directoryListener = this.actionListener.get(directory);
            if (directoryListener != null) {
                JpegFileSystemWatcherBase fileSystemWatcher;
                if (directoryListener.remove(listener) != null) {
                    this.numberOfRegisteredListener.getAndDecrement();
                }
                if (directoryListener.isEmpty() && (fileSystemWatcher = this.watcher.get(directory)) != null) {
                    fileSystemWatcher.shutdown();
                }
            }
            int n = 0;
            return n;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fileCreated(Path directory, Path file, byte[] content) throws InterruptedException {
        if (directory == null || file == null || content == null) {
            return -20002;
        }
        if (!this.readWriteLock.readLock().tryLock(20L, TimeUnit.SECONDS)) {
            this.logger.warn("Cannot acquire [lock] for " + this);
            return -20008;
        }
        try {
            Map<FileSystemListener, String> directoryListener = this.actionListener.get(directory);
            for (Map.Entry<FileSystemListener, String> entry : directoryListener.entrySet()) {
                if (entry.getValue() == null || entry.getValue().isEmpty() || !file.toString().startsWith(entry.getValue())) continue;
                entry.getKey().nofify(file, content);
            }
            int n = 0;
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int error(Path directory, Path file, int error, String description) throws InterruptedException {
        if (directory == null || file == null || description == null) {
            return -20002;
        }
        if (!this.readWriteLock.readLock().tryLock(20L, TimeUnit.SECONDS)) {
            this.logger.warn("Cannot acquire [lock] for " + this);
            return -20008;
        }
        try {
            Map<FileSystemListener, String> directoryListener = this.actionListener.get(directory);
            for (Map.Entry<FileSystemListener, String> entry : directoryListener.entrySet()) {
                if (entry.getValue() == null || !file.toString().startsWith(entry.getValue())) continue;
                entry.getKey().error(directory, error, description);
            }
            int n = 0;
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

