/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.filesystemwatcher;

import de.seetec.v5.re.cm.filesystemwatcher.FileSystemWatcherServerIntf;
import de.seetec.v5.re.cm.filesystemwatcher.JpegFileCreationDateFilter;
import de.seetec.v5.re.cm.filesystemwatcher.JpegFileSystemWatcherBase;
import de.seetec.v5.shared.util.NamedThreadFactory;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class FileSystemWatcherLegacy
extends JpegFileSystemWatcherBase {
    private static final long DEFAULT_TIME = 100L;
    private long lastTimestamp = System.currentTimeMillis();

    @Override
    public int init(FileSystemWatcherServerIntf fileSystemWatcherIntf, Path directoryOfInterest) {
        int errorCode = super.init(fileSystemWatcherIntf, directoryOfInterest);
        if (errorCode != 0) {
            return errorCode;
        }
        this.lastTimestamp = System.currentTimeMillis();
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("FileSystemWatcher for " + directoryOfInterest));
        ((ScheduledExecutorService)this.scheduler).scheduleWithFixedDelay(this, 0L, 100L, TimeUnit.MILLISECONDS);
        return 0;
    }

    @Override
    public void run() {
        try {
            String[] foundFiles = this.directoryOfInterest.toFile().list(new JpegFileCreationDateFilter(this.lastTimestamp));
            if (foundFiles != null && foundFiles.length > 0) {
                this.lastTimestamp = System.currentTimeMillis();
                for (String foundFile : foundFiles) {
                    try {
                        if (this.readFile(FileSystems.getDefault().getPath(this.directoryOfInterest + "\\" + foundFile, new String[0])) == 0) continue;
                        this.changeFileCreationTime(foundFile, this.lastTimestamp + 1L);
                    }
                    catch (IOException ioe) {
                        this.logger.debug("Error while manipulating creation time stamp of file: " + foundFile);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error while running:", t);
        }
    }
}

