/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart.sip;

import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageBusy;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageBye;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageInfo;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageOK;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageRinging;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipMessageUnauthorized;
import de.seetec.v5.shared.net.NetworkParameter;
import java.net.InetAddress;

public class SipMessage {
    protected String myUserID;
    protected String loopback = InetAddress.getLoopbackAddress().getHostAddress();
    protected String localTag;
    protected String remoteTag;
    protected NetworkParameter networkParameter;
    protected String branchID;
    protected int localPort;
    private String to;
    private String from;
    private String via;
    private String maxForwards;
    private String uriUserId;
    private String callID;
    private int contentLength;
    private String header;
    private String callIDLine;
    private String cseqLine;
    private int cSeq = 1;
    private int remotePort;
    private String localHost = InetAddress.getLoopbackAddress().getHostAddress();
    private String body = "";
    private String authenticationLine = "";
    private String command;
    private String cSeqCommand = "";

    SipMessage() {
    }

    SipMessage(NetworkParameter networkParameter) {
        this.networkParameter = networkParameter;
    }

    SipMessage(String response) {
        String[] headerLines;
        String[] headerAndBody = response.split("\r\n\r\n");
        this.header = headerAndBody[0];
        for (String headerLine : headerLines = this.header.split("\r\n")) {
            if (headerLine.toLowerCase().startsWith("to:")) {
                String[] toLineStrings = headerLine.split(";");
                if (toLineStrings.length <= 0 || !toLineStrings[1].contains("tag")) continue;
                this.remoteTag = toLineStrings[1].replace("tag=", "");
                continue;
            }
            if (headerLine.toLowerCase().startsWith("from:")) {
                String[] tagLines;
                if (!headerLine.contains("tag") || (tagLines = headerLine.split("tag=")).length <= 1) continue;
                this.localTag = tagLines[1];
                continue;
            }
            if (headerLine.toLowerCase().startsWith("via:")) {
                String[] viaLines;
                for (String viaLine : viaLines = headerLine.split(";")) {
                    if (viaLine.contains("received")) {
                        this.localHost = viaLine.replace("received=", "");
                        continue;
                    }
                    if (!viaLine.contains("branch")) continue;
                    this.branchID = viaLine.replace("branch=", "");
                }
                continue;
            }
            if (headerLine.toLowerCase().startsWith("call-id:")) {
                this.callIDLine = headerLine;
                continue;
            }
            if (headerLine.toLowerCase().startsWith("cseq:")) {
                this.cseqLine = headerLine;
                continue;
            }
            if (!headerLine.toLowerCase().startsWith("content-length")) continue;
            try {
                this.contentLength = Integer.parseInt(headerLine.split(" ")[1]);
                if (this.contentLength <= 0) continue;
                int index = response.indexOf("\r\n");
                this.body = response.substring(index + 2, index + 2 + this.contentLength);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected String getData() {
        if (this.header != null && !this.header.isEmpty()) {
            return this.header;
        }
        return this.getHeader();
    }

    protected static SipMessage createSipMessage(String response) {
        String[] headerAndBody = response.split("\r\n\r\n");
        String[] headerLines = headerAndBody[0].split("\r\n");
        SipMessage sipMessage = headerLines[0].toLowerCase().contains("ringing") ? new SipMessageRinging(response) : (headerLines[0].toLowerCase().contains("ok") ? new SipMessageOK(response) : (headerLines[0].toLowerCase().contains("unauthorized") ? new SipMessageUnauthorized(response) : (headerLines[0].toLowerCase().contains("bye") ? new SipMessageBye(response) : (headerLines[0].toLowerCase().contains("info") ? new SipMessageInfo(response) : (headerLines[0].toLowerCase().contains("busy here") ? new SipMessageBusy(response) : new SipMessage(response))))));
        sipMessage.header = headerAndBody[0];
        if (headerAndBody.length > 1) {
            sipMessage.body = headerAndBody[1];
        }
        return sipMessage;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getVia() {
        return this.via;
    }

    public void setVia(String via) {
        this.via = via;
    }

    public String getMaxForwards() {
        return this.maxForwards;
    }

    public void setMaxForwards(String maxForwards) {
        this.maxForwards = maxForwards;
    }

    public String getUriUserId() {
        return this.uriUserId;
    }

    public void setUriUserId(String uriUserId) {
        this.uriUserId = uriUserId;
    }

    public String getMyUserID() {
        return this.myUserID;
    }

    public void setMyUserId(String myUserId) {
        this.myUserID = myUserId;
    }

    public String getCallID() {
        return this.callID;
    }

    public void setCallID(String callID) {
        this.callID = callID;
    }

    public int getcSeq() {
        return this.cSeq;
    }

    public void setcSeq(int cSeq) {
        this.cSeq = cSeq;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public String getBranchID() {
        return this.branchID;
    }

    public void setBranchID(String branchID) {
        this.branchID = branchID;
    }

    protected String getSipUri() {
        return this.uriUserId + "@" + this.networkParameter.getHost() + ":" + this.remotePort;
    }

    protected String getToLine() {
        return "To: <sip:" + this.getSipUri() + ">" + (this.remoteTag != null ? ";tag=" + this.remoteTag : "") + "\r\n";
    }

    protected String getFromLine() {
        return "From: <sip:" + this.myUserID + "@" + this.loopback + ">;tag=" + this.localTag + "\r\n";
    }

    protected String getViaLine() {
        return "Via: SIP/2.0/UDP " + this.localHost + ":" + this.localPort + ";branch=" + this.branchID + ";rport" + "\r\n";
    }

    protected String getCallIdLine() {
        return "Call-ID: " + this.callID + "@" + this.loopback + "\r\n";
    }

    protected String getContactLine() {
        return "Contact: <sip:" + this.myUserID + "@" + this.localHost + ":" + this.localPort + ">" + "\r\n";
    }

    protected String getMaxForwardsLine() {
        return "Max-Forwards: 70\r\n";
    }

    protected String getContentTypeLine() {
        return "Content-Type: application/sdp\r\n";
    }

    protected String getContentLengthLine() {
        return "Content-Length: " + this.getBody().length() + "\r\n";
    }

    public String getLocalTag() {
        return this.localTag;
    }

    public void setLocalTag(String localTag) {
        this.localTag = localTag;
    }

    public String getRemoteTag() {
        return this.remoteTag;
    }

    public void setRemoteTag(String remoteTag) {
        this.remoteTag = remoteTag;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public void setLocalHost(String localHost) {
        this.localHost = localHost;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getcSeqCommand() {
        if (this.cSeqCommand.isEmpty()) {
            return this.command;
        }
        return this.cSeqCommand;
    }

    public void setcSeqCommand(String cSeqCommand) {
        this.cSeqCommand = cSeqCommand;
    }

    public String getCallIDLine() {
        return this.callIDLine;
    }

    public String getCseqLine() {
        return this.cseqLine;
    }

    protected String getHeader() {
        return this.header;
    }

    protected void setAuthenticationLine(String authentication) {
        this.authenticationLine = authentication;
    }

    protected String getAuthenticationLine() {
        return this.authenticationLine;
    }

    protected String getFirstHeaderLine() {
        return this.command + " sip:" + this.getSipUri() + " SIP/2.0" + "\r\n";
    }

    protected String getCSeqLine() {
        return "CSeq: " + this.getcSeq() + " " + this.getcSeqCommand() + "\r\n";
    }

    protected String getUserAgentLine() {
        return "User-Agent:VIVOSIPUA v0.1\r\n";
    }
}

