/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.device.shared.BitInputStream;
import de.seetec.v5.re.cm.device.shared.Device;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerIntf;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPHandlerSuper;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPResponse;
import de.seetec.v5.re.cm.device.shared.net.rtsp.RTSPStreamSettings;
import de.seetec.v5.re.cm.device.shared.net.rtsp.mikey.Mikey;
import de.seetec.v5.re.cm.device.shared.videosource.RtpPacket;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekOnvifTriggerHandler;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartDevice;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartEvent;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartHelper;
import de.seetec.v5.re.shared.TransmissionType;
import de.seetec.v5.shared.Basic;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.ConfigurationException;
import de.seetec.v5.shared.util.SeeTecException;
import java.io.EOFException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class VivotekSmartTriggerHandler
extends GenericEventTriggerHandler
implements RTSPHandlerIntf {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartTriggerHandler";
    private final Semaphore semaphore = new Semaphore(1);
    private NetworkParameter networkParameter = null;
    private RTSPHandlerSuper rtspHandler = null;
    private final byte[] receiverReport = new byte[32];
    private boolean isShutdown = true;
    private MotionRecording motionRecording;
    private VivotekOnvifTriggerHandler vivotekOnvifTriggerHandler;
    private final Map<GenericEventTriggerCnf, GenericEventTriggerCnf> activeTrigger = Collections.synchronizedMap(new HashMap());
    private boolean metadataStreamEnabled = true;
    private String tempData = "";

    public VivotekSmartTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
        this.motionRecording = motionRecording;
    }

    public boolean isMetadataStreamEnabled() {
        return this.metadataStreamEnabled;
    }

    @Override
    public int shutdown() {
        if (this.isShutdown) {
            return 0;
        }
        this.isShutdown = true;
        if (this.rtspHandler != null) {
            this.rtspHandler.shutdown();
            this.rtspHandler = null;
        }
        if (this.vivotekOnvifTriggerHandler != null) {
            this.vivotekOnvifTriggerHandler.shutdown();
            this.vivotekOnvifTriggerHandler = null;
        }
        this.activeTrigger.clear();
        super.shutdown();
        return 0;
    }

    @Override
    public int init(Device device, List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        try {
            this.device = device;
            this.core = device.getCore();
            this.genericEventTriggerCnfs = genericEventTriggerCnfs;
            if (this.device instanceof VivotekSmartDevice) {
                this.networkParameter = ((VivotekSmartDevice)this.device).getNetworkParameter();
            }
            if (this.isSupportingVca()) {
                this.vivotekOnvifTriggerHandler = new VivotekOnvifTriggerHandler(this.motionRecording);
                this.vivotekOnvifTriggerHandler.setDevice((VivotekSmartDevice)device);
                this.vivotekOnvifTriggerHandler.setEventTriggerConfigurations(this.genericEventTriggerCnfs);
                this.vivotekOnvifTriggerHandler.setCore(device.getCore());
                this.vivotekOnvifTriggerHandler.init();
            }
            if (this.initAndStartRTSPHandler() != 0) {
                this.logger.error("This Vivotek device does not support Meta Data Stream. Using Meta Data from Video Streams instead for " + device);
                this.metadataStreamEnabled = false;
                return 0;
            }
        }
        catch (SeeTecException ex) {
            this.logger.error(ex.getMessage() + " for " + this);
            return -21600;
        }
        this.isShutdown = false;
        return 0;
    }

    private int initAndStartRTSPHandler() throws SeeTecException {
        String rtspUrl = "rtsp://" + this.networkParameter.getHost() + "/live.sdp";
        RTSPStreamSettings rtspStreamSettings = new RTSPStreamSettings();
        rtspStreamSettings.init(this, this, this.networkParameter, 554, rtspUrl, false, TransmissionType.RTP_OVER_UDP_UNICAST, this.networkParameter.getSoTimeout());
        rtspStreamSettings.setIsVideoEnabled(false);
        rtspStreamSettings.enableMetadata(this);
        rtspStreamSettings.setMetadataTimeout(0);
        this.rtspHandler = rtspStreamSettings.getRTSPHandler();
        return this.rtspHandler.start();
    }

    private void reinitialize() {
        if (this.isShutdown) {
            return;
        }
        if (!this.semaphore.tryAcquire()) {
            return;
        }
        if (this.vivotekOnvifTriggerHandler != null) {
            this.vivotekOnvifTriggerHandler.reinitialize();
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (VivotekSmartTriggerHandler.this.rtspHandler != null) {
                        VivotekSmartTriggerHandler.this.rtspHandler.shutdown();
                    }
                    VivotekSmartTriggerHandler.this.semaphore.release();
                    int errorCode = VivotekSmartTriggerHandler.this.initAndStartRTSPHandler();
                    if (errorCode != 0) {
                        VivotekSmartTriggerHandler.this.reinitialize();
                    }
                }
                catch (SeeTecException ex) {
                    VivotekSmartTriggerHandler.this.reinitialize();
                }
            }
        }, "VivotekReInitializeTrigger " + this.device).start();
    }

    @Override
    public void processData(byte[] data) {
        block18: {
            try {
                if (data.length >= 14 && data[0] == -128 && data[1] == -56) {
                    System.arraycopy(data, 4, this.receiverReport, 8, 4);
                    System.arraycopy(data, 10, this.receiverReport, 24, 4);
                    if (this.rtspHandler != null) {
                        this.rtspHandler.sendReceiverReportMetadata(this.receiverReport);
                    }
                    break block18;
                }
                System.arraycopy(data, 8, this.receiverReport, 8, 4);
                System.arraycopy(data, 2, this.receiverReport, 18, 2);
                if (this.rtspHandler != null) {
                    this.rtspHandler.storeReceiverReportMetadata(this.receiverReport);
                }
                RtpPacket rtpPacket = new RtpPacket(data);
                String xmlData = new String(rtpPacket.getContent());
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                db.setErrorHandler(new DefaultHandler());
                Document xmlDocument = null;
                if (!this.tempData.isEmpty()) {
                    xmlData = this.tempData + xmlData;
                    this.tempData = "";
                }
                try {
                    xmlDocument = db.parse(new InputSource(new StringReader(xmlData)));
                }
                catch (Exception ex) {
                    if (ex instanceof SAXParseException) {
                        this.tempData = xmlData;
                    }
                    this.logger.warn(ex.getMessage());
                    this.logger.info(xmlData);
                }
                List triggerEvents = this.genericEventTriggerCnfs;
                for (GenericEventTriggerCnf triggerEvent : triggerEvents) {
                    String eventName;
                    String extendedEventName;
                    if (triggerEvent == null || !triggerEvent.isEnabled() || !xmlData.contains(extendedEventName = VivotekSmartEvent.getExtendedEventName(eventName = triggerEvent.getGenericEventTriggerType()))) continue;
                    if (xmlData.contains("TrendMicroIoTSecurity")) {
                        this.forwardTrigger(triggerEvent);
                        continue;
                    }
                    String path = "//Source/SimpleItem/@Value";
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    int videoSource = 0;
                    try {
                        String source = (String)xPath.compile(path).evaluate(xmlDocument, XPathConstants.STRING);
                        if (source.toLowerCase().contains("videosource")) {
                            videoSource = Integer.parseInt(source.toLowerCase().replace("videosource", "")) + 1;
                        }
                    }
                    catch (Exception ex) {
                        this.logger.error("Could not read attributes from " + this);
                        this.logger.error((Object)ex, (Throwable)ex);
                    }
                    if (videoSource != triggerEvent.getSourceNumber()) continue;
                    if (eventName.toLowerCase().contains("video motion detection")) {
                        int windowNumber = 1;
                        path = "//Source/SimpleItem[@Name='MotionWindowIndex']/@Value";
                        xPath = XPathFactory.newInstance().newXPath();
                        try {
                            String window = (String)xPath.compile(path).evaluate(xmlDocument, XPathConstants.STRING);
                            if (window.isEmpty() || !eventName.contains(Integer.toString(windowNumber = Integer.parseInt(window) + 1))) continue;
                            path = "//Data/SimpleItem[@Name='Level']/@Value";
                            xPath = XPathFactory.newInstance().newXPath();
                            String level = (String)xPath.compile(path).evaluate(xmlDocument, XPathConstants.STRING);
                            if ((!eventName.toLowerCase().contains("ended") || level.toLowerCase().equals("trigger")) && (eventName.toLowerCase().contains("ended") || !level.toLowerCase().equals("trigger"))) continue;
                            this.forwardTrigger(triggerEvent);
                        }
                        catch (Exception ex) {
                            this.logger.error("Could not read attributes from " + this);
                            this.logger.error((Object)ex, (Throwable)ex);
                        }
                        continue;
                    }
                    this.forwardTrigger(triggerEvent);
                }
            }
            catch (ConfigurationException ex) {
                this.logger.error("Reading configuration from " + this.device + " failed");
                this.logger.error((Object)ex, (Throwable)ex);
            }
            catch (Exception ex) {
                this.logger.error("Exception while unmarshalling Object: " + ex.getMessage());
            }
        }
    }

    @Override
    public void onNetworkError(int errorCode) {
        this.sendStatusService(-21659);
        this.logger.info("Stopping re-triggering of generic event triggers because of network error [" + errorCode + "] for " + this);
        this.activeTrigger.clear();
        if (!this.isShutdown) {
            this.reinitialize();
        }
    }

    @Override
    public void sendStatusService(int statusCode) {
    }

    @Override
    public void sendDescribeResponse(RTSPResponse response) {
    }

    @Override
    public void setSsrcfromRtsp(String ssrc) {
    }

    @Override
    public void run() {
        for (GenericEventTriggerCnf element : this.activeTrigger.keySet()) {
            try {
                this.forwardTrigger(element);
            }
            catch (ConfigurationException ex) {
                this.logger.error(ex.getMessage() + " for " + this);
            }
        }
    }

    protected void processTriggerData(byte[] bytesToCheck, int videoSourceNr) {
        List triggerEvents = this.genericEventTriggerCnfs;
        for (GenericEventTriggerCnf triggerEvent : triggerEvents) {
            try {
                if (triggerEvent == null || !triggerEvent.isEnabled()) continue;
                try {
                    String eventName = triggerEvent.getGenericEventTriggerType();
                    BitInputStream bin = new BitInputStream(bytesToCheck);
                    for (int i = 1; i <= 3; ++i) {
                        if (bin.readBit() != 1) continue;
                        if (bin.readBit() == 1 && eventName.startsWith("Video motion")) {
                            int windowNumber = 1;
                            try {
                                windowNumber = Integer.parseInt(eventName.replace("Video motion detection Window ", "").replace("Video motion detection ended Window ", ""));
                            }
                            catch (NumberFormatException ex) {
                                this.logger.warn("Could not parse window number from " + eventName);
                            }
                            if (windowNumber == i && triggerEvent.getSourceNumber() == videoSourceNr) {
                                this.forwardTrigger(triggerEvent);
                            }
                        }
                        bin.skipBits(47);
                    }
                    if (eventName.toLowerCase().equals("video input signal loss")) {
                        if (bin.readBit() == 1) {
                            this.forwardTrigger(triggerEvent);
                        }
                    } else {
                        bin.skipBits(1);
                    }
                    bin.skipBits(4);
                    boolean tamperingRead = false;
                    try {
                        while (!tamperingRead) {
                            String tagString;
                            byte tag = 0;
                            for (int i = 0; i < 8; ++i) {
                                int read = bin.readBit();
                                tag = (byte)(tag | read << 7 - i);
                            }
                            switch (tagString = Basic.byteArrayToHexString((byte[])new byte[]{tag}).toLowerCase()) {
                                case "e4": {
                                    break;
                                }
                                case "10": {
                                    bin.skipBits(104);
                                    break;
                                }
                                case "11": {
                                    int length = 0;
                                    for (int i = 0; i < 8; ++i) {
                                        length = (byte)(length | bin.readBit() << 7 - i);
                                    }
                                    bin.skipBits(length * 8);
                                    break;
                                }
                                case "12": {
                                    int mdLength = 0;
                                    for (int i = 0; i < 8; ++i) {
                                        mdLength = (byte)(mdLength | bin.readBit() << 7 - i);
                                    }
                                    bin.skipBits(mdLength * 8);
                                    break;
                                }
                                case "18": {
                                    bin.skipBits(8);
                                    tamperingRead = true;
                                    if (!eventName.toLowerCase().contains("tamper") || bin.readBit() != 1) break;
                                    this.forwardTrigger(triggerEvent);
                                    break;
                                }
                            }
                        }
                    }
                    catch (EOFException eof) {
                        this.logger.debug("Exception while reading trigger data");
                    }
                }
                catch (Exception ee) {
                    this.logger.error((Object)ee, (Throwable)ee);
                    this.logger.error("Error extracting trigger info from video data for " + this);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Exception while trying to extract trigger data for " + this);
            }
        }
    }

    @Override
    public void setMikey(Mikey mikey) {
    }

    protected boolean isSupportingVca() {
        if (this.device instanceof VivotekSmartDevice) {
            try {
                String vcaFunctionList = ((VivotekSmartDevice)this.device).getHttpHandler().readGetRequest("/VCA/Functions");
                String[] vcaFunctions = VivotekSmartHelper.cleanAndDivide(vcaFunctionList);
                if (vcaFunctions.length > 0) {
                    return true;
                }
            }
            catch (Exception ex) {
                this.logger.info("Exception while retrieving VCA capabilities. VCA will not be supported for " + this);
            }
        }
        return false;
    }
}

