/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecDefinitionType;
import de.seetec.v5.re.cm.configuration.definition.device.AudioCodecsType;
import de.seetec.v5.re.cm.configuration.definition.device.CameraResolutionType;
import de.seetec.v5.re.cm.configuration.definition.device.CodecType;
import de.seetec.v5.re.cm.configuration.definition.device.MultiStreamingDefinitionsType;
import de.seetec.v5.re.cm.configuration.definition.device.StreamDefinitionType;
import de.seetec.v5.re.shared.Codec;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.List;

public final class VivotekSmartHelper {
    private VivotekSmartHelper() {
    }

    public static String[] getMultipleParameterValues(String data, String parameter) {
        if (parameter != null && !parameter.isEmpty() && data != null && !data.isEmpty()) {
            String[] dataLines;
            for (String dataLine : dataLines = data.replace("'", "").split("\r\n")) {
                String[] dataLineParts;
                if (!dataLine.contains(parameter + "=") || (dataLineParts = dataLine.split("=")).length != 2) continue;
                return dataLineParts[1].split(",");
            }
        }
        return new String[0];
    }

    public static String getParameterValue(String data, String parameter) {
        String[] result = VivotekSmartHelper.getMultipleParameterValues(data, parameter);
        if (result.length > 0) {
            return result[0];
        }
        return "";
    }

    public static int[] getMultipleParameterNumericalValues(String data, String parameter) {
        String[] result = VivotekSmartHelper.getMultipleParameterValues(data, parameter);
        if (result.length > 0) {
            int[] numericalResult = new int[result.length];
            for (int i = 0; i < result.length; ++i) {
                try {
                    numericalResult[i] = Integer.parseInt(result[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    return new int[0];
                }
            }
            return numericalResult;
        }
        return new int[0];
    }

    public static int getParameterNumericalValue(String data, String parameter) throws SeeTecException {
        String numericalValue = VivotekSmartHelper.getParameterValue(data, parameter);
        try {
            return Integer.parseInt(numericalValue);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SeeTecException(-20002, "Could not get numerical value for parameter " + parameter);
        }
    }

    public static CameraResolutionType getBiggestResolution(MultiStreamingDefinitionsType multiStreamingDefinitionsType) {
        if (multiStreamingDefinitionsType == null) {
            return null;
        }
        CameraResolutionType result = null;
        List<StreamDefinitionType> streamDefinitionList = multiStreamingDefinitionsType.getStreamDefinition();
        for (StreamDefinitionType streamDefinitionType : streamDefinitionList) {
            List<CameraResolutionType> cameraResolutionTypeList = streamDefinitionType.getSupportedCameraResolutions().getCameraResolution();
            for (CameraResolutionType cameraResolutionType : cameraResolutionTypeList) {
                if (result != null && result.getHeight() * result.getWidth() >= cameraResolutionType.getHeight() * cameraResolutionType.getWidth()) continue;
                result = cameraResolutionType;
            }
        }
        return result;
    }

    public static AudioCodecsType getAudioCodecs(String capabilities) {
        String[] codecs;
        AudioCodecsType audioCodecsType = new AudioCodecsType();
        for (String codec : codecs = VivotekSmartHelper.getMultipleParameterValues(capabilities, "capability_audioin_codec")) {
            if (!codec.equals("g711")) continue;
            AudioCodecDefinitionType audioCodecDefinitionType = new AudioCodecDefinitionType();
            CodecType codecType = new CodecType();
            codecType.setValue(Codec.G711U.getType());
            audioCodecDefinitionType.setAudioCodec(codecType);
            audioCodecDefinitionType.setBitrate(64000);
            audioCodecsType.getAudioCodecDefinition().add(audioCodecDefinitionType);
        }
        return audioCodecsType;
    }

    public static int getNextValue(int[] allowedValues, int value, int bandwidthLimit) {
        block3: {
            block2: {
                if (value <= bandwidthLimit) break block2;
                for (int i = allowedValues.length - 1; i >= 0; --i) {
                    if (allowedValues[i] >= value) continue;
                    return allowedValues[i];
                }
                break block3;
            }
            if (value >= bandwidthLimit) break block3;
            for (int i = 0; i < allowedValues.length; ++i) {
                if (allowedValues[i] <= value) continue;
                return allowedValues[i];
            }
        }
        return value;
    }

    public static int getNumberOfMotionWindows(String capabilities) {
        if (capabilities != null) {
            for (int i = 0; i < 32; ++i) {
                if (capabilities.contains("motion_c0_win_i" + i)) continue;
                return i;
            }
        }
        return 0;
    }

    public static String matchTriggerName(String trigger) {
        switch (trigger) {
            case "tns1:RuleEngine/ivs:CrowdDetector/tnsvca:ObjectIsCrowd": {
                return "CrowdDetection";
            }
            case "tns1:RuleEngine/ObjectDetector/Face": {
                return "FaceDetection";
            }
            case "tns1:RuleEngine/FieldDetector/ObjectsInside": {
                return "IntrusionDetection(FieldDetection)";
            }
            case "tns1:RuleEngine/LineDetector/Crossed": {
                return "LineCrossingDetection";
            }
            case "tns1:RuleEngine/LoiteringDetector/ObjectIsLoitering": {
                return "LoiteringDetection";
            }
            case "tns1:RuleEngine/MissingDetector/ObjectsMissing": {
                return "MissingObjectDetection";
            }
            case "tns1:RuleEngine/ParkingDetector/Violated": {
                return "ParkingViolationDetection";
            }
            case "tns1:RuleEngine/RestrictedDetector/ObjectIsRestricted": {
                return "RestrictedZoneDetection";
            }
            case "tns1:RuleEngine/RunningDetector/ObjectIsRunning": {
                return "RunningDetection";
            }
            case "tns1:RuleEngine/AbandonDetector/ObjectsAbandoned": {
                return "UnattendedObjectDetection(AbandonObject)";
            }
        }
        return "";
    }

    public static String[] cleanAndDivide(String input) {
        String rawData = input.replace("[", "").replace("]", "").replace("\"", "").replace("\r", "").replace("\n", "");
        return rawData.split(",");
    }
}

