/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.device.shared.AudioOutServer;
import de.seetec.v5.re.cm.device.shared.net.rtp.RtpSenderPacket;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartHelper;
import de.seetec.v5.re.cm.device.video.vivotek.smart.sip.SipHandler;
import de.seetec.v5.re.shared.MediaFrame;
import de.seetec.v5.shared.net.HttpHandlerImpl;
import de.seetec.v5.shared.net.NetworkParameter;
import de.seetec.v5.shared.util.SeeTecException;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VivotekSmartAudioOutServer
extends AudioOutServer
implements Runnable {
    private final Logger logger;
    private volatile boolean isShutdown = false;
    private Thread thread;
    private Integer ssrc;
    private Integer sequenceNumber;
    private Integer timeStamp;
    private NetworkParameter networkParameter;
    private SipHandler sipHandler;

    public VivotekSmartAudioOutServer(NetworkParameter networkParameter) {
        if (networkParameter == null) {
            throw new IllegalArgumentException("NetworkParameter is null for VivotekAudioOutServer");
        }
        this.networkParameter = networkParameter;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public int init() {
        this.thread = new Thread((Runnable)this, this.getClass().getName());
        this.thread.start();
        this.logger.info(this + " initialized");
        return 0;
    }

    private void sendAudio(byte[] audioData) throws Exception {
        int pointer = 0;
        int previousPointer = 0;
        do {
            byte[] dataToSend;
            if ((pointer += 512) > audioData.length) {
                dataToSend = new byte[audioData.length - previousPointer];
                System.arraycopy(audioData, previousPointer, dataToSend, 0, audioData.length - previousPointer);
            } else {
                dataToSend = new byte[512];
                System.arraycopy(audioData, previousPointer, dataToSend, 0, 512);
                previousPointer = pointer;
                pointer += 512;
            }
            RtpSenderPacket rtpSenderPacket = new RtpSenderPacket(audioData, this.getSequenceNumber(), this.getTimeStamp(), this.getSSRC());
            int errorCode = this.sipHandler.sendRTPPacket(rtpSenderPacket);
            if (errorCode != 0) {
                throw new SeeTecException(errorCode, "Camera not reachable for audio packet");
            }
        } while (pointer < audioData.length);
    }

    @Override
    public void run() {
        while (!this.isShutdown) {
            try {
                int sipPort = 5060;
                try {
                    HttpHandlerImpl httpHandler = new HttpHandlerImpl(this.networkParameter);
                    String url = "/cgi-bin/admin/getparam.cgi?";
                    String capabilities = httpHandler.readGetRequest(url);
                    sipPort = VivotekSmartHelper.getParameterNumericalValue(capabilities, "network_sip_port");
                }
                catch (Exception ex) {
                    this.logger.warn("Error while reading sip Port. Assuming 5060 for " + this);
                }
                this.sipHandler = new SipHandler(this.networkParameter);
                this.sipHandler.setSipPort(sipPort);
                this.sipHandler.init();
                while (!this.isShutdown) {
                    try {
                        MediaFrame mediaFrameToSend = this.take();
                        for (byte[] singlePayLoad : mediaFrameToSend.getPayload()) {
                            this.sendAudio(singlePayLoad);
                        }
                    }
                    catch (Exception exception) {
                        this.logger.info("Error while sending audio packet for " + this + " : " + exception.getMessage());
                        break;
                    }
                }
                this.logger.info("Shutting down " + this);
            }
            catch (Exception ex) {
                this.logger.warn("Exception while starting RTSP handling for " + this);
            }
        }
        this.logger.info("Shutting down " + this);
    }

    @Override
    public int shutdown() {
        this.thread.interrupt();
        if (this.sipHandler != null) {
            this.sipHandler.shutdown();
            this.sipHandler = null;
        }
        return super.shutdown();
    }

    private int getSSRC() {
        if (this.ssrc == null) {
            Random r = new Random();
            this.ssrc = r.nextInt(Integer.MAX_VALUE);
        }
        return this.ssrc;
    }

    private int getSequenceNumber() {
        if (this.sequenceNumber == null) {
            Random r = new Random();
            this.sequenceNumber = r.nextInt(Short.MAX_VALUE);
        } else {
            VivotekSmartAudioOutServer vivotekSmartAudioOutServer = this;
            Integer n = vivotekSmartAudioOutServer.sequenceNumber;
            Integer n2 = vivotekSmartAudioOutServer.sequenceNumber = Integer.valueOf(vivotekSmartAudioOutServer.sequenceNumber + 1);
        }
        return this.sequenceNumber;
    }

    private int getTimeStamp() {
        if (this.timeStamp == null) {
            Random r = new Random();
            this.timeStamp = r.nextInt(Short.MAX_VALUE);
        }
        VivotekSmartAudioOutServer vivotekSmartAudioOutServer = this;
        vivotekSmartAudioOutServer.timeStamp = vivotekSmartAudioOutServer.timeStamp + 800;
        return this.timeStamp;
    }

    public String toString() {
        String returnString = super.toString();
        if (this.networkParameter != null && this.networkParameter.getHost() != null) {
            returnString = returnString + "Host: " + this.networkParameter.getHost();
        }
        return returnString;
    }
}

