/*
 * Decompiled with CFR 0.152.
 */
package de.seetec.v5.re.cm.device.video.vivotek.smart;

import de.seetec.v5.re.cm.Core;
import de.seetec.v5.re.cm.device.shared.MotionRecording;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerCnf;
import de.seetec.v5.re.cm.device.shared.genericevent.GenericEventTriggerHandler;
import de.seetec.v5.re.cm.device.shared.motiondetection.HardwareMotionDetection;
import de.seetec.v5.re.cm.device.shared.motiondetection.MotionDetectionHandler;
import de.seetec.v5.re.cm.device.shared.onvif.EventMessage;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifCore;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifDevice;
import de.seetec.v5.re.cm.device.shared.onvif.OnvifHelper;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartDevice;
import de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekSmartHelper;
import de.seetec.v5.shared.net.NetworkParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.Duration;
import org.apache.logging.log4j.LogManager;
import org.onvif.ver10.events.wsdl.PullMessagesFaultResponse;
import org.onvif.ver10.events.wsdl.PullMessagesFaultResponse_Exception;
import org.onvif.ver10.schema.VideoSource;
import org.onvif.ver10.schema.VideoSourceConfiguration;

public class VivotekOnvifTriggerHandler
extends GenericEventTriggerHandler
implements Runnable {
    private static final String CLASS_NAME = "de.seetec.v5.re.cm.device.video.vivotek.smart.VivotekOnvifTriggerHandler";
    private Thread thread = null;
    private OnvifCore onvifCore = null;
    private VivotekSmartDevice vivotekSmartDevice = null;
    private final Collection<HardwareMotionDetection<? extends MotionDetectionHandler>> hardwareMotionDetections = Collections.synchronizedList(new ArrayList());
    private int timeoutInSeconds = 5;
    private int messageLimit = 30;
    private Duration timeoutDuration = null;
    private Map<String, Integer> sources = new HashMap<String, Integer>();

    public VivotekOnvifTriggerHandler(MotionRecording motionRecording) {
        super(motionRecording);
        this.logger = LogManager.getLogger((String)this.getClass().getName());
    }

    protected OnvifCore createOnvifCore() throws Exception {
        OnvifCore newOnvifCore = new OnvifCore();
        NetworkParameter networkParameter = this.vivotekSmartDevice.getDeviceCnf().getNetworkParameter();
        OnvifDevice onvifDevice = new OnvifDevice(this.vivotekSmartDevice.getDeviceEntity().getEntityName(), networkParameter, networkParameter.getUserPWD()[0], networkParameter.getUserPWD()[1], "PasswordDigest", this.vivotekSmartDevice.getDeviceCnf().getUseAuthorization());
        newOnvifCore.init(onvifDevice, this.logger.isDebugEnabled());
        return newOnvifCore;
    }

    public int init() {
        try {
            this.onvifCore = this.createOnvifCore();
            this.timeoutDuration = OnvifHelper.intToDuration(this.timeoutInSeconds);
            List videoSources = this.onvifCore.getMediaService().getOnvifMediaService().getVideoSources();
            List videoSourceConfigurationList = this.onvifCore.getMediaService().getOnvifMediaService().getVideoSourceConfigurations();
            this.sources = this.matchVideoSourceNumbersToTokenAndName(videoSources, videoSourceConfigurationList);
        }
        catch (Exception ex) {
            this.logger.error("Exception while creating ONVIF trigger handling for " + this.vivotekSmartDevice);
            return -20001;
        }
        this.thread = new Thread((Runnable)this, CLASS_NAME);
        this.thread.start();
        return 0;
    }

    protected Map<String, Integer> matchVideoSourceNumbersToTokenAndName(List<VideoSource> videoSources, List<VideoSourceConfiguration> videoSourceConfigurationList) {
        HashMap<String, Integer> sourceMatchings = new HashMap<String, Integer>();
        if (videoSources != null) {
            for (int i = 0; i < videoSources.size(); ++i) {
                String videoSourceToken = videoSources.get(i).getToken();
                if (videoSourceConfigurationList != null) {
                    for (VideoSourceConfiguration videoSourceConfiguration : videoSourceConfigurationList) {
                        String sourceName;
                        if (!videoSourceConfiguration.getSourceToken().equals(videoSourceToken) || (sourceName = videoSourceConfiguration.getName()) == null || sourceName.isEmpty()) continue;
                        sourceMatchings.put(sourceName, i + 1);
                    }
                }
                sourceMatchings.put(videoSourceToken, i + 1);
            }
        }
        return sourceMatchings;
    }

    @Override
    public void run() {
        int tryCounter = 0;
        while (!this.vivotekSmartDevice.isShutdown()) {
            try {
                List<EventMessage> eventMessages;
                if (tryCounter > 2) {
                    Thread.sleep(TimeUnit.MINUTES.toMillis(1L));
                    this.onvifCore.getEventService().resetEventService();
                    tryCounter = 0;
                } else {
                    Thread.sleep(250L);
                }
                try {
                    eventMessages = this.onvifCore.getEventService().pullMessages(this.timeoutDuration, this.messageLimit);
                    tryCounter = 0;
                }
                catch (PullMessagesFaultResponse_Exception pullMessagesFaultResponse_Exception) {
                    ++tryCounter;
                    PullMessagesFaultResponse pullMessagesFaultResponse = pullMessagesFaultResponse_Exception.getFaultInfo();
                    if (this.timeoutInSeconds > OnvifHelper.durationToInt(pullMessagesFaultResponse.getMaxTimeout())) {
                        this.timeoutDuration = pullMessagesFaultResponse.getMaxTimeout();
                        this.timeoutInSeconds = OnvifHelper.durationToInt(this.timeoutDuration);
                    }
                    if (this.messageLimit > pullMessagesFaultResponse.getMaxMessageLimit()) {
                        this.messageLimit = pullMessagesFaultResponse.getMaxMessageLimit();
                    }
                    this.logger.warn("ONVIF FAULT : " + pullMessagesFaultResponse_Exception.getMessage() + " for " + this.vivotekSmartDevice);
                    this.logger.info("Using MaxTimeout = " + this.timeoutInSeconds + " and MaxMessageLimit = " + this.messageLimit + " " + this.vivotekSmartDevice);
                    continue;
                }
                catch (Exception exception) {
                    ++tryCounter;
                    this.logger.warn("Could not evaluate Onvif event for " + this.vivotekSmartDevice + " Error message: " + exception.getMessage());
                    continue;
                }
                for (EventMessage eventMessage : eventMessages) {
                    String eventName;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Event for " + this + " : " + eventMessage);
                    }
                    if ((eventName = VivotekSmartHelper.matchTriggerName(eventMessage.getTopic())).isEmpty()) continue;
                    List triggerEvents = this.genericEventTriggerCnfs;
                    for (GenericEventTriggerCnf triggerEvent : triggerEvents) {
                        if (triggerEvent == null || !triggerEvent.isEnabled() || !triggerEvent.getGenericEventTriggerType().equals(eventName)) continue;
                        int sourceNumber = triggerEvent.getSourceNumber();
                        if (eventMessage.getSourceValue() == null || (this.sources.get(eventMessage.getSourceValue()) == null || this.sources.get(eventMessage.getSourceValue()) != sourceNumber) && this.sources.get(eventMessage.getSourceValue()) != null || !eventName.equals(triggerEvent.getGenericEventTriggerType()) || !eventMessage.getDataValue().toLowerCase().equals("true") && !eventMessage.getDataName().equalsIgnoreCase("objectid")) continue;
                        this.forwardTrigger(triggerEvent);
                    }
                }
            }
            catch (Exception exception) {
                this.logger.warn("Error while evaluating Onvif event for " + this, (Throwable)exception);
            }
        }
    }

    void setDevice(VivotekSmartDevice device) {
        this.vivotekSmartDevice = device;
    }

    protected void setEventTriggerConfigurations(List<GenericEventTriggerCnf> genericEventTriggerCnfs) {
        this.genericEventTriggerCnfs = genericEventTriggerCnfs;
    }

    protected void setCore(Core core) {
        this.core = core;
    }

    protected void reinitialize() {
        this.init();
    }

    public String toString() {
        try {
            return this.vivotekSmartDevice.getDeviceEntity().getEntityName() + " / " + this.vivotekSmartDevice.getDeviceCnf().getHardwareHost();
        }
        catch (Exception ex) {
            return super.toString();
        }
    }
}

